/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.pde.internal.ui.preferences.ConfigurationBlock;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class ConfigurationBlock {
    private static final int HIGHLIGHT_FOCUS = 17;
    private static final int HIGHLIGHT_MOUSE = 18;
    private static final int HIGHLIGHT_NONE = 0;

    protected void addHighlight(final Composite parent, final Label labelControl, final Combo comboBox) {
        comboBox.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ConfigurationBlock.this.highlight(parent, labelControl, comboBox, 0);
            }

            public void focusGained(FocusEvent e) {
                ConfigurationBlock.this.highlight(parent, labelControl, comboBox, 17);
            }
        });
        MouseTrackAdapter labelComboListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ConfigurationBlock.this.highlight(parent, labelControl, comboBox, comboBox.isFocusControl() ? 17 : 18);
            }

            public void mouseExit(MouseEvent e) {
                if (!comboBox.isFocusControl()) {
                    ConfigurationBlock.this.highlight(parent, labelControl, comboBox, 0);
                }
            }
        };
        comboBox.addMouseTrackListener((MouseTrackListener)labelComboListener);
        labelControl.addMouseTrackListener((MouseTrackListener)labelComboListener);
        class MouseMoveTrackListener
        extends MouseTrackAdapter
        implements MouseMoveListener,
        MouseListener {
            final /* synthetic */ ConfigurationBlock this$0;
            private final /* synthetic */ Combo val$comboBox;
            private final /* synthetic */ Composite val$parent;
            private final /* synthetic */ Label val$labelControl;

            MouseMoveTrackListener(ConfigurationBlock configurationBlock, Combo combo, Composite composite, Label label) {
                this.this$0 = configurationBlock;
                this.val$comboBox = combo;
                this.val$parent = composite;
                this.val$labelControl = label;
            }

            public void mouseExit(MouseEvent e) {
                if (!this.val$comboBox.isFocusControl()) {
                    this.this$0.highlight(this.val$parent, this.val$labelControl, this.val$comboBox, 0);
                }
            }

            public void mouseMove(MouseEvent e) {
                int color = this.val$comboBox.isFocusControl() ? 17 : (this.isAroundLabel(e) ? 18 : 0);
                this.this$0.highlight(this.val$parent, this.val$labelControl, this.val$comboBox, color);
            }

            public void mouseDown(MouseEvent e) {
                if (this.isAroundLabel(e)) {
                    this.val$comboBox.setFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }

            private boolean isAroundLabel(MouseEvent e) {
                int lx = this.val$labelControl.getLocation().x;
                Rectangle c = this.val$comboBox.getBounds();
                int x = e.x;
                int y = e.y;
                boolean isAroundLabel = lx - 5 < x && x < c.x && c.y - 2 < y && y < c.y + c.height + 2;
                return isAroundLabel;
            }
        }
        MouseMoveTrackListener parentListener = new MouseMoveTrackListener(this, comboBox, parent, labelControl);
        parent.addMouseMoveListener((MouseMoveListener)parentListener);
        parent.addMouseTrackListener((MouseTrackListener)parentListener);
        parent.addMouseListener((MouseListener)parentListener);
        MouseAdapter labelClickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                comboBox.setFocus();
            }
        };
        labelControl.addMouseListener((MouseListener)labelClickListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void highlight(Composite parent, Label labelControl, Combo comboBox, int color) {
        class HighlightPainter
        implements PaintListener {
            private int fColor;
            final /* synthetic */ ConfigurationBlock this$0;
            private final /* synthetic */ Label val$labelControl;
            private final /* synthetic */ Composite val$parent;
            private final /* synthetic */ Combo val$comboBox;

            HighlightPainter(ConfigurationBlock configurationBlock, int n, Label label, Composite composite, Combo combo) {
                this.this$0 = configurationBlock;
                this.val$labelControl = label;
                this.val$parent = composite;
                this.val$comboBox = combo;
                this.fColor = n;
            }

            public void paintControl(PaintEvent e) {
                if (((GridData)this.val$labelControl.getLayoutData()).exclude) {
                    this.val$parent.removePaintListener((PaintListener)this);
                    this.val$labelControl.setData(null);
                    return;
                }
                int GAP = 7;
                int ARROW = 3;
                Rectangle l = this.val$labelControl.getBounds();
                Point c = this.val$comboBox.getLocation();
                e.gc.setForeground(e.display.getSystemColor(this.fColor));
                int x2 = c.x - GAP;
                int y = l.y + l.height / 2 + 1;
                e.gc.drawLine(l.x + l.width + GAP, y, x2, y);
                e.gc.drawLine(x2 - ARROW, y - ARROW, x2, y);
                e.gc.drawLine(x2 - ARROW, y + ARROW, x2, y);
            }
        }
        Object data = labelControl.getData();
        if (data == null) {
            if (color == 0) return;
            HighlightPainter painter = new HighlightPainter(this, color, labelControl, parent, comboBox);
            parent.addPaintListener((PaintListener)painter);
            labelControl.setData((Object)painter);
        } else if (color == 0) {
            parent.removePaintListener((PaintListener)data);
            labelControl.setData(null);
        } else {
            if (color == ((HighlightPainter)data).fColor) return;
            ((HighlightPainter)data).fColor = color;
        }
        parent.redraw();
        parent.update();
    }
}

