/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IConfigFeatureOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class ConfigOperation
extends FeatureOperation
implements IConfigFeatureOperation {
    public ConfigOperation(IConfiguredSite site, IFeature feature) {
        super(site, feature);
    }

    public boolean execute(IProgressMonitor pm, IOperationListener listener) throws CoreException {
        IStatus status = OperationsManager.getValidator().validatePendingConfig(this.feature);
        if (status != null && status.getCode() == 4) {
            throw new CoreException(status);
        }
        try {
            this.targetSite.configure(this.feature);
            boolean restartNeeded = false;
            IFeatureOperation pendingOperation = OperationsManager.findPendingOperation(this.feature);
            if (pendingOperation instanceof IUnconfigFeatureOperation) {
                OperationsManager.removePendingOperation(pendingOperation);
            } else {
                OperationsManager.addPendingOperation(this);
            }
            this.markProcessed();
            if (listener != null) {
                listener.afterExecute(this, null);
            }
            restartNeeded = SiteManager.getLocalSite().save() && restartNeeded;
            OperationsManager.fireObjectChanged(this.feature, null);
            return restartNeeded;
        }
        catch (CoreException e) {
            this.undo();
            UpdateUtils.logException(e);
            throw e;
        }
    }

    public void undo() throws CoreException {
        this.targetSite.unconfigure(this.feature);
    }
}

