/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.ParameterEstimator;

public class SEIRparameterEstimator
extends ParameterEstimator {
    double[] e;
    double[] r;

    public SEIRparameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        super(data);
        ArrayList<Double> sToFit = new ArrayList<Double>();
        ArrayList<Double> eToFit = new ArrayList<Double>();
        ArrayList<Double> iToFit = new ArrayList<Double>();
        ArrayList<Double> rToFit = new ArrayList<Double>();
        List sList = data.getStotals();
        List eList = data.getEtotals();
        List iList = data.getItotals();
        List rList = data.getRtotals();
        int icount = 1;
        while (icount < iList.size()) {
            iToFit.add((Double)iList.get(icount));
            eToFit.add((Double)eList.get(icount));
            sToFit.add((Double)sList.get(icount));
            rToFit.add((Double)rList.get(icount));
            ++icount;
        }
        this.numDataPoints = iToFit.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.p = new double[this.numDataPoints];
        this.s = new double[this.numDataPoints];
        this.e = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.r = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        icount = 0;
        while (icount < this.numDataPoints) {
            this.s[icount] = (Double)sToFit.get(icount);
            this.e[icount] = (Double)eToFit.get(icount);
            this.i[icount] = (Double)iToFit.get(icount);
            this.r[icount] = (Double)rToFit.get(icount);
            this.p[icount] = this.s[icount] + this.e[icount] + this.i[icount] + this.r[icount];
            this.t[icount] = icount;
            ++icount;
        }
    }

    @Override
    public ModelParameters estimate(double localDensity, double localPopulation, String locationID) {
        double eNorm;
        ModelParameters fittedParms = new ModelParameters();
        int npts = this.s.length;
        assert (npts == this.e.length);
        assert (npts == this.i.length);
        assert (npts == this.r.length);
        double[] lnS = new double[npts];
        double[] dlnS = new double[npts - 1];
        double[] lnE = new double[npts];
        double[] dlnE = new double[npts - 1];
        double[] lnI = new double[npts];
        double[] dlnI = new double[npts - 1];
        double[] lnR = new double[npts];
        double[] dlnR = new double[npts - 1];
        double[] sAvg = new double[npts - 1];
        double[] eAvg = new double[npts - 1];
        double[] iAvg = new double[npts - 1];
        double[] rAvg = new double[npts - 1];
        double[] pAvg = new double[npts - 1];
        double[][] dataS = new double[2][npts - 1];
        double[][] dataE = new double[2][npts - 1];
        double[][] dataI = new double[2][npts - 1];
        double[][] dataR = new double[2][npts - 1];
        double cutoff = 5.0E-10;
        int j = 0;
        while (j < npts) {
            lnS[j] = this.s[j] >= cutoff ? Math.log(this.s[j]) : Math.log(cutoff);
            lnE[j] = this.e[j] >= cutoff ? Math.log(this.e[j]) : Math.log(cutoff);
            lnI[j] = this.i[j] >= cutoff ? Math.log(this.i[j]) : Math.log(cutoff);
            lnR[j] = this.r[j] >= cutoff ? Math.log(this.r[j]) : Math.log(cutoff);
            ++j;
        }
        double sMax = 0.0;
        double eMax = 0.0;
        double iMax = 0.0;
        double rMax = 0.0;
        int j2 = 1;
        while (j2 < npts - 1) {
            dlnS[j2 - 1] = lnS[j2] - lnS[j2 - 1];
            dlnE[j2 - 1] = lnE[j2] - lnE[j2 - 1];
            dlnI[j2 - 1] = lnI[j2] - lnI[j2 - 1];
            dlnR[j2 - 1] = lnR[j2] - lnR[j2 - 1];
            sAvg[j2 - 1] = (this.s[j2] + this.s[j2 - 1]) / 2.0;
            eAvg[j2 - 1] = (this.e[j2] + this.e[j2 - 1]) / 2.0;
            iAvg[j2 - 1] = (this.i[j2] + this.i[j2 - 1]) / 2.0;
            rAvg[j2 - 1] = (this.r[j2] + this.r[j2 - 1]) / 2.0;
            if (sAvg[j2 - 1] >= sMax) {
                sMax = sAvg[j2 - 1];
            }
            if (eAvg[j2 - 1] >= eMax) {
                eMax = eAvg[j2 - 1];
            }
            if (iAvg[j2 - 1] >= iMax) {
                iMax = iAvg[j2 - 1];
            }
            if (rAvg[j2 - 1] >= rMax) {
                rMax = rAvg[j2 - 1];
            }
            pAvg[j2 - 1] = (this.p[j2] + this.p[j2 - 1]) / 2.0;
            ++j2;
        }
        ArrayList<Double> xList1 = new ArrayList<Double>();
        ArrayList<Double> yList1 = new ArrayList<Double>();
        ArrayList<Double> fitList1 = new ArrayList<Double>();
        int j3 = 0;
        while (j3 < npts - 1) {
            double sNorm = sAvg[j3] / sMax;
            double iNorm = iAvg[j3] / iMax;
            double rNorm = rAvg[j3] / rMax;
            eNorm = eAvg[j3] / eMax;
            dataS[0][j3] = sNorm;
            dataI[0][j3] = iNorm;
            dataR[0][j3] = rNorm;
            dataE[0][j3] = eNorm;
            dataS[1][j3] = sNorm;
            dataI[1][j3] = iNorm;
            dataR[1][j3] = rNorm;
            dataE[1][j3] = eNorm;
            if (sNorm <= maxSthreshold && sNorm >= minSthreshold && iNorm >= minIthreshold && rNorm <= maxRthreshold) {
                double numer = pAvg[j3] * rAvg[j3] / sAvg[j3];
                double xValue = numer / iAvg[j3];
                double yValue = pAvg[j3] * dlnS[j3] / iAvg[j3];
                xList1.add(new Double(xValue));
                yList1.add(new Double(yValue));
            } else {
                dataS[1][j3] = 0.0;
                dataI[1][j3] = 0.0;
                dataR[1][j3] = 0.0;
            }
            ++j3;
        }
        LinearLeastSquaresFit lineFit1 = null;
        if (xList1.size() > 2) {
            lineFit1 = new LinearLeastSquaresFit(xList1, yList1);
            double beta = -1.0 * lineFit1.getIntercept();
            double varBeta = lineFit1.getInterceptVariance();
            double stdBeta = lineFit1.getInterceptStdDev();
            double alpha = lineFit1.getSlope();
            double varAlpha = lineFit1.getSlopeVariance();
            double stdAlpha = lineFit1.getSlopeStdDev();
            double newbeta = beta;
            if (!useFreqDependantBeta) {
                newbeta *= 100.0 / localDensity;
            }
            fittedParms.addParameter("beta", new Parameter("beta", newbeta, stdBeta, varBeta));
            fittedParms.addParameter("alpha", new Parameter("alpha", alpha, stdAlpha, varAlpha));
            int i = 0;
            while (i < xList1.size()) {
                double val = lineFit1.getSlope() * (Double)xList1.get(i) + lineFit1.getIntercept();
                fitList1.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> xList2 = new ArrayList<Double>();
        ArrayList<Double> yList2 = new ArrayList<Double>();
        ArrayList<Double> fitList2 = new ArrayList<Double>();
        int j4 = 0;
        while (j4 < npts - 1) {
            double sNorm = sAvg[j4] / sMax;
            eNorm = eAvg[j4] / eMax;
            if (sNorm <= maxSthreshold && sNorm >= minSthreshold && eNorm >= minEthreshold) {
                double xValue = sAvg[j4] * iAvg[j4] / (pAvg[j4] * eAvg[j4]);
                double yValue = dlnE[j4];
                xList2.add(new Double(xValue));
                yList2.add(new Double(yValue));
            } else {
                dataE[1][j4] = 0.0;
            }
            ++j4;
        }
        LinearLeastSquaresFit lineFit2 = null;
        if (xList2.size() > 2) {
            lineFit2 = new LinearLeastSquaresFit(xList2, yList2);
            double epsilon = -1.0 * lineFit2.getIntercept();
            double varEpsilon = lineFit2.getInterceptVariance();
            double stdEpsilon = lineFit2.getInterceptStdDev();
            double beta2 = lineFit2.getSlope();
            double varBeta2 = lineFit2.getSlopeVariance();
            double stdBeta2 = lineFit2.getSlopeStdDev();
            double newbeta2 = beta2;
            if (!useFreqDependantBeta) {
                newbeta2 *= 100.0 / localDensity;
            }
            fittedParms.addParameter("beta2", new Parameter("beta2", newbeta2, stdBeta2, varBeta2));
            fittedParms.addParameter("epsilon", new Parameter("epsilon", epsilon, stdEpsilon, varEpsilon));
            int i = 0;
            while (i < xList2.size()) {
                double val = lineFit2.getSlope() * (Double)xList2.get(i) + lineFit2.getIntercept();
                fitList2.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> xList3 = new ArrayList<Double>();
        ArrayList<Double> yList3 = new ArrayList<Double>();
        ArrayList<Double> fitList3 = new ArrayList<Double>();
        int j5 = 0;
        while (j5 < npts - 1) {
            double iNorm = iAvg[j5] / iMax;
            double eNorm2 = eAvg[j5] / eMax;
            if (iNorm >= minIthreshold && eNorm2 >= minEthreshold) {
                xList3.add(new Double(eAvg[j5] / iAvg[j5]));
                yList3.add(new Double(dlnI[j5]));
            }
            ++j5;
        }
        LinearLeastSquaresFit lineFit3 = null;
        if (xList3.size() > 2) {
            lineFit3 = new LinearLeastSquaresFit(xList3, yList3);
            double gamma = -1.0 * lineFit3.getIntercept();
            double varGamma = lineFit3.getInterceptVariance();
            double stdGamma = lineFit3.getInterceptStdDev();
            double epsilon2 = lineFit3.getSlope();
            double varEpsilon2 = lineFit3.getSlopeVariance();
            double stdEpsilon2 = lineFit3.getSlopeStdDev();
            fittedParms.addParameter("gamma", new Parameter("gamma", gamma, stdGamma, varGamma));
            fittedParms.addParameter("epsilon2", new Parameter("epsilon2", epsilon2, stdEpsilon2, varEpsilon2));
            int i = 0;
            while (i < xList3.size()) {
                double val = lineFit3.getSlope() * (Double)xList3.get(i) + lineFit3.getIntercept();
                fitList3.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> xList4 = new ArrayList<Double>();
        ArrayList<Double> yList4 = new ArrayList<Double>();
        ArrayList<Double> fitList4 = new ArrayList<Double>();
        int j6 = 0;
        while (j6 < npts - 1) {
            double iNorm = iAvg[j6] / iMax;
            double rNorm = rAvg[j6] / rMax;
            if (iNorm >= minIthreshold && rNorm >= minRthreshold && rNorm <= maxRthreshold) {
                xList4.add(new Double(iAvg[j6] / rAvg[j6]));
                yList4.add(new Double(dlnR[j6]));
            }
            ++j6;
        }
        LinearLeastSquaresFit lineFit4 = null;
        if (xList4.size() > 2) {
            lineFit4 = new LinearLeastSquaresFit(xList4, yList4);
            double alpha2 = Math.abs(-1.0 * lineFit4.getIntercept());
            double varAlpha2 = lineFit4.getInterceptVariance();
            double stdAlpha2 = lineFit4.getInterceptStdDev();
            double gamma2 = lineFit4.getSlope();
            double varGamma2 = lineFit4.getSlopeVariance();
            double stdGamma2 = lineFit4.getSlopeStdDev();
            fittedParms.addParameter("alpha2", new Parameter("alpha2", alpha2, stdAlpha2, varAlpha2));
            fittedParms.addParameter("gamma2", new Parameter("gamma2", gamma2, stdGamma2, varGamma2));
            int i = 0;
            while (i < xList4.size()) {
                double val = lineFit4.getSlope() * (Double)xList4.get(i) + lineFit4.getIntercept();
                fitList4.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        fittedParms.addParameter("rejected", new Parameter("rejected", this.rejectCount));
        this.dataToPlot.add(dataS);
        this.dataToPlot.add(dataI);
        this.dataToPlot.add(dataR);
        this.dataToPlot.add(dataE);
        fittedParms.addSelectedData(locationID, this.dataToPlot);
        double[][] regression1 = this.getSortedRegression(xList1, yList1);
        double[][] regression2 = this.getSortedRegression(xList2, yList2);
        double[][] regression3 = this.getSortedRegression(xList3, yList3);
        double[][] regression4 = this.getSortedRegression(xList4, yList4);
        double[][] fit1 = this.getSortedRegression(xList1, fitList1);
        double[][] fit2 = this.getSortedRegression(xList2, fitList2);
        double[][] fit3 = this.getSortedRegression(xList3, fitList3);
        double[][] fit4 = this.getSortedRegression(xList4, fitList4);
        this.regressionValues.add(regression1);
        this.regressionValues.add(regression2);
        this.regressionValues.add(regression3);
        this.regressionValues.add(regression4);
        this.fittedValues.add(fit1);
        this.fittedValues.add(fit2);
        this.fittedValues.add(fit3);
        this.fittedValues.add(fit4);
        fittedParms.addRegressionData(locationID, this.regressionValues);
        fittedParms.addFittedData(locationID, this.fittedValues);
        return fittedParms;
    }

    @Override
    public int getNumProperties() {
        return 4;
    }
}

