/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.controls;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.ui.wizards.InheritedColumnLabelProvider;
import org.eclipse.stem.model.ui.wizards.ModelParamEditorDialog;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ModelParametersEditorDialog
extends TitleAreaDialog {
    protected TableViewer modelParamViewer;
    protected Label modelParamInformationLabel;
    protected Button addParamButton;
    protected Button editParamButton;
    protected Button removeParamButton;
    protected Model modelOriginal;
    protected Model modelCopy;

    public ModelParametersEditorDialog(Shell parentShell, Model model) {
        super(parentShell);
        this.modelOriginal = model;
        this.modelCopy = (Model)EcoreUtil.copy((EObject)model);
    }

    public void create() {
        super.create();
        this.setTitle("Edit Model");
        this.setMessage("Edit the parameters for the computational model");
        this.modelParamViewer.setInput((Object)this.modelCopy);
    }

    protected void okPressed() {
        this.modelOriginal.getParameters().clear();
        this.modelOriginal.getParameters().addAll((Collection)this.modelCopy.getParameters());
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(3, false));
        this.createModelParamsTable(container);
        this.addParamButton = new Button(container, 8);
        this.addParamButton.setEnabled(true);
        this.addParamButton.setText("Add Parameter");
        this.addParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelParametersEditorDialog.this.addParam();
            }
        });
        this.editParamButton = new Button(container, 8);
        this.editParamButton.setEnabled(false);
        this.editParamButton.setText("Edit Parameter");
        this.editParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelParametersEditorDialog.this.editParam();
            }
        });
        this.removeParamButton = new Button(container, 8);
        this.removeParamButton.setEnabled(false);
        this.removeParamButton.setText("Remove Parameter");
        this.removeParamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelParametersEditorDialog.this.removeParam();
            }
        });
        return parent;
    }

    private ModelParam openModelParamDialog(ModelParam param) {
        ModelParam originalParam = param;
        param = param == null ? MetamodelFactory.eINSTANCE.createModelParam() : (ModelParam)EcoreUtil.copy((EObject)param);
        ModelParamEditorDialog editorDialog = new ModelParamEditorDialog(this.getShell(), 0, this.modelCopy, param, originalParam);
        if (editorDialog.open() == 0) {
            return param;
        }
        return null;
    }

    private void addParam() {
        ModelParam param = this.openModelParamDialog(null);
        if (param != null) {
            this.modelCopy.getParameters().add((Object)param);
            this.modelParamViewer.refresh();
        }
    }

    private void editParam() {
        ModelParam selected = this.getSelectedParameter();
        if (selected != null) {
            if (!this.inherited(selected)) {
                ModelParam param = this.openModelParamDialog(selected);
                if (param != null) {
                    Collections.replaceAll(this.modelCopy.getParameters(), selected, param);
                    this.modelParamViewer.refresh();
                }
                if (param != null) {
                    this.modelCopy.getParameters().remove((Object)selected);
                    this.modelCopy.getParameters().add((Object)param);
                    this.modelParamViewer.refresh();
                }
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Edit Parameter", (String)"You cannot edit a parameter inherited from another model.");
            }
        }
    }

    private void removeParam() {
        ModelParam selected = this.getSelectedParameter();
        if (selected != null) {
            this.modelCopy.getParameters().remove((Object)selected);
            this.modelParamViewer.refresh();
        }
    }

    private void toggleButtons(boolean forceDisable) {
        boolean toggle = false;
        if (!forceDisable) {
            ModelParam param = this.getSelectedParameter();
            toggle = param != null && !this.inherited(param);
        }
        this.editParamButton.setEnabled(toggle);
        this.removeParamButton.setEnabled(toggle);
    }

    private ModelParam getSelectedParameter() {
        return (ModelParam)((StructuredSelection)this.modelParamViewer.getSelection()).getFirstElement();
    }

    private void createModelParamsTable(Composite container) {
        this.modelParamViewer = new TableViewer(container, 68352);
        this.modelParamViewer.setUseHashlookup(true);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.modelParamViewer.getControl().setLayoutData((Object)gridData);
        this.modelParamViewer.setContentProvider((IContentProvider)new ModelParamTableContentProvider());
        this.modelParamViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelParametersEditorDialog.this.toggleButtons(false);
            }
        });
        this.modelParamViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelParametersEditorDialog.this.editParam();
            }
        });
        Table table = this.modelParamViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn viewerColumn = null;
        TableColumn column = null;
        viewerColumn = new TableViewerColumn(this.modelParamViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Name");
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelParamColumnLabelProvider(){

            public String getText(Object element) {
                return ((ModelParam)element).getName();
            }
        });
        viewerColumn = new TableViewerColumn(this.modelParamViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Type");
        column.setWidth(100);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelParamColumnLabelProvider(){

            public String getText(Object element) {
                return ((ModelParam)element).getDataType().getName();
            }
        });
        viewerColumn = new TableViewerColumn(this.modelParamViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Default Value");
        column.setWidth(100);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelParamColumnLabelProvider(){

            public String getText(Object element) {
                ModelParam mp = (ModelParam)element;
                if (mp.getDefaultValue() != null) {
                    return mp.getDefaultValue();
                }
                return "";
            }
        });
        viewerColumn = new TableViewerColumn(this.modelParamViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Inherited From");
        column.setWidth(100);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelParamColumnLabelProvider(){

            public String getText(Object element) {
                ModelParam mp = (ModelParam)element;
                if (ModelParametersEditorDialog.this.inherited(mp) && mp.getContainerModel() != null) {
                    return mp.getContainerModel().getName();
                }
                return "";
            }
        });
        this.modelParamViewer.setComparator(new ViewerComparator(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof ModelParam && o2 instanceof ModelParam) {
                            ModelParam p1 = (ModelParam)o1;
                            ModelParam p2 = (ModelParam)o2;
                            if (!ModelParametersEditorDialog.this.inherited(p1) && ModelParametersEditorDialog.this.inherited(p2)) {
                                return -1;
                            }
                            if (ModelParametersEditorDialog.this.inherited(p1) && !ModelParametersEditorDialog.this.inherited(p2)) {
                                return 1;
                            }
                        }
                        return 0;
                    }
                });
            }
        });
    }

    private boolean inherited(ModelParam param) {
        return param.getContainerModel() != this.modelCopy;
    }

    private class ModelParamColumnLabelProvider
    extends InheritedColumnLabelProvider {
        protected ModelParamColumnLabelProvider() {
            super(16, 0);
        }

        protected Shell getShell() {
            return ModelParametersEditorDialog.this.getShell();
        }

        protected boolean isInherited(Object obj) {
            if (obj instanceof ModelParam) {
                return ModelParametersEditorDialog.this.inherited((ModelParam)obj);
            }
            return false;
        }
    }

    private class ModelParamTableContentProvider
    implements IStructuredContentProvider {
        private ModelParamTableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return WizardHelper.getAllParametersForModel((Model)((Model)inputElement)).toArray();
        }
    }
}

