/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.scoping.batch.AbstractFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class FeatureScopeSessionWithStaticTypes
extends FeatureScopeSession {
    private final List<JvmType> staticFeatureProviders;
    private final List<JvmType> extensionProviders;

    public FeatureScopeSessionWithStaticTypes(AbstractFeatureScopeSession featureScopeSession, FeatureScopeProvider featureScopeProvider, List<JvmType> staticFeatureProviders, List<JvmType> extensionProviders) {
        super(featureScopeSession, featureScopeProvider);
        this.staticFeatureProviders = staticFeatureProviders;
        this.extensionProviders = extensionProviders;
    }

    @Override
    public List<TypeBucket> getStaticallyImportedTypes() {
        return this.createTypeBucket(this.staticFeatureProviders, super.getStaticallyImportedTypes());
    }

    @Override
    public List<TypeBucket> getStaticallyImportedExtensionTypes() {
        return this.createTypeBucket(this.extensionProviders, super.getStaticallyImportedExtensionTypes());
    }

    protected List<TypeBucket> createTypeBucket(List<JvmType> types, List<TypeBucket> parentResult) {
        if (types.isEmpty()) {
            return parentResult;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        result.add(new TypeBucket(this.getId(), types));
        result.addAll(parentResult);
        return result;
    }
}

