/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;

public class SemanticNodeProvider
implements ISemanticNodeProvider {
    protected NodesForEObjectProvider createNodesForEObjectProvider(EObject semanticObject, ICompositeNode node) {
        return new NodesForEObjectProvider(semanticObject, node);
    }

    public ISemanticNodeProvider.INodesForEObjectProvider getNodesForSemanticObject(EObject semanticObject, ICompositeNode suggestedComposite) {
        ICompositeNode actualComposite = NodeModelUtils.findActualNodeFor(semanticObject);
        if (actualComposite != null) {
            return this.createNodesForEObjectProvider(semanticObject, actualComposite);
        }
        if (suggestedComposite != null) {
            return this.createNodesForEObjectProvider(semanticObject, suggestedComposite);
        }
        return ISemanticNodeProvider.NULL_NODES_PROVIDER;
    }

    public static class NodesForEObjectProvider
    implements ISemanticNodeProvider.INodesForEObjectProvider {
        protected EObject semanticObject;
        protected ICompositeNode node;

        public NodesForEObjectProvider(EObject semanticObject, ICompositeNode node) {
            this.semanticObject = semanticObject;
            this.node = node;
        }

        public INode getNodeForMultiValue(EStructuralFeature feature, int indexInFeature, int indexAmongNonTransient, Object value) {
            List<INode> nodes = NodeModelUtils.findNodesForFeature(this.semanticObject, feature);
            if (indexAmongNonTransient >= 0 && indexAmongNonTransient < nodes.size()) {
                return nodes.get(indexAmongNonTransient);
            }
            return null;
        }

        public INode getNodeForSingelValue(EStructuralFeature feature, Object value) {
            return this.getNodeForMultiValue(feature, 0, 0, value);
        }
    }
}

