/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.awt.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class STEMColor {
    private static final float MAX_BYTE_VALUE = 255.0f;
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public STEMColor() {
        this(0.0f, 0.0f, 0.0f);
    }

    public STEMColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public STEMColor(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public STEMColor(float r, float g, float b) {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public STEMColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public float getAlpha() {
        return this.a;
    }

    public static STEMColor toSTEMColor(Color color) {
        return new STEMColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static STEMColor toSTEMColor(RGB color) {
        return new STEMColor(color.red, color.green, color.blue);
    }

    public static STEMColor toSTEMColor(org.eclipse.swt.graphics.Color color) {
        return new STEMColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Color toAWTColor() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public org.eclipse.swt.graphics.Color toSWTColor(Device device) {
        return new org.eclipse.swt.graphics.Color(device, (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f));
    }

    public String toString() {
        return "STEMColor [r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

