/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeVisitor;
import org.eclipse.emf.codegen.merge.java.facade.JAbstractType;
import org.eclipse.emf.codegen.merge.java.facade.JAnnotation;
import org.eclipse.emf.codegen.merge.java.facade.JAnnotationTypeMember;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JEnumConstant;
import org.eclipse.emf.codegen.merge.java.facade.JField;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JInitializer;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPatternDictionary
extends FacadeVisitor {
    protected static final Pattern COMMENT = Pattern.compile("/\\*.*?\\*/", 40);
    protected static final Object[] NO_ARGUMENTS = new Object[0];
    protected static final boolean DEBUG = false;
    protected JControlModel controlModel;
    protected JPackage jPackage;
    protected Map<String, JAnnotation> annotationMap;
    protected Map<String, JAnnotationTypeMember> annotationTypeMemberMap;
    protected Map<String, JEnumConstant> enumConstantMap;
    protected Map<String, JImport> importMap;
    protected Map<String, JAbstractType> abstractTypeMap;
    protected Map<String, JInitializer> initializerMap;
    protected Map<String, JField> fieldMap;
    protected Map<String, JMethod> methodMap;
    protected Map<String, Collection<JNode>> markupMap;
    protected Set<String> noImportSet;
    protected Map<JNode, String> nodeIdentifierMap;

    public JPatternDictionary(JCompilationUnit compilationUnit, JControlModel controlModel) {
        this.controlModel = controlModel;
        this.start(compilationUnit);
    }

    public void reset() {
        this.jPackage = null;
        if (this.annotationMap != null) {
            this.annotationMap.clear();
            this.annotationMap = null;
        }
        if (this.annotationTypeMemberMap != null) {
            this.annotationTypeMemberMap.clear();
            this.annotationMap = null;
        }
        if (this.enumConstantMap != null) {
            this.enumConstantMap.clear();
            this.enumConstantMap = null;
        }
        if (this.importMap != null) {
            this.importMap.clear();
            this.importMap = null;
        }
        if (this.abstractTypeMap != null) {
            this.abstractTypeMap.clear();
            this.abstractTypeMap = null;
        }
        if (this.initializerMap != null) {
            this.initializerMap.clear();
            this.initializerMap = null;
        }
        if (this.fieldMap != null) {
            this.fieldMap.clear();
            this.fieldMap = null;
        }
        if (this.methodMap != null) {
            this.methodMap.clear();
            this.methodMap = null;
        }
        if (this.markupMap != null) {
            this.markupMap.clear();
            this.markupMap = null;
        }
        if (this.noImportSet != null) {
            this.noImportSet.clear();
            this.noImportSet = null;
        }
        if (this.nodeIdentifierMap != null) {
            this.nodeIdentifierMap.clear();
            this.nodeIdentifierMap = null;
        }
    }

    public JPackage getJPackage() {
        return this.jPackage;
    }

    public Map<String, ? extends JNode> getNodeMap(JNode node) {
        if (node instanceof JAnnotation) {
            return this.getAnnotationMap();
        }
        if (node instanceof JMethod) {
            return this.getMethodMap();
        }
        if (node instanceof JField) {
            return this.getFieldMap();
        }
        if (node instanceof JImport) {
            return this.getImportMap();
        }
        if (node instanceof JEnumConstant) {
            return this.getEnumConstantMap();
        }
        if (node instanceof JAbstractType) {
            return this.getAbstractTypeMap();
        }
        if (node instanceof JAnnotationTypeMember) {
            return this.getAnnotationTypeMemberMap();
        }
        if (node instanceof JInitializer) {
            return this.getInitializerMap();
        }
        return Collections.emptyMap();
    }

    public Map<String, JImport> getImportMap() {
        if (this.importMap == null) {
            this.importMap = new HashMap<String, JImport>();
        }
        return this.importMap;
    }

    public Map<String, JAbstractType> getAbstractTypeMap() {
        if (this.abstractTypeMap == null) {
            this.abstractTypeMap = new HashMap<String, JAbstractType>();
        }
        return this.abstractTypeMap;
    }

    public Map<String, JInitializer> getInitializerMap() {
        if (this.initializerMap == null) {
            this.initializerMap = new HashMap<String, JInitializer>();
        }
        return this.initializerMap;
    }

    public Map<String, JField> getFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, JField>();
        }
        return this.fieldMap;
    }

    public Map<String, JMethod> getMethodMap() {
        if (this.methodMap == null) {
            this.methodMap = new HashMap<String, JMethod>();
        }
        return this.methodMap;
    }

    public Map<String, JAnnotation> getAnnotationMap() {
        if (this.annotationMap == null) {
            this.annotationMap = new HashMap<String, JAnnotation>();
        }
        return this.annotationMap;
    }

    public Map<String, JAnnotationTypeMember> getAnnotationTypeMemberMap() {
        if (this.annotationTypeMemberMap == null) {
            this.annotationTypeMemberMap = new HashMap<String, JAnnotationTypeMember>();
        }
        return this.annotationTypeMemberMap;
    }

    public Map<String, JEnumConstant> getEnumConstantMap() {
        if (this.enumConstantMap == null) {
            this.enumConstantMap = new HashMap<String, JEnumConstant>();
        }
        return this.enumConstantMap;
    }

    public Map<String, Collection<JNode>> getMarkupMap() {
        if (this.markupMap == null) {
            this.markupMap = new HashMap<String, Collection<JNode>>();
        }
        return this.markupMap;
    }

    public boolean isMarkedUp(Pattern markupPattern, Pattern parentMarkupPattern, JNode node) {
        return !(markupPattern != null && !this.isMarkedUp(markupPattern, node) || parentMarkupPattern != null && node.getParent() != null && !this.isMarkedUp(parentMarkupPattern, node.getParent()));
    }

    public boolean isMarkedUp(Pattern markupPattern, JNode node) {
        if (markupPattern == null) {
            return true;
        }
        for (Map.Entry<String, Collection<JNode>> markupEntry : this.getMarkupMap().entrySet()) {
            String key = markupEntry.getKey();
            if (key == null || !markupPattern.matcher(key).find() || !markupEntry.getValue().contains(node)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getNoImporterSet() {
        if (this.noImportSet == null) {
            this.noImportSet = new HashSet<String>();
        }
        return this.noImportSet;
    }

    public boolean isNoImport(JImport jImport) {
        return this.noImportSet != null && this.getNoImporterSet().contains(this.getNodeIdentifier(jImport));
    }

    @Override
    protected boolean visit(JCompilationUnit compilationUnit) {
        if (this.controlModel.getNoImportPattern() != null) {
            String contents = compilationUnit.getContents();
            int lastIndex = contents.length() - 1;
            int endIndex = contents.lastIndexOf("import");
            while (endIndex >= 0) {
                int index = endIndex + "import".length() - 1;
                if (index == lastIndex || !Character.isWhitespace(contents.charAt(index + 1))) {
                    endIndex = contents.lastIndexOf("import", endIndex - 1);
                    continue;
                }
                if ((index = contents.indexOf(59, index)) >= 0) {
                    int length = contents.length();
                    while (index < length) {
                        char character = contents.charAt(index);
                        if (character == '\n' || character == '\r') break;
                        ++index;
                    }
                    endIndex = index + 1;
                    break;
                }
                endIndex -= "import".length();
            }
            if (endIndex > 0 && endIndex < contents.length()) {
                contents = contents.substring(0, endIndex);
            }
            Matcher matcher = this.controlModel.getNoImportPattern().matcher(contents);
            while (matcher.find()) {
                this.getNoImporterSet().add(matcher.group(1));
            }
        }
        return super.visit(compilationUnit);
    }

    @Override
    protected boolean visit(JPackage jPackage) {
        this.jPackage = jPackage;
        return super.visit(jPackage);
    }

    @Override
    protected boolean visit(JAbstractType abstractType) {
        this.getAbstractTypeMap().put(this.getNodeIdentifier(abstractType), abstractType);
        return super.visit(abstractType);
    }

    @Override
    protected boolean visit(JImport jImport) {
        this.getImportMap().put(this.getNodeIdentifier(jImport), jImport);
        return super.visit(jImport);
    }

    @Override
    protected boolean visit(JInitializer initializer) {
        this.getInitializerMap().put(this.getNodeIdentifier(initializer), initializer);
        return super.visit(initializer);
    }

    @Override
    protected boolean visit(JField field) {
        this.getFieldMap().put(this.getNodeIdentifier(field), field);
        return super.visit(field);
    }

    @Override
    protected boolean visit(JMethod method) {
        this.getMethodMap().put(this.getNodeIdentifier(method), method);
        return super.visit(method);
    }

    @Override
    protected boolean visit(JAnnotation annotation) {
        this.getAnnotationMap().put(this.getNodeIdentifier(annotation), annotation);
        return super.visit(annotation);
    }

    @Override
    protected boolean visit(JAnnotationTypeMember annotationTypeMember) {
        this.getAnnotationTypeMemberMap().put(this.getNodeIdentifier(annotationTypeMember), annotationTypeMember);
        return super.visit(annotationTypeMember);
    }

    @Override
    protected boolean visit(JEnumConstant enumConstant) {
        this.getEnumConstantMap().put(this.getNodeIdentifier(enumConstant), enumConstant);
        return super.visit(enumConstant);
    }

    @Override
    protected void beforeVisit(JNode node) {
        Method previousMethod = null;
        String previousSelection = null;
        for (JControlModel.DictionaryPattern dictionaryPattern : this.controlModel.getDictionaryPatterns()) {
            JControlModel.Feature feature = dictionaryPattern.getSelectorFeature();
            Method method = feature.getFeatureMethod();
            String selection = null;
            if (feature.getFeatureClass() == null || !feature.getFeatureClass().isInstance(node)) continue;
            try {
                if (method.equals(previousMethod)) {
                    selection = previousSelection;
                } else {
                    selection = (String)method.invoke((Object)node, NO_ARGUMENTS);
                    if (this.controlModel.getFacadeHelper() == null || this.controlModel.getFacadeHelper().canYieldWrongJavadoc()) {
                        selection = this.checkSelection(selection, dictionaryPattern, node);
                    }
                    previousMethod = method;
                    previousSelection = selection;
                }
                if (selection == null) continue;
                this.markupNode(selection, dictionaryPattern, node);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    protected String checkSelection(String selection, JControlModel.DictionaryPattern dictionaryPattern, JNode node) {
        String contents;
        if (selection != null && !(node instanceof JAbstractType) && dictionaryPattern.getSelectorFeature().getFeatureMethod().getName().equals("getComment") && (contents = node.getContents()) != null) {
            int start = 0;
            int end = contents.length();
            int count = 0;
            while (start < end) {
                Matcher matcher = COMMENT.matcher(contents = contents.substring(start, end));
                if (!matcher.find()) break;
                if (++count > 1) {
                    selection = contents;
                }
                start += matcher.end(0) + 1;
                end = contents.length();
            }
        }
        return selection;
    }

    protected void markupNode(String selection, JControlModel.DictionaryPattern dictionaryPattern, JNode node) {
        Matcher matcher;
        int index;
        Pattern pattern = dictionaryPattern.getPattern();
        if (pattern.pattern().startsWith("@") && (index = selection.indexOf(64)) != -1) {
            selection = selection.substring(index, selection.length());
        }
        if ((matcher = pattern.matcher(selection)).find()) {
            if (matcher.groupCount() > 0) {
                int i = 1;
                while (i <= matcher.groupCount()) {
                    String markup = matcher.group(i);
                    this.markupNode(markup, node);
                    ++i;
                }
            } else {
                String markup = dictionaryPattern.getName();
                if (markup != null && !"".equals(markup)) {
                    this.markupNode(markup, node);
                }
            }
        }
    }

    protected void markupNode(String markup, JNode node) {
        Collection<JNode> collection = this.getMarkupMap().get(markup);
        if (collection == null) {
            collection = new HashSet<JNode>();
            this.getMarkupMap().put(markup, collection);
        }
        collection.add(node);
    }

    protected void dumpMaps() {
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getName().endsWith("Map") && Map.class.isAssignableFrom(fields[i].getType())) {
                    Map map = (Map)fields[i].get(this);
                    String mapString = String.format("%s = %s\n", fields[i].getName(), JPatternDictionary.dumpMap("\t", map));
                    System.out.print(mapString);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static <K, V> String dumpMap(String lineIndent, Map<K, V> map) {
        int columnWidth = 10;
        if (map != null) {
            StringBuilder sb = new StringBuilder("\n");
            for (Map.Entry<K, V> entry : map.entrySet()) {
                String keyString;
                K key = entry.getKey();
                String string = keyString = key == null ? null : key.toString();
                if (keyString != null && columnWidth < keyString.length()) {
                    columnWidth = keyString.length() + 25;
                }
                sb.append(String.format("%s%-" + columnWidth + "s = ", lineIndent, keyString));
                if (entry.getValue() instanceof Collection) {
                    sb.append("\n");
                    Collection values = (Collection)entry.getValue();
                    for (Object element : values) {
                        sb.append(String.format("%s%<s%s\n", lineIndent, element.toString()));
                    }
                    continue;
                }
                sb.append(String.format("%s\n", entry.getValue()));
            }
            return sb.toString();
        }
        return null;
    }

    public String getNodeIdentifier(JNode node) {
        String identifier;
        String string = identifier = this.nodeIdentifierMap == null ? null : this.nodeIdentifierMap.get(node);
        if (identifier == null) {
            StringBuilder sb = new StringBuilder();
            for (JControlModel.MatchRule matchRule : this.controlModel.getMatchRules()) {
                if (!this.isMarkedUp(matchRule.getMarkup(), node) || !matchRule.getGetFeature().getFeatureClass().isInstance(node)) continue;
                try {
                    Method getMethod = matchRule.getGetFeature().getFeatureMethod();
                    Object value = getMethod.invoke((Object)node, JMerger.NO_ARGUMENTS);
                    if (!(value instanceof String)) continue;
                    String stringValue = (String)value;
                    Pattern signature = matchRule.getSignature();
                    if (signature != null) {
                        Matcher matcher = signature.matcher(stringValue);
                        String string2 = stringValue = matcher.find() && matcher.groupCount() == 1 ? (stringValue = matcher.group(1)) : null;
                    }
                    if (stringValue == null || stringValue.length() <= 0) continue;
                    sb.append(stringValue);
                    if (!matchRule.isStopMatching()) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string3 = identifier = sb.length() > 0 ? sb.toString() : this.getDefaultNodeIdentifier(node);
            if (this.nodeIdentifierMap == null) {
                this.nodeIdentifierMap = new HashMap<JNode, String>();
            }
            this.nodeIdentifierMap.put(node, identifier);
        }
        return identifier;
    }

    protected String getDefaultNodeIdentifier(JNode node) {
        return node.getQualifiedName();
    }

    public JNode getNode(String nodeIdentifier) {
        if (nodeIdentifier != null && this.nodeIdentifierMap != null) {
            for (Map.Entry<JNode, String> entry : this.nodeIdentifierMap.entrySet()) {
                if (!nodeIdentifier.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

