/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static Class<?> getObjectType(Class<?> clazzA) {
        if (clazzA != null && clazzA.isPrimitive()) {
            if (clazzA == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazzA == Integer.TYPE) {
                return Integer.class;
            }
            if (clazzA == Float.TYPE) {
                return Float.class;
            }
            if (clazzA == Byte.TYPE) {
                return Byte.class;
            }
            if (clazzA == Character.TYPE) {
                return Character.class;
            }
            if (clazzA == Double.TYPE) {
                return Double.class;
            }
            if (clazzA == Short.TYPE) {
                return Short.class;
            }
            if (clazzA == Long.TYPE) {
                return Long.class;
            }
        }
        return clazzA;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                String message = MessageFormat.format("Expected a Class, but <{0}> is of type {1}", type, type.getClass().getName());
                throw new IllegalArgumentException(message);
            }
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(ReflectionUtil.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + type.getClass().getName());
    }
}

