/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSetLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.DiagnosticOnFirstKeyword;
import org.eclipse.xtext.xbase.typesystem.computation.EnumLiteralImporter;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.ExtendedEarlyExitComputer;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseTypeComputer
implements ITypeComputer {
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private CommonTypeComputationServices services;

    @Override
    public void computeTypes(XExpression expression, ITypeComputationState state) {
        if (expression instanceof XAssignment) {
            this._computeTypes((XAssignment)expression, state);
        } else if (expression instanceof XAbstractFeatureCall) {
            this._computeTypes((XAbstractFeatureCall)expression, state);
        } else if (expression instanceof XDoWhileExpression) {
            this._computeTypes((XDoWhileExpression)expression, state);
        } else if (expression instanceof XWhileExpression) {
            this._computeTypes((XWhileExpression)expression, state);
        } else if (expression instanceof XBlockExpression) {
            this._computeTypes((XBlockExpression)expression, state);
        } else if (expression instanceof XBooleanLiteral) {
            this._computeTypes((XBooleanLiteral)expression, state);
        } else if (expression instanceof XCastedExpression) {
            this._computeTypes((XCastedExpression)expression, state);
        } else if (expression instanceof XClosure) {
            this._computeTypes((XClosure)expression, state);
        } else if (expression instanceof XConstructorCall) {
            this._computeTypes((XConstructorCall)expression, state);
        } else if (expression instanceof XForLoopExpression) {
            this._computeTypes((XForLoopExpression)expression, state);
        } else if (expression instanceof XBasicForLoopExpression) {
            this._computeTypes((XBasicForLoopExpression)expression, state);
        } else if (expression instanceof XIfExpression) {
            this._computeTypes((XIfExpression)expression, state);
        } else if (expression instanceof XInstanceOfExpression) {
            this._computeTypes((XInstanceOfExpression)expression, state);
        } else if (expression instanceof XNumberLiteral) {
            this._computeTypes((XNumberLiteral)expression, state);
        } else if (expression instanceof XNullLiteral) {
            this._computeTypes((XNullLiteral)expression, state);
        } else if (expression instanceof XReturnExpression) {
            this._computeTypes((XReturnExpression)expression, state);
        } else if (expression instanceof XStringLiteral) {
            this._computeTypes((XStringLiteral)expression, state);
        } else if (expression instanceof XSwitchExpression) {
            this._computeTypes((XSwitchExpression)expression, state);
        } else if (expression instanceof XThrowExpression) {
            this._computeTypes((XThrowExpression)expression, state);
        } else if (expression instanceof XTryCatchFinallyExpression) {
            this._computeTypes((XTryCatchFinallyExpression)expression, state);
        } else if (expression instanceof XTypeLiteral) {
            this._computeTypes((XTypeLiteral)expression, state);
        } else if (expression instanceof XVariableDeclaration) {
            this._computeTypes((XVariableDeclaration)expression, state);
        } else if (expression instanceof XListLiteral) {
            this._computeTypes((XListLiteral)expression, state);
        } else if (expression instanceof XSetLiteral) {
            this._computeTypes((XSetLiteral)expression, state);
        } else if (expression instanceof XSynchronizedExpression) {
            this._computeTypes((XSynchronizedExpression)expression, state);
        } else {
            throw new UnsupportedOperationException("Missing type computation for expression type: " + expression.eClass().getName() + " / " + state);
        }
    }

    protected LightweightTypeReference getTypeForName(Class<?> clazz, ITypeComputationState state) {
        ResourceSet resourceSet = state.getReferenceOwner().getContextResourceSet();
        JvmTypeReference typeReference = this.services.getTypeReferences().getTypeForName(clazz, (Notifier)resourceSet, new JvmTypeReference[0]);
        if (typeReference == null) {
            return state.getReferenceOwner().newUnknownTypeReference(clazz.getName());
        }
        return state.getReferenceOwner().toLightweightTypeReference(typeReference);
    }

    protected LightweightTypeReference getRawTypeForName(Class<?> clazz, ITypeReferenceOwner owner) {
        JvmType clazzType = this.services.getTypeReferences().findDeclaredType(clazz, (Notifier)owner.getContextResourceSet());
        if (clazzType == null) {
            return owner.newUnknownTypeReference(clazz.getName());
        }
        LightweightTypeReference result = owner.toPlainTypeReference(clazzType);
        return result;
    }

    protected LightweightTypeReference getPrimitiveVoid(ITypeComputationState state) {
        return this.getRawTypeForName(Void.TYPE, state.getReferenceOwner());
    }

    protected void _computeTypes(XIfExpression object, ITypeComputationState state) {
        ITypeComputationState conditionExpectation = state.withExpectation(this.getTypeForName(Boolean.TYPE, state));
        XExpression condition = object.getIf();
        conditionExpectation.computeTypes(condition);
        XExpression thenExpression = this.getThen(object);
        ITypeComputationState thenState = this.reassignCheckedType(condition, thenExpression, state);
        ITypeComputationResult thenResult = thenState.computeTypes(thenExpression);
        XExpression elseExpression = this.getElse(object);
        if (elseExpression != null) {
            state.computeTypes(elseExpression);
        } else {
            BranchExpressionProcessor processor = new BranchExpressionProcessor(state, object){

                protected String getMessage() {
                    return "Missing else branch for conditional expression with primitive type";
                }
            };
            processor.process(thenResult);
            processor.commit();
        }
    }

    protected ITypeComputationState reassignCheckedType(XExpression condition, XExpression guardedExpression, ITypeComputationState state) {
        XInstanceOfExpression instanceOfExpression;
        JvmTypeReference castedType;
        if (condition instanceof XInstanceOfExpression && (castedType = (instanceOfExpression = (XInstanceOfExpression)condition).getType()) != null) {
            state = state.withTypeCheckpoint(guardedExpression);
            JvmIdentifiableElement refinable = this.getRefinableCandidate(instanceOfExpression.getExpression(), state);
            if (refinable != null) {
                state.reassignType(refinable, state.getReferenceOwner().toLightweightTypeReference(castedType));
            }
        }
        return state;
    }

    protected XExpression getElse(XIfExpression ifExpression) {
        return ifExpression.getElse();
    }

    protected XExpression getThen(XIfExpression ifExpression) {
        return ifExpression.getThen();
    }

    protected void _computeTypes(XSwitchExpression object, ITypeComputationState state) {
        ITypeComputationState switchExpressionState = this.getSwitchExpressionState(object, state);
        ITypeComputationResult computedType = switchExpressionState.computeTypes(object.getSwitch());
        ITypeComputationState allCasePartsState = state;
        LightweightTypeReference expressionType = computedType.getActualExpressionType();
        JvmFormalParameter declaredParam = object.getDeclaredParam();
        if (declaredParam != null) {
            if (declaredParam.getParameterType() == null) {
                allCasePartsState = allCasePartsState.assignType((JvmIdentifiableElement)declaredParam, expressionType);
            } else {
                LightweightTypeReference parameterType = state.getReferenceOwner().toLightweightTypeReference(declaredParam.getParameterType());
                allCasePartsState = allCasePartsState.assignType((JvmIdentifiableElement)declaredParam, parameterType);
            }
        }
        allCasePartsState.withinScope(object);
        JvmType potentialEnumType = expressionType != null ? expressionType.getType() : null;
        boolean isEnum = potentialEnumType instanceof JvmEnumerationType;
        BranchExpressionProcessor branchExpressionProcessor = object.getDefault() == null ? new BranchExpressionProcessor(state, object){

            protected String getMessage() {
                return "Missing default branch for switch expression with primitive type";
            }
        } : null;
        LightweightTypeReference thenTypeReference = null;
        List<XCasePart> cases = this.getCases(object);
        int i = 0;
        while (i < cases.size()) {
            XExpression then;
            XCasePart casePart = cases.get(i);
            ITypeComputationState casePartState = allCasePartsState.withTypeCheckpoint(casePart);
            boolean localIsEnum = isEnum;
            JvmType localPotentialEnumType = potentialEnumType;
            if (casePart.getTypeGuard() != null) {
                JvmIdentifiableElement refinable = this.getRefinableCandidate(object, casePartState);
                if (refinable != null) {
                    LightweightTypeReference lightweightReference = casePartState.getReferenceOwner().toLightweightTypeReference(casePart.getTypeGuard());
                    casePartState.reassignType(refinable, lightweightReference);
                    if (thenTypeReference == null) {
                        thenTypeReference = lightweightReference;
                    } else {
                        ArrayList types;
                        ITypeReferenceOwner owner = thenTypeReference.getOwner();
                        TypeConformanceComputer typeConformanceComputer = owner.getServices().getTypeConformanceComputer();
                        if ((thenTypeReference = typeConformanceComputer.getCommonSuperType(types = Lists.newArrayList((Object[])new LightweightTypeReference[]{thenTypeReference, lightweightReference}), owner)) == null) {
                            thenTypeReference = lightweightReference;
                        }
                    }
                }
                if (!localIsEnum) {
                    JvmType typeGuard = casePart.getTypeGuard().getType();
                    if (typeGuard instanceof JvmEnumerationType) {
                        localIsEnum = true;
                        localPotentialEnumType = typeGuard;
                    }
                    if (typeGuard instanceof JvmTypeParameter) {
                        state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_type_parameter", "Cannot perform type switch against type parameter " + typeGuard.getSimpleName() + ". Use its erasure Object instead since further generic type information will be erased at runtime.", (EObject)casePart.getTypeGuard(), null, -1, new String[0]));
                    }
                }
            }
            ITypeComputationState caseState = casePartState.withNonVoidExpectation();
            if (localIsEnum) {
                assert (potentialEnumType != null);
                caseState.addImports(new EnumLiteralImporter((JvmDeclaredType)localPotentialEnumType));
            }
            caseState.withinScope(casePart);
            if (casePart.getCase() != null) {
                caseState.computeTypes(casePart.getCase());
            }
            if ((then = casePart.getThen()) != null || i == cases.size() - 1 && thenTypeReference != null) {
                JvmIdentifiableElement refinable;
                ITypeComputationState thenState = allCasePartsState.withTypeCheckpoint(casePart);
                if (thenTypeReference != null && (refinable = this.getRefinableCandidate(object, thenState)) != null) {
                    thenState.reassignType(refinable, thenTypeReference);
                    thenTypeReference = null;
                }
                thenState.afterScope(casePart);
                ITypeComputationResult thenResult = thenState.computeTypes(then);
                if (branchExpressionProcessor != null) {
                    branchExpressionProcessor.process(thenResult);
                }
            } else {
                allCasePartsState.afterScope(casePart);
            }
            ++i;
        }
        XExpression defaultCase = object.getDefault();
        if (defaultCase != null) {
            allCasePartsState.computeTypes(object.getDefault());
        } else if (branchExpressionProcessor != null) {
            branchExpressionProcessor.commit();
        }
    }

    protected ITypeComputationState getSwitchExpressionState(XSwitchExpression expr, ITypeComputationState state) {
        JvmFormalParameter param = expr.getDeclaredParam();
        if (param == null) {
            return state.withNonVoidExpectation();
        }
        JvmTypeReference parameterType = param.getParameterType();
        if (parameterType == null) {
            return state.withNonVoidExpectation();
        }
        LightweightTypeReference expectation = state.getReferenceOwner().toLightweightTypeReference(parameterType);
        return state.withExpectation(expectation);
    }

    protected List<XCasePart> getCases(XSwitchExpression switchExpression) {
        return switchExpression.getCases();
    }

    /*
     * WARNING - void declaration
     */
    protected void _computeTypes(XBlockExpression object, ITypeComputationState state) {
        EList<XExpression> children = object.getExpressions();
        if (children.isEmpty()) {
            for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
                LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
                if (expectedType != null && expectedType.isPrimitiveVoid()) {
                    iTypeExpectation.acceptActualType(expectedType, 0x100200);
                    continue;
                }
                iTypeExpectation.acceptActualType((LightweightTypeReference)iTypeExpectation.getReferenceOwner().newAnyTypeReference(), 0x400000);
            }
        } else {
            void var4_10;
            state.withinScope(object);
            boolean bl = false;
            while (var4_10 < children.size() - 1) {
                XExpression xExpression = (XExpression)children.get((int)var4_10);
                ITypeComputationState expressionState = state.withoutExpectation();
                expressionState.computeTypes(xExpression);
                if (xExpression instanceof XVariableDeclaration) {
                    this.addLocalToCurrentScope((XVariableDeclaration)xExpression, state);
                }
                ++var4_10;
            }
            XExpression xExpression = (XExpression)children.get(children.size() - 1);
            for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
                LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
                if (expectedType != null && expectedType.isPrimitiveVoid()) {
                    ITypeComputationState expressionState = state.withoutExpectation();
                    expressionState.computeTypes(xExpression);
                    if (xExpression instanceof XVariableDeclaration) {
                        this.addLocalToCurrentScope((XVariableDeclaration)xExpression, state);
                    }
                    iTypeExpectation.acceptActualType(this.getPrimitiveVoid(state), 0x100200);
                    continue;
                }
                state.computeTypes(xExpression);
                if (!(xExpression instanceof XVariableDeclaration)) continue;
                this.addLocalToCurrentScope((XVariableDeclaration)xExpression, state);
            }
        }
    }

    protected void addLocalToCurrentScope(XVariableDeclaration localVariable, ITypeComputationState state) {
        state.addLocalToCurrentScope(localVariable);
        state.rewriteScope(localVariable);
    }

    protected void _computeTypes(XVariableDeclaration object, ITypeComputationState state) {
        ITypeComputationState initializerState;
        LightweightTypeReference lightweightTypeReference;
        JvmTypeReference declaredType = object.getType();
        LightweightTypeReference lightweightTypeReference2 = lightweightTypeReference = declaredType != null ? state.getReferenceOwner().toLightweightTypeReference(declaredType) : null;
        if (lightweightTypeReference != null && object.getRight() instanceof XClosure) {
            initializerState = state.assignType(object, lightweightTypeReference).withExpectation(lightweightTypeReference);
            initializerState.computeTypes(object.getRight());
        } else {
            initializerState = lightweightTypeReference != null ? state.withExpectation(lightweightTypeReference) : state.withNonVoidExpectation();
            initializerState.withinScope(object);
            ITypeComputationResult computedType = initializerState.computeTypes(object.getRight());
            LightweightTypeReference variableType = null;
            variableType = lightweightTypeReference != null ? lightweightTypeReference : computedType.getActualExpressionType();
            if (variableType != null) {
                ExtendedEarlyExitComputer earlyExitComputer;
                if (variableType.isPrimitiveVoid()) {
                    variableType = variableType.getOwner().newUnknownTypeReference();
                }
                if (object.getRight() != null && (earlyExitComputer = state.getReferenceOwner().getServices().getEarlyExitComputer()).isDefiniteEarlyExit(computedType.getExpression())) {
                    EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", "Dead code: The variable " + object.getSimpleName() + " will never be assigned.", (EObject)object, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, -1, null);
                    state.addDiagnostic((AbstractDiagnostic)diagnostic);
                }
            }
            state.assignType(object, variableType, false);
        }
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(XConstructorCall constructorCall, ITypeComputationState state) {
        List<? extends IConstructorLinkingCandidate> candidates = state.getLinkingCandidates(constructorCall);
        ILinkingCandidate best = this.getBestCandidate(candidates);
        best.applyToComputationState();
    }

    protected void _computeTypes(XBooleanLiteral object, ITypeComputationState state) {
        LightweightTypeReference bool = this.getTypeForName(Boolean.TYPE, state);
        state.acceptActualType(bool);
    }

    protected void _computeTypes(XNullLiteral object, ITypeComputationState state) {
        state.acceptActualType(state.getReferenceOwner().newAnyTypeReference());
    }

    protected void _computeTypes(XNumberLiteral object, ITypeComputationState state) {
        LightweightTypeReference result = this.getTypeForName(this.numberLiterals.getJavaType(object), state);
        state.acceptActualType(result);
    }

    protected void _computeTypes(XStringLiteral object, ITypeComputationState state) {
        if (object.getValue() != null && object.getValue().length() != 1) {
            LightweightTypeReference lightweightTypeReference = this.getTypeForName(String.class, state);
            state.acceptActualType(lightweightTypeReference);
        } else {
            for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
                LightweightTypeReference type;
                LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
                if (expectedType != null) {
                    if (expectedType.isType(Character.TYPE) || expectedType.isType(Character.class)) {
                        iTypeExpectation.acceptActualType(expectedType, 0x300600);
                        continue;
                    }
                    type = this.getTypeForName(String.class, state);
                    iTypeExpectation.acceptActualType(type, 0x400000);
                    continue;
                }
                type = this.getTypeForName(String.class, state);
                iTypeExpectation.acceptActualType(type, 0x400000);
            }
        }
    }

    protected void _computeTypes(XListLiteral literal, ITypeComputationState state) {
        JvmGenericType listType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(List.class, (Notifier)literal);
        if (listType == null) {
            for (XExpression element : literal.getElements()) {
                state.withNonVoidExpectation().computeTypes(element);
            }
            state.acceptActualType(state.getReferenceOwner().newUnknownTypeReference(List.class.getName()));
            return;
        }
        for (ITypeExpectation expectation : state.getExpectations()) {
            List<LightweightTypeReference> listTypeCandidates;
            LightweightTypeReference elementTypeExpectation = null;
            LightweightTypeReference expectedType = expectation.getExpectedType();
            if (expectedType != null) {
                if (expectedType.isArray()) {
                    elementTypeExpectation = expectedType.getComponentType();
                    int allFlags = 0;
                    for (XExpression element : literal.getElements()) {
                        ITypeComputationResult elementTypeResult = elementTypeExpectation != null ? state.withExpectation(elementTypeExpectation).computeTypes(element) : state.withNonVoidExpectation().computeTypes(element);
                        allFlags |= elementTypeResult.getCheckedConformanceFlags();
                    }
                    if ((allFlags & 0x40000) != 0) {
                        allFlags &= 0xFFFFFDFF;
                        expectation.acceptActualType(expectedType, allFlags |= 0x10300000);
                    } else if ((allFlags & 0x200) != 0) {
                        expectation.acceptActualType(expectedType, allFlags |= 0x300000);
                    } else {
                        expectation.acceptActualType(expectedType, 0x300200);
                    }
                    return;
                }
                elementTypeExpectation = this.getElementOrComponentType(expectedType, state);
            }
            if (!(listTypeCandidates = this.computeCollectionTypeCandidates(literal, listType, elementTypeExpectation, state)).isEmpty()) {
                LightweightTypeReference commonListType = this.services.getTypeConformanceComputer().getCommonSuperType(listTypeCandidates, state.getReferenceOwner());
                if (commonListType != null) {
                    expectation.acceptActualType(commonListType, 0x400000);
                    LightweightTypeReference commonElementType = this.getElementOrComponentType(commonListType, state);
                    for (XExpression element : literal.getElements()) {
                        state.refineExpectedType(element, commonElementType);
                    }
                    continue;
                }
                expectation.acceptActualType(this.getTypeForName(Object.class, state), 0x400000);
                continue;
            }
            ParameterizedTypeReference unboundCollectionType = state.getReferenceOwner().newParameterizedTypeReference((JvmType)listType);
            if (elementTypeExpectation != null) {
                unboundCollectionType.addTypeArgument(elementTypeExpectation);
            } else {
                UnboundTypeReference unbound = expectation.createUnboundTypeReference(literal, (JvmTypeParameter)listType.getTypeParameters().get(0));
                unboundCollectionType.addTypeArgument(unbound);
            }
            expectation.acceptActualType((LightweightTypeReference)unboundCollectionType, 0x400000);
        }
    }

    protected void _computeTypes(XSetLiteral literal, ITypeComputationState state) {
        JvmGenericType setType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Set.class, (Notifier)literal);
        if (setType == null) {
            state.acceptActualType(state.getReferenceOwner().newUnknownTypeReference(Set.class.getName()));
            return;
        }
        JvmGenericType mapType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Map.class, (Notifier)literal);
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            ParameterizedTypeReference unboundCollectionType;
            List<LightweightTypeReference> setTypeCandidates;
            LightweightTypeReference commonSetType;
            LightweightTypeReference elementTypeExpectation = null;
            LightweightTypeReference expectedType = iTypeExpectation.getExpectedType();
            if (expectedType != null) {
                elementTypeExpectation = this.getElementOrComponentType(expectedType, state);
            }
            LightweightTypeReference lightweightTypeReference = commonSetType = !(setTypeCandidates = this.computeCollectionTypeCandidates(literal, setType, elementTypeExpectation, state)).isEmpty() ? this.services.getTypeConformanceComputer().getCommonSuperType(setTypeCandidates, state.getReferenceOwner()) : null;
            if (commonSetType != null) {
                LightweightTypeReference commonElementType = commonSetType.getTypeArguments().get(0).getInvariantBoundSubstitute();
                JvmGenericType pairType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Pair.class, (Notifier)literal);
                if (!(expectedType != null && expectedType.isType(Set.class) || commonElementType.getType() != pairType)) {
                    Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(commonElementType);
                    ParameterizedTypeReference boundMapType = state.getReferenceOwner().newParameterizedTypeReference((JvmType)mapType);
                    boundMapType.addTypeArgument(typeParameterMapping.get(pairType.getTypeParameters().get(0)).getTypeReference().getInvariantBoundSubstitute());
                    boundMapType.addTypeArgument(typeParameterMapping.get(pairType.getTypeParameters().get(1)).getTypeReference().getInvariantBoundSubstitute());
                    iTypeExpectation.acceptActualType((LightweightTypeReference)boundMapType, 0x400000);
                    continue;
                }
                iTypeExpectation.acceptActualType(commonSetType, 0x400000);
                for (XExpression element : literal.getElements()) {
                    state.refineExpectedType(element, commonElementType);
                }
                continue;
            }
            if (expectedType != null && expectedType.isType(Map.class)) {
                unboundCollectionType = state.getReferenceOwner().newParameterizedTypeReference((JvmType)mapType);
                unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)mapType.getTypeParameters().get(0)));
                unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)mapType.getTypeParameters().get(1)));
                iTypeExpectation.acceptActualType((LightweightTypeReference)unboundCollectionType, 0x400000);
                continue;
            }
            unboundCollectionType = state.getReferenceOwner().newParameterizedTypeReference((JvmType)setType);
            if (elementTypeExpectation != null) {
                unboundCollectionType.addTypeArgument(elementTypeExpectation);
            } else {
                unboundCollectionType.addTypeArgument(iTypeExpectation.createUnboundTypeReference(literal, (JvmTypeParameter)setType.getTypeParameters().get(0)));
            }
            iTypeExpectation.acceptActualType((LightweightTypeReference)unboundCollectionType, 0x400000);
        }
    }

    private List<LightweightTypeReference> computeCollectionTypeCandidates(XCollectionLiteral literal, JvmGenericType collectionType, LightweightTypeReference elementTypeExpectation, ITypeComputationState state) {
        if (!literal.getElements().isEmpty()) {
            ArrayList elementTypes = Lists.newArrayList();
            for (XExpression element : literal.getElements()) {
                ITypeComputationResult elementType = elementTypeExpectation != null ? state.withExpectation(elementTypeExpectation).computeTypes(element) : state.withNonVoidExpectation().computeTypes(element);
                LightweightTypeReference actualType = elementType.getActualExpressionType();
                if (actualType == null || actualType.isAny()) continue;
                ParameterizedTypeReference collectionTypeCandidate = state.getReferenceOwner().newParameterizedTypeReference((JvmType)collectionType);
                collectionTypeCandidate.addTypeArgument(actualType.getWrapperTypeIfPrimitive());
                elementTypes.add(collectionTypeCandidate);
            }
            return elementTypes;
        }
        return Collections.emptyList();
    }

    protected void _computeTypes(XClosure object, ITypeComputationState state) {
        for (ITypeExpectation iTypeExpectation : state.getExpectations()) {
            new ClosureTypeComputer(object, iTypeExpectation, state).computeTypes();
        }
    }

    protected void _computeTypes(XCastedExpression object, ITypeComputationState state) {
        JvmTypeReference type = object.getType();
        if (type != null) {
            state.withNonVoidExpectation().computeTypes(object.getTarget());
            state.acceptActualType(state.getReferenceOwner().toLightweightTypeReference(type));
        } else {
            state.computeTypes(object.getTarget());
        }
    }

    protected void _computeTypes(XBasicForLoopExpression object, ITypeComputationState state) {
        for (XExpression initExpression : object.getInitExpressions()) {
            ITypeComputationState expressionState = state.withoutExpectation();
            expressionState.computeTypes(initExpression);
            if (!(initExpression instanceof XVariableDeclaration)) continue;
            this.addLocalToCurrentScope((XVariableDeclaration)initExpression, state);
        }
        state.withinScope(object);
        XExpression expression = object.getExpression();
        if (expression != null) {
            LightweightTypeReference booleanType = this.getTypeForName(Boolean.TYPE, state);
            ITypeComputationState conditionExpectation = state.withExpectation(booleanType);
            conditionExpectation.computeTypes(expression);
        }
        XExpression eachExpression = object.getEachExpression();
        ITypeComputationState stateWithoutExpectation = state.withoutExpectation();
        ITypeComputationState eachExpressionState = this.reassignCheckedType(expression, eachExpression, stateWithoutExpectation);
        eachExpressionState.computeTypes(eachExpression);
        for (XExpression updateExpression : object.getUpdateExpressions()) {
            eachExpressionState.computeTypes(updateExpression);
        }
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(XForLoopExpression object, ITypeComputationState state) {
        JvmFormalParameter declaredParam = object.getDeclaredParam();
        ITypeComputationState eachState = state.withoutExpectation();
        if (declaredParam != null) {
            LightweightTypeReference parameterType = this.computeForLoopParameterType(object, state);
            eachState = this.assignType(declaredParam, parameterType, eachState);
            eachState.withinScope(object);
        }
        eachState.computeTypes(object.getEachExpression());
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected ITypeComputationState assignType(JvmFormalParameter param, LightweightTypeReference type, ITypeComputationState state) {
        return state.assignType((JvmIdentifiableElement)param, type);
    }

    protected LightweightTypeReference computeForLoopParameterType(XForLoopExpression object, ITypeComputationState state) {
        JvmFormalParameter declaredParam = object.getDeclaredParam();
        LightweightTypeReference parameterType = this.getDeclaredParameterType(declaredParam, state);
        JvmGenericType iterableType = (JvmGenericType)this.services.getTypeReferences().findDeclaredType(Iterable.class, (Notifier)object);
        if (parameterType != null && !parameterType.isPrimitiveVoid()) {
            CompoundTypeReference withSynonyms = state.getReferenceOwner().newCompoundTypeReference(true);
            LightweightTypeReference iterableOrArray = this.getAndEnhanceIterableOrArrayFromComponent(parameterType, iterableType, withSynonyms);
            ITypeComputationState iterableState = state.withExpectation(withSynonyms);
            ITypeComputationResult forExpressionResult = iterableState.computeTypes(object.getForExpression());
            LightweightTypeReference forExpressionType = forExpressionResult.getActualExpressionType();
            if (forExpressionType != null) {
                if (forExpressionType.isAny() || forExpressionType.isUnknown()) {
                    iterableState.refineExpectedType(object.getForExpression(), iterableOrArray);
                } else if (forExpressionType.isResolved()) {
                    int assignability = iterableOrArray.internalIsAssignableFrom(forExpressionType, new TypeConformanceComputationArgument());
                    if ((assignability & 0x200) != 0 && (assignability & 0x8000) == 0) {
                        iterableState.refineExpectedType(object.getForExpression(), forExpressionType);
                    } else {
                        ArrayTypeReference array = forExpressionType.tryConvertToArray();
                        if (array != null) {
                            LightweightTypeReference arrayComponentType = array.getComponentType();
                            if (parameterType.isAssignableFrom(arrayComponentType)) {
                                iterableState.refineExpectedType(object.getForExpression(), forExpressionType);
                            } else {
                                LightweightTypeReference rawArrayComponentType = arrayComponentType.getRawTypeReference();
                                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from element type %s to %s", rawArrayComponentType.getHumanReadableName(), parameterType.getHumanReadableName()), (EObject)object, (EStructuralFeature)XbasePackage.Literals.XFOR_LOOP_EXPRESSION__FOR_EXPRESSION, -1, null);
                                state.addDiagnostic((AbstractDiagnostic)diagnostic);
                            }
                        }
                    }
                }
            }
        } else {
            ITypeReferenceOwner owner = state.getReferenceOwner();
            LightweightTypeReference iterable = null;
            if (iterableType == null) {
                iterable = owner.newUnknownTypeReference(Iterable.class.getName());
            } else {
                WildcardTypeReference wildcard = owner.newWildcardTypeReference();
                ParameterizedTypeReference iterableTypeRef = owner.newParameterizedTypeReference((JvmType)iterableType);
                UnboundTypeReference unbound = state.createUnboundTypeReference(object, (JvmTypeParameter)iterableType.getTypeParameters().get(0));
                wildcard.addUpperBound(unbound);
                iterableTypeRef.addTypeArgument(wildcard);
                iterable = iterableTypeRef;
            }
            ITypeComputationState iterableState = state.withExpectation(iterable);
            ITypeComputationResult forExpressionResult = iterableState.computeTypes(object.getForExpression());
            LightweightTypeReference forExpressionType = forExpressionResult.getActualExpressionType();
            if (forExpressionType != null) {
                if (!forExpressionType.isAny() && (iterable.isAssignableFrom(forExpressionType) || forExpressionType.isArray())) {
                    iterableState.refineExpectedType(object.getForExpression(), forExpressionType);
                }
                parameterType = this.getElementOrComponentType(forExpressionType, state);
            }
        }
        return parameterType;
    }

    protected LightweightTypeReference getAndEnhanceIterableOrArrayFromComponent(LightweightTypeReference parameterType, JvmGenericType iterableType, CompoundTypeReference compoundResult) {
        if (parameterType.isUnknown()) {
            compoundResult.addComponent(parameterType);
            return parameterType;
        }
        ITypeReferenceOwner owner = compoundResult.getOwner();
        LightweightTypeReference iterableOrArray = null;
        LightweightTypeReference addAsArrayComponentAndIterable = null;
        if (parameterType.isPrimitive()) {
            iterableOrArray = owner.newArrayTypeReference(parameterType);
            compoundResult.addComponent(iterableOrArray);
            addAsArrayComponentAndIterable = parameterType.getWrapperTypeIfPrimitive();
        } else {
            addAsArrayComponentAndIterable = parameterType.isAny() ? this.getRawTypeForName(Object.class, parameterType.getOwner()) : parameterType;
        }
        if (iterableType != null) {
            ParameterizedTypeReference reference = owner.newParameterizedTypeReference((JvmType)iterableType);
            WildcardTypeReference wildcard = owner.newWildcardTypeReference();
            wildcard.addUpperBound(addAsArrayComponentAndIterable);
            reference.addTypeArgument(wildcard);
            compoundResult.addComponent(reference);
            if (iterableOrArray == null) {
                iterableOrArray = reference;
                LightweightTypeReference potentialPrimitive = addAsArrayComponentAndIterable.getPrimitiveIfWrapperType();
                if (potentialPrimitive != addAsArrayComponentAndIterable) {
                    compoundResult.addComponent(owner.newArrayTypeReference(potentialPrimitive));
                }
            }
            compoundResult.addComponent(owner.newArrayTypeReference(addAsArrayComponentAndIterable));
        }
        return iterableOrArray;
    }

    private LightweightTypeReference getElementOrComponentType(final LightweightTypeReference iterableOrArray, final ITypeComputationState state) {
        LightweightTypeReference parameterType = iterableOrArray.accept(new TypeReferenceVisitorWithResult<LightweightTypeReference>(){

            @Override
            public LightweightTypeReference doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
                ConstraintAwareTypeArgumentCollector typeArgumentCollector = new ConstraintAwareTypeArgumentCollector(state.getReferenceOwner());
                Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping = typeArgumentCollector.getTypeParameterMapping(reference);
                UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(typeParameterMapping, state.getReferenceOwner());
                JvmGenericType iterable = (JvmGenericType)XbaseTypeComputer.this.services.getTypeReferences().findDeclaredType(Iterable.class, (Notifier)iterableOrArray.getOwner().getContextResourceSet());
                if (iterable == null) {
                    return iterableOrArray.getOwner().newUnknownTypeReference();
                }
                ParameterizedTypeReference substituteMe = state.getReferenceOwner().newParameterizedTypeReference((JvmType)iterable.getTypeParameters().get(0));
                LightweightTypeReference substitutedArgument = substitutor.substitute(substituteMe).getUpperBoundSubstitute();
                if (substitutedArgument.getType() instanceof JvmTypeParameter && !state.getReferenceOwner().getDeclaredTypeParameters().contains(substitutedArgument.getType())) {
                    return substitutedArgument.getRawTypeReference();
                }
                return substitutedArgument;
            }

            @Override
            protected LightweightTypeReference doVisitAnyTypeReference(AnyTypeReference reference) {
                return reference;
            }

            @Override
            protected LightweightTypeReference doVisitUnknownTypeReference(UnknownTypeReference reference) {
                return reference;
            }

            @Override
            public LightweightTypeReference doVisitArrayTypeReference(ArrayTypeReference reference) {
                return reference.getComponentType();
            }

            @Override
            protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference) {
                return null;
            }
        });
        return parameterType;
    }

    protected LightweightTypeReference getDeclaredParameterType(JvmFormalParameter declaredParam, ITypeComputationState state) {
        JvmTypeReference parameterType = declaredParam.getParameterType();
        if (parameterType == null) {
            return null;
        }
        return state.getReferenceOwner().toLightweightTypeReference(parameterType);
    }

    protected void _computeTypes(XWhileExpression object, ITypeComputationState state) {
        this.computeWhileLoopBody(object, state, true);
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected ITypeComputationResult computeWhileLoopBody(XAbstractWhileExpression object, ITypeComputationState state, boolean autocast) {
        ITypeComputationState conditionExpectation = state.withExpectation(this.getTypeForName(Boolean.TYPE, state));
        XExpression predicate = object.getPredicate();
        conditionExpectation.computeTypes(predicate);
        XExpression body = object.getBody();
        ITypeComputationState bodyState = autocast ? this.reassignCheckedType(predicate, body, state.withoutExpectation()) : state.withoutExpectation();
        return bodyState.computeTypes(body);
    }

    protected void _computeTypes(XDoWhileExpression object, ITypeComputationState state) {
        ITypeComputationResult loopBodyResult = this.computeWhileLoopBody(object, state, false);
        boolean noImplicitReturn = (loopBodyResult.getConformanceFlags() & 0x4000000) != 0;
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        if (noImplicitReturn) {
            state.acceptActualType(primitiveVoid, 0x4400000);
        } else {
            state.acceptActualType(primitiveVoid);
        }
    }

    protected void _computeTypes(XTypeLiteral object, ITypeComputationState state) {
        LightweightTypeReference result;
        JvmType type = object.getType();
        if (type == null) {
            return;
        }
        this.checkTypeParameterNotAllowedAsLiteral(object, type, state);
        ITypeReferenceOwner owner = state.getReferenceOwner();
        LightweightTypeReference clazz = owner.newParameterizedTypeReference(type);
        int i = 0;
        while (i < object.getArrayDimensions().size()) {
            clazz = owner.newArrayTypeReference(clazz);
            ++i;
        }
        if (object.getArrayDimensions().isEmpty()) {
            JvmType voidType;
            clazz = clazz.isPrimitiveVoid() ? ((voidType = this.services.getTypeReferences().findDeclaredType(Void.class, (Notifier)object)) == null ? owner.newUnknownTypeReference(Void.class.getName()) : owner.newParameterizedTypeReference(voidType)) : clazz.getWrapperTypeIfPrimitive();
        }
        if ((result = this.getRawTypeForName(Class.class, owner)) instanceof ParameterizedTypeReference) {
            ParameterizedTypeReference parameterizedTypeReference = (ParameterizedTypeReference)result;
            parameterizedTypeReference.addTypeArgument(clazz);
        }
        state.acceptActualType(result);
    }

    private void checkTypeParameterNotAllowedAsLiteral(EObject ctx, JvmType type, ITypeComputationState state) {
        if (type instanceof JvmTypeParameter) {
            state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_type_parameter", "Illegal class literal for the type parameter " + type.getSimpleName() + ".", ctx, null, -1, new String[0]));
        }
    }

    protected void _computeTypes(XInstanceOfExpression object, ITypeComputationState state) {
        ITypeComputationState expressionState = state.withExpectation(this.getRawTypeForName(Object.class, state.getReferenceOwner()));
        expressionState.computeTypes(object.getExpression());
        JvmTypeReference type = object.getType();
        if (type != null && type.getType() instanceof JvmTypeParameter) {
            LightweightTypeReference lightweightReference = state.getReferenceOwner().toLightweightTypeReference(type);
            LightweightTypeReference rawTypeRef = lightweightReference.getRawTypeReference();
            state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_type_parameter", "Cannot perform instanceof check against type parameter " + lightweightReference.getHumanReadableName() + ". Use its erasure " + rawTypeRef.getHumanReadableName() + " instead since further generic type information will be erased at runtime.", (EObject)object.getType(), null, -1, new String[0]));
        }
        LightweightTypeReference bool = this.getTypeForName(Boolean.TYPE, state);
        state.acceptActualType(bool);
    }

    protected void _computeTypes(XThrowExpression object, ITypeComputationState state) {
        LightweightTypeReference throwable = this.getTypeForName(Throwable.class, state);
        ITypeComputationState expressionState = state.withExpectation(throwable);
        ITypeComputationResult types = expressionState.computeTypes(object.getExpression());
        LightweightTypeReference thrownException = types.getActualExpressionType();
        state.acceptActualType(this.getPrimitiveVoid(state), 0x24000000);
        if (thrownException != null && !thrownException.isUnknown() && !state.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception") && thrownException.isSubtypeOf(Throwable.class) && !thrownException.isSubtypeOf(RuntimeException.class)) {
            boolean declarationFound = false;
            for (LightweightTypeReference declaredException : state.getExpectedExceptions()) {
                if (!declaredException.isAssignableFrom(thrownException)) continue;
                declarationFound = true;
                break;
            }
            if (!declarationFound) {
                JvmType exceptionType = thrownException.getNamedType().getType();
                state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(expressionState.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception"), "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", "Unhandled exception type " + exceptionType.getSimpleName(), (EObject)object, (EStructuralFeature)XbasePackage.Literals.XTHROW_EXPRESSION__EXPRESSION, -1, new String[]{EcoreUtil.getURI((EObject)exceptionType).toString(), EcoreUtil.getURI((EObject)object).toString()}));
            }
        }
    }

    protected void _computeTypes(XReturnExpression object, ITypeComputationState state) {
        XExpression returnValue = object.getExpression();
        ITypeComputationState expressionState = state.withReturnExpectation();
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        if (returnValue != null) {
            expressionState.computeTypes(returnValue);
            state.acceptActualType(primitiveVoid, 0x4000000);
        } else {
            state.acceptActualType(primitiveVoid, 0x8000000);
            state.acceptActualType(primitiveVoid, 0x4000000);
        }
    }

    protected void _computeTypes(XTryCatchFinallyExpression object, ITypeComputationState state) {
        ArrayList caughtExceptions = Lists.newArrayList();
        ITypeReferenceOwner referenceOwner = state.getReferenceOwner();
        for (XCatchClause catchClause : object.getCatchClauses()) {
            if (catchClause.getDeclaredParam() == null || catchClause.getDeclaredParam().getParameterType() == null) continue;
            caughtExceptions.add(referenceOwner.toLightweightTypeReference(catchClause.getDeclaredParam().getParameterType()));
        }
        state.withExpectedExceptions(caughtExceptions).computeTypes(object.getExpression());
        for (XCatchClause catchClause : object.getCatchClauses()) {
            JvmFormalParameter catchClauseParam = catchClause.getDeclaredParam();
            JvmTypeReference parameterType = catchClauseParam.getParameterType();
            LightweightTypeReference lightweightReference = parameterType != null ? referenceOwner.toLightweightTypeReference(parameterType) : referenceOwner.newAnyTypeReference();
            ITypeComputationState catchClauseState = this.assignType(catchClauseParam, lightweightReference, state);
            catchClauseState.withinScope(catchClause);
            catchClauseState.computeTypes(catchClause.getExpression());
        }
        state.withoutExpectation().computeTypes(object.getFinallyExpression());
    }

    protected void _computeTypes(XSynchronizedExpression expr, ITypeComputationState state) {
        ITypeComputationState paramState = state.withExpectation(this.getRawTypeForName(Object.class, state.getReferenceOwner()));
        ITypeComputationResult paramType = paramState.computeTypes(expr.getParam());
        LightweightTypeReference actualParamType = paramType.getActualExpressionType();
        if (actualParamType != null && (actualParamType.isPrimitive() || actualParamType.isAny())) {
            state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.valueOf(actualParamType.getHumanReadableName()) + " is not a valid type's argument for the synchronized expression.", (EObject)expr.getParam(), null, -1, new String[0]));
        }
        state.computeTypes(expr.getExpression());
    }

    protected void _computeTypes(XAssignment assignment, ITypeComputationState state) {
        List<? extends IFeatureLinkingCandidate> candidates = state.getLinkingCandidates(assignment);
        ILinkingCandidate best = this.getBestCandidate(candidates);
        best.applyToComputationState();
    }

    protected void _computeTypes(XAbstractFeatureCall featureCall, ITypeComputationState state) {
        List<? extends IFeatureLinkingCandidate> candidates = state.getLinkingCandidates(featureCall);
        IFeatureLinkingCandidate best = (IFeatureLinkingCandidate)this.getBestCandidate(candidates);
        if (best.isTypeLiteral()) {
            this.checkTypeParameterNotAllowedAsLiteral(featureCall, (JvmType)best.getFeature(), state);
        }
        best.applyToComputationState();
    }

    protected ILinkingCandidate getBestCandidate(List<? extends ILinkingCandidate> candidates) {
        ILinkingCandidate result = candidates.get(0);
        int i = 1;
        while (i < candidates.size()) {
            ILinkingCandidate candidate = candidates.get(i);
            result = result.getPreferredCandidate(candidate);
            ++i;
        }
        return result;
    }

    protected JvmIdentifiableElement getRefinableCandidate(XExpression object, ITypeComputationState state) {
        IFeatureLinkingCandidate receiverCandidate;
        List<? extends IFeatureLinkingCandidate> receiverCandidates;
        XExpression receiver;
        JvmIdentifiableElement linkedFeature;
        List<? extends IFeatureLinkingCandidate> candidates;
        if (object instanceof XSwitchExpression) {
            XSwitchExpression switchExpression = (XSwitchExpression)object;
            JvmFormalParameter declaredParam = switchExpression.getDeclaredParam();
            if (declaredParam != null) {
                return declaredParam;
            }
            return this.getRefinableCandidate(switchExpression.getSwitch(), state);
        }
        if (object instanceof XFeatureCall) {
            JvmIdentifiableElement linkedFeature2;
            List<? extends IFeatureLinkingCandidate> candidates2 = state.getLinkingCandidates((XFeatureCall)object);
            if (candidates2.size() == 1 && this.isRefinableFeature(linkedFeature2 = candidates2.get(0).getFeature())) {
                return linkedFeature2;
            }
        } else if (object instanceof XMemberFeatureCall && (candidates = state.getLinkingCandidates((XMemberFeatureCall)object)).size() == 1 && this.isRefinableFeature(linkedFeature = candidates.get(0).getFeature()) && (receiver = ((XMemberFeatureCall)object).getMemberCallTarget()) instanceof XAbstractFeatureCall && (receiverCandidates = state.getLinkingCandidates((XAbstractFeatureCall)receiver)).size() == 1 && (receiverCandidate = receiverCandidates.get(0)).getFeature() instanceof JvmType && !receiverCandidate.isTypeLiteral()) {
            return linkedFeature;
        }
        return null;
    }

    protected boolean isRefinableFeature(JvmIdentifiableElement feature) {
        return feature instanceof XVariableDeclaration || feature instanceof XSwitchExpression || feature instanceof JvmFormalParameter || feature instanceof JvmField;
    }

    protected static abstract class BranchExpressionProcessor {
        protected boolean earlyExit = true;
        protected boolean allVoid = true;
        protected boolean allPrimitive = true;
        protected boolean resultProcessed = false;
        protected boolean nonNullResultProcessed = false;
        private final ITypeComputationState state;
        private final XExpression expression;

        public BranchExpressionProcessor(ITypeComputationState state, XExpression expression) {
            this.state = state;
            this.expression = expression;
        }

        public void process(ITypeComputationResult result) {
            LightweightTypeReference expressionReturnType;
            this.resultProcessed = true;
            if (result.getConformanceFlags() != 0) {
                this.nonNullResultProcessed = true;
            }
            if ((expressionReturnType = result.getReturnType()) != null) {
                boolean isExit;
                boolean bl = isExit = (result.getCheckedConformanceFlags() & 0x4000000) != 0;
                if (this.earlyExit && isExit && !expressionReturnType.isPrimitiveVoid()) {
                    this.earlyExit = false;
                }
                if (this.allPrimitive && isExit && !expressionReturnType.isPrimitive()) {
                    this.allPrimitive = false;
                }
                if (this.allVoid || this.allPrimitive) {
                    LightweightTypeReference expressionType = result.getActualExpressionType();
                    if (this.allVoid && (expressionType == null || !expressionType.isPrimitiveVoid())) {
                        this.allVoid = false;
                    }
                    if (!(!this.allPrimitive || expressionType != null && expressionType.isPrimitive() || expressionReturnType.isPrimitive())) {
                        this.allPrimitive = false;
                    }
                }
            }
        }

        public void commit() {
            if (!this.nonNullResultProcessed) {
                AnyTypeReference anyTypeReference = this.state.getReferenceOwner().newAnyTypeReference();
                this.state.acceptActualType(anyTypeReference);
            }
            if (!this.resultProcessed) {
                return;
            }
            if (this.earlyExit || this.allVoid || this.allPrimitive) {
                for (ITypeExpectation iTypeExpectation : this.state.getExpectations()) {
                    if (this.earlyExit && this.allVoid) {
                        if (!iTypeExpectation.isVoidTypeAllowed()) {
                            AnyTypeReference anyType2 = this.state.getReferenceOwner().newAnyTypeReference();
                            iTypeExpectation.acceptActualType((LightweightTypeReference)anyType2, 0x400000);
                            this.allPrimitive = false;
                        }
                    } else if (!iTypeExpectation.isVoidTypeAllowed() && iTypeExpectation.getExpectedType() == null) {
                        if (!this.allPrimitive || this.allVoid) {
                            AnyTypeReference anyType = this.state.getReferenceOwner().newAnyTypeReference();
                            iTypeExpectation.acceptActualType((LightweightTypeReference)anyType, 0x400000);
                        }
                        this.allPrimitive = false;
                    }
                    if (!iTypeExpectation.isVoidTypeAllowed() || !this.earlyExit && !this.allVoid) continue;
                    this.allPrimitive = false;
                }
                if (!this.state.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature") && this.allPrimitive) {
                    DiagnosticOnFirstKeyword diagnosticOnFirstKeyword = new DiagnosticOnFirstKeyword(this.state.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature"), "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature", this.getMessage(), this.expression, null);
                    this.state.addDiagnostic((AbstractDiagnostic)diagnosticOnFirstKeyword);
                }
                return;
            }
            AnyTypeReference anyTypeReference = this.state.getReferenceOwner().newAnyTypeReference();
            this.state.acceptActualType(anyTypeReference);
        }

        protected abstract String getMessage();
    }
}

