/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.findReferences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class Declarators {
    public static final TargetURIs.Key<DeclaratorsData> KEY = TargetURIs.Key.from((String)"Xtend", DeclaratorsData.class);
    @Inject
    private IQualifiedNameConverter nameConverter;

    public DeclaratorsData getDeclaratorData(final TargetURIs targetURIs, final IReferenceFinder.IResourceAccess resourceAccess) {
        DeclaratorsData _declaratorsData;
        boolean _notEquals;
        DeclaratorsData result = (DeclaratorsData)targetURIs.getUserData(KEY);
        boolean bl = _notEquals = !Objects.equal((Object)result, null);
        if (_notEquals) {
            return result;
        }
        final HashSet declaratorNames = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        Collection _targetResourceURIs = targetURIs.getTargetResourceURIs();
        Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

            public void apply(final URI uri) {
                IUnitOfWork<Object, ResourceSet> _function = new IUnitOfWork<Object, ResourceSet>(){

                    public Object exec(final ResourceSet it) throws Exception {
                        Object _xblockexpression = null;
                        Collection _eObjectURIs = targetURIs.getEObjectURIs(uri);
                        Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                            public void apply(URI objectURI) {
                                boolean _notEquals;
                                EObject object = it.getEObject(objectURI, true);
                                boolean bl = _notEquals = !Objects.equal((Object)object, null);
                                if (_notEquals) {
                                    boolean _notEquals_1;
                                    JvmType type = (JvmType)EcoreUtil2.getContainerOfType((EObject)object, JvmType.class);
                                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)type, null);
                                    if (_notEquals_1) {
                                        String _identifier = type.getIdentifier();
                                        QualifiedName _qualifiedName = Declarators.this.nameConverter.toQualifiedName(_identifier);
                                        QualifiedName _lowerCase = _qualifiedName.toLowerCase();
                                        declaratorNames.add(_lowerCase);
                                        String _qualifiedName_1 = type.getQualifiedName('.');
                                        QualifiedName _qualifiedName_2 = Declarators.this.nameConverter.toQualifiedName(_qualifiedName_1);
                                        QualifiedName _lowerCase_1 = _qualifiedName_2.toLowerCase();
                                        declaratorNames.add(_lowerCase_1);
                                    }
                                }
                            }
                        };
                        IterableExtensions.forEach((Iterable)_eObjectURIs, (Procedures.Procedure1)_function);
                        _xblockexpression = null;
                        return _xblockexpression;
                    }
                };
                resourceAccess.readOnly(uri, (IUnitOfWork)_function);
            }
        };
        IterableExtensions.forEach((Iterable)_targetResourceURIs, (Procedures.Procedure1)_function);
        result = _declaratorsData = new DeclaratorsData(declaratorNames);
        targetURIs.putUserData(KEY, (Object)result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Data
    public static class DeclaratorsData {
        private final Set<QualifiedName> declaratorNames;

        public DeclaratorsData(Set<QualifiedName> declaratorNames) {
            this.declaratorNames = declaratorNames;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaratorNames == null ? 0 : this.declaratorNames.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeclaratorsData other = (DeclaratorsData)obj;
            return !(this.declaratorNames == null ? other.declaratorNames != null : !this.declaratorNames.equals(other.declaratorNames));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("declaratorNames", this.declaratorNames);
            return b.toString();
        }

        @Pure
        public Set<QualifiedName> getDeclaratorNames() {
            return this.declaratorNames;
        }
    }
}

