/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.model;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public abstract class AbstractRefactoringHistoryResourceMapping
extends ResourceMapping {
    private final RefactoringHistory fRefactoringHistory;
    private ResourceTraversal[] fResourceTraversals = null;

    protected AbstractRefactoringHistoryResourceMapping(RefactoringHistory history) {
        Assert.isNotNull((Object)((Object)history));
        this.fRefactoringHistory = history;
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractRefactoringHistoryResourceMapping) {
            AbstractRefactoringHistoryResourceMapping mapping = (AbstractRefactoringHistoryResourceMapping)((Object)object);
            return ((Object)((Object)mapping.fRefactoringHistory)).equals((Object)this.fRefactoringHistory);
        }
        return false;
    }

    public final Object getModelObject() {
        return this.fRefactoringHistory;
    }

    public final IProject[] getProjects() {
        HashSet<IProject> set = new HashSet<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
        int index = 0;
        while (index < proxies.length) {
            String name = proxies[index].getProject();
            if (name != null && !"".equals(name)) {
                set.add(root.getProject(name));
            }
            ++index;
        }
        return set.toArray(new IProject[set.size()]);
    }

    public final IResource getResource() {
        try {
            IResource[] resources;
            ResourceTraversal[] traversals = this.getTraversals(null, null);
            if (traversals.length > 0 && (resources = traversals[0].getResources()).length > 0) {
                return resources[0];
            }
        }
        catch (CoreException exception) {
            RefactoringCorePlugin.log(exception);
        }
        return null;
    }

    public final ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (this.fResourceTraversals == null) {
            IProject[] projects = this.getProjects();
            ResourceTraversal[] traversals = new ResourceTraversal[projects.length];
            int index = 0;
            while (index < projects.length) {
                traversals[index] = new ResourceTraversal(new IResource[]{projects[index].getFolder(".refactorings")}, 2, 0);
                ++index;
            }
            this.fResourceTraversals = traversals;
        }
        ResourceTraversal[] traversals = new ResourceTraversal[this.fResourceTraversals.length];
        System.arraycopy(this.fResourceTraversals, 0, traversals, 0, this.fResourceTraversals.length);
        return traversals;
    }

    public int hashCode() {
        return ((Object)((Object)this.fRefactoringHistory)).hashCode();
    }
}

