/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FeatureProjectFactory
extends ProjectFactory {
    private static String MANIFEST_FILENAME = "feature.xml";
    private static String CATEGORY_FILE_NAME = "category.xml";
    private static String BUILD_PROPS_FILE_NAME = "build.properties";
    private static String SOURCE_FEAT_ENDING = ".source";
    private static String FEAT_ENDING = ".feature";
    private List<String> containedBundles = new ArrayList<String>();
    private List<String> includedFeatures = new ArrayList<String>();
    private String mainCategoryName;
    private String featureLabel;

    public void setFeatureLabel(String label) {
        this.featureLabel = label;
    }

    public FeatureProjectFactory addBundle(String bundleId) {
        this.containedBundles.add(bundleId);
        return this;
    }

    public FeatureProjectFactory addFeature(String featureId) {
        this.includedFeatures.add(featureId);
        return this;
    }

    public FeatureProjectFactory withCategoryFile(String mainCategoryName) {
        this.mainCategoryName = mainCategoryName;
        return this;
    }

    protected void enhanceProject(IProject project, SubMonitor subMonitor, Shell shell) throws CoreException {
        boolean _not;
        super.enhanceProject(project, subMonitor, shell);
        SubMonitor _newChild = subMonitor.newChild(1);
        this.createManifest(project, (IProgressMonitor)_newChild);
        SubMonitor _newChild_1 = subMonitor.newChild(1);
        this.createBuildProperties(project, (IProgressMonitor)_newChild_1);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.mainCategoryName);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            SubMonitor _newChild_2 = subMonitor.newChild(1);
            this.createCategoryFile(project, this.mainCategoryName, (IProgressMonitor)_newChild_2);
        }
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"bin.includes =");
        _builder.append((Object)MANIFEST_FILENAME, "");
        _builder.newLineIfNotEmpty();
        this.writeToFile((CharSequence)_builder, BUILD_PROPS_FILE_NAME, project, monitor);
    }

    private void createManifest(IProject project, IProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<feature id=\"");
        _builder.append((Object)this.projectName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"label=\"");
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.featureLabel);
        boolean _not = !_isNullOrEmpty;
        _xifexpression = _not ? this.featureLabel : String.valueOf(this.projectName) + " Feature";
        _builder.append((Object)_xifexpression, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"version=\"1.0.0.qualifier\">");
        _builder.newLine();
        for (String includedFeature : this.includedFeatures) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<includes");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"id=\"");
            _builder.append((Object)includedFeature, "\t\t");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"version=\"0.0.0\"/>");
            _builder.newLine();
        }
        for (String containedBundle : this.containedBundles) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<plugin");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"id=\"");
            _builder.append((Object)containedBundle, "\t\t\t");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"download-size=\"0\"");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"install-size=\"0\"");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"version=\"0.0.0\"");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"unpack=\"false\"/>");
            _builder.newLine();
        }
        _builder.append((Object)"</feature>");
        _builder.newLine();
        this.writeToFile((CharSequence)_builder, MANIFEST_FILENAME, project, monitor);
    }

    private void createCategoryFile(IProject project, String categoryName, IProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<site>");
        _builder.newLine();
        for (String includedFeature : this.includedFeatures) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<feature id=\"");
            _builder.append((Object)includedFeature, "\t");
            _builder.append((Object)"\" version=\"0.0.0\">");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<category name=\"main\"/>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</feature>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"<feature id=\"");
            String _sourceFeatureName = null;
            if (includedFeature != null) {
                _sourceFeatureName = this.sourceFeatureName(includedFeature);
            }
            _builder.append((Object)_sourceFeatureName, "\t");
            _builder.append((Object)"\" version=\"0.0.0\">");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"<category name=\"main.source\"/>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"</feature>");
            _builder.newLine();
        }
        _builder.append((Object)"   ");
        _builder.append((Object)"<category-def name=\"main\" label=\"");
        _builder.append((Object)categoryName, "   ");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"   ");
        _builder.append((Object)"<category-def name=\"main.source\" label=\"Source for ");
        _builder.append((Object)categoryName, "   ");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</site>");
        _builder.newLine();
        this.writeToFile((CharSequence)_builder, CATEGORY_FILE_NAME, project, monitor);
    }

    private String sourceFeatureName(String featureId) {
        String _xblockexpression = null;
        boolean _endsWith = featureId.endsWith(FEAT_ENDING);
        if (_endsWith) {
            return featureId.replaceAll("\\" + FEAT_ENDING + "$", String.valueOf(SOURCE_FEAT_ENDING) + FEAT_ENDING);
        }
        _xblockexpression = String.valueOf(featureId) + SOURCE_FEAT_ENDING;
        return _xblockexpression;
    }
}

