/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.model.codegen.ModelGeneratorAdapter;
import org.eclipse.stem.model.codegen.STEMGenClass;
import org.eclipse.stem.model.codegen.STEMGenFeature;
import org.eclipse.stem.model.codegen.descriptor.EClassDescriptor;
import org.eclipse.stem.model.codegen.descriptor.JavaClassDescriptor;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.Transition;

public class GeneratorUtils {
    public static GenClass getGenClassForMetamodelModel(Model model, GenModel gm) {
        EList genPackages = gm.getGenPackages();
        if (genPackages.size() > 0) {
            return GeneratorUtils.getGenClassForMetamodelModel(model, (GenPackage)genPackages.iterator().next());
        }
        return null;
    }

    public static GenClass getGenClassForMetamodelModel(Model model, GenPackage gp) {
        for (GenClass genClass : gp.getGenClasses()) {
            if (!genClass.getName().equals(model.getName())) continue;
            return genClass;
        }
        return null;
    }

    public static Model getMetamodelModelForGenClass(GenClass genClass, Package metamodel) {
        for (Model model : metamodel.getModels()) {
            if (!genClass.getName().equals(model.getName())) continue;
            return model;
        }
        return null;
    }

    public static Package loadMetamodel(URI uri) throws IOException {
        if (uri != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(uri);
            resource.load(null);
            if (resource.getContents().size() > 0) {
                EObject obj = (EObject)resource.getContents().get(0);
                EcoreUtil.resolveAll((EObject)obj);
                if (obj instanceof Package) {
                    return (Package)obj;
                }
            }
        }
        return null;
    }

    public static GenModel loadGenModel(URI uri) throws IOException {
        if (uri != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(uri);
            resource.load(null);
            if (resource.getContents().size() > 0) {
                EObject obj = (EObject)resource.getContents().get(0);
                EcoreUtil.resolveAll((EObject)obj);
                if (obj instanceof GenModel) {
                    return (GenModel)obj;
                }
            }
        }
        return null;
    }

    public static List<STEMGenClass> getSTEMGenClasses(List<GenClass> genClasses) {
        ArrayList<STEMGenClass> classes = new ArrayList<STEMGenClass>();
        for (GenClass gc : genClasses) {
            classes.add(STEMGenClass.get(gc));
        }
        return classes;
    }

    public static List<GenClass> findGenClassesThatExtendBaseType(GenPackage pkg, EClassDescriptor descriptor) {
        ArrayList<GenClass> classes = new ArrayList<GenClass>();
        for (GenClass genClass : pkg.getGenClasses()) {
            if (!GeneratorUtils.classExtends(genClass, descriptor)) continue;
            classes.add(genClass);
        }
        return classes;
    }

    public static String getQualifiedJavaNameForDescriptor(JavaClassDescriptor descriptor) {
        if (descriptor != null) {
            return descriptor.getQualifiedClassName();
        }
        return null;
    }

    public static String getQualifiedJavaNameForDescriptor(GenPackage basePackage, EClassDescriptor descriptor) {
        GenClass gc;
        if (descriptor != null && (gc = GeneratorUtils.findGenClassForNSURI(basePackage, descriptor.getNSURI(), descriptor.getClassName())) != null) {
            return gc.getQualifiedInterfaceName();
        }
        return null;
    }

    public static GenClass findGenClassForNSURI(GenPackage baseGenPackage, String nsURI, String className) {
        GenPackage containerGenPackage = GeneratorUtils.findGenPackageForNSURI(baseGenPackage, nsURI);
        if (containerGenPackage != null) {
            return GeneratorUtils.findGenClassInPkg(containerGenPackage, className);
        }
        return null;
    }

    public static boolean classExtends(GenClass genClass, EClassDescriptor descriptor) {
        for (GenClass g2 : genClass.getAllBaseGenClasses()) {
            if (!g2.getGenPackage().getNSURI().equals(descriptor.getNSURI()) || !g2.getName().equals(descriptor.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, GenClass> getGenClassesForAnnotations(GenClass baseGenClass, EAnnotation annotation) {
        HashMap<String, GenClass> retVal = new HashMap<String, GenClass>();
        for (Map.Entry entry : annotation.getDetails().entrySet()) {
            GenClass match = GeneratorUtils.findGenClass(baseGenClass.getGenPackage(), (String)entry.getValue());
            retVal.put((String)entry.getKey(), match);
            if (match != null) continue;
            ModelGeneratorAdapter.addWarning("Unable to find class " + (String)entry.getValue() + " for " + baseGenClass.getName() + "/" + annotation.getSource() + "/" + (String)entry.getKey());
        }
        return retVal;
    }

    public static GenClass getDefaultOrFirstEntryFromMap(Map<String, GenClass> data, String defaultKey) {
        GenClass entry = GeneratorUtils.getDefaultEntryFromMap(data, defaultKey);
        if (entry == null && data != null && data.size() > 0) {
            entry = data.values().iterator().next();
        }
        return entry;
    }

    public static GenClass getDefaultEntryFromMap(Map<String, GenClass> data, String defaultKey) {
        GenClass defaultEntry = null;
        if (data != null) {
            defaultEntry = data.get(defaultKey);
        }
        return defaultEntry;
    }

    public static GenPackage findGenPackageForNSURI(GenPackage basePackage, String nsURI) {
        EList pkgs = basePackage.getGenModel().getUsedGenPackages();
        if (basePackage.getNSURI().equals(nsURI)) {
            return basePackage;
        }
        for (GenPackage pkg : pkgs) {
            if (!pkg.getNSURI().equals(nsURI)) continue;
            return pkg;
        }
        return null;
    }

    public static List<GenPackage> findGenPackageForJavaPackageName(GenPackage genPackage, String packageName) {
        EList pkgs = genPackage.getGenModel().getUsedGenPackages();
        ArrayList<GenPackage> candidates = new ArrayList<GenPackage>();
        if (genPackage.getClassPackageName().equals(packageName) || genPackage.getInterfacePackageName().equals(packageName)) {
            candidates.add(genPackage);
        }
        for (GenPackage pkg : pkgs) {
            if (!pkg.getClassPackageName().equals(packageName) && !pkg.getInterfacePackageName().equals(packageName)) continue;
            candidates.add(pkg);
        }
        return candidates;
    }

    private static GenClass findGenClass(GenPackage genPackage, String className) {
        String pkgName = null;
        int pkgIdx = className.lastIndexOf(46);
        if (pkgIdx >= 0) {
            pkgName = className.substring(0, pkgIdx);
            className = className.substring(pkgIdx + 1);
        }
        List<GenPackage> pkgsToSearch = null;
        if (pkgName != null) {
            pkgsToSearch = GeneratorUtils.findGenPackageForJavaPackageName(genPackage, pkgName);
        } else {
            pkgsToSearch = new ArrayList<GenPackage>();
            pkgsToSearch.add(genPackage);
            pkgsToSearch.addAll((Collection<GenPackage>)genPackage.getGenModel().getUsedGenPackages());
        }
        GenClass cls = null;
        for (GenPackage pkg : pkgsToSearch) {
            cls = GeneratorUtils.findGenClassInPkg(pkg, className);
            if (cls != null) break;
        }
        return cls;
    }

    private static GenClass findGenClassInPkg(GenPackage genPkg, String className) {
        GenClass match = null;
        for (GenClass cls : genPkg.getGenClasses()) {
            if (!cls.getName().equals(className) && !cls.getClassName().equals(className) && !cls.getInterfaceName().equals(className)) continue;
            match = cls;
            break;
        }
        return match;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static String formatToCapWords(String str) {
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            sb.appendCodePoint(Character.toUpperCase(str.codePointAt(0)));
            int idx = 1;
            while (idx < str.length()) {
                int cp = str.codePointAt(idx);
                if (Character.isUpperCase(cp) && (Character.isLowerCase(str.codePointAt(idx - 1)) || str.length() > idx + 1 && Character.isLowerCase(str.codePointAt(idx + 1)))) {
                    sb.append(' ');
                }
                sb.appendCodePoint(cp);
                ++idx;
            }
        }
        return sb.toString();
    }

    public static String formatToCamelCase(String str) {
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            boolean nextIsLC = true;
            boolean nextIsUC = false;
            int idx = 0;
            while (idx < str.length()) {
                int cp = str.codePointAt(idx);
                if (Character.isJavaIdentifierPart(cp)) {
                    if (nextIsLC) {
                        sb.appendCodePoint(Character.toLowerCase(cp));
                        nextIsLC = false;
                    } else if (nextIsUC) {
                        sb.appendCodePoint(Character.toUpperCase(cp));
                        nextIsUC = false;
                    } else {
                        sb.appendCodePoint(cp);
                    }
                } else if (!nextIsLC) {
                    nextIsUC = true;
                }
                ++idx;
            }
        }
        return sb.toString();
    }

    public static String formatToUpperCaseWordsNoSpaces(String str) {
        str = GeneratorUtils.formatToCamelCase(str);
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            sb.appendCodePoint(Character.toUpperCase(str.codePointAt(0)));
            sb.append(str.substring(1));
        }
        return sb.toString();
    }

    public static String formatToJavaPackageName(String str) {
        boolean firstWhiteSpace = true;
        str = str.trim();
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            int idx = 0;
            while (idx < str.length()) {
                int c = str.codePointAt(idx);
                if (Character.isWhitespace(c)) {
                    if (firstWhiteSpace) {
                        sb.append('.');
                        firstWhiteSpace = false;
                    }
                } else if (c == 46 || Character.isJavaIdentifierPart(c)) {
                    sb.appendCodePoint(c);
                    firstWhiteSpace = true;
                }
                ++idx;
            }
        }
        return sb.toString().toLowerCase();
    }

    public static boolean isValidJavaPackageName(String str) {
        boolean valid = false;
        String[] stringArray = str.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!GeneratorUtils.isValidJavaName(token)) {
                valid = false;
                break;
            }
            valid = true;
            ++n2;
        }
        return valid;
    }

    public static boolean isValidJavaName(String str) {
        boolean valid = false;
        if (str.length() > 0) {
            valid = Character.isJavaIdentifierStart(str.codePointAt(0));
            int idx = 1;
            while (valid && idx < str.length()) {
                valid = Character.isJavaIdentifierPart(str.codePointAt(idx));
                if (!valid) break;
                ++idx;
            }
        }
        return valid;
    }

    public static void safeClose(InputStream is) {
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static STEMGenFeature findGenFeatureForEClass(String name, List<STEMGenFeature> features) {
        for (STEMGenFeature feature : features) {
            if (!feature.getGenFeature().getName().equals(name)) continue;
            return feature;
        }
        return null;
    }

    public static String getTransitionPrettyName(Transition t) {
        Compartment source = t.getSource();
        Compartment target = t.getTarget();
        String sourceName = "?";
        String targetName = "?";
        if (source != null) {
            sourceName = source.getName();
        }
        if (target != null) {
            targetName = target.getName();
        }
        return String.valueOf(sourceName) + " -> " + targetName;
    }
}

