/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GeneratorUIUtil;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateHandler
extends AbstractHandler {
    protected Point dialogSize = null;
    protected Point dialogLocation = null;

    protected static List<URI> getGenModelURIs(IProgressMonitor progressMonitor, Object[] objects) {
        if (objects.length > 0) {
            progressMonitor.beginTask(GenModelEditPlugin.INSTANCE.getString("_UI_AnalyzingObjects_message"), objects.length);
            ArrayList<URI> uris = new ArrayList<URI>(objects.length);
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IFile file = null;
                if (object instanceof IFile) {
                    file = (IFile)object;
                } else if (object instanceof IAdaptable) {
                    file = (IFile)((IAdaptable)object).getAdapter(IFile.class);
                }
                if (file != null && "genmodel".equals(file.getFileExtension())) {
                    progressMonitor.subTask(file.getName());
                    URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    uris.add(uri);
                }
                progressMonitor.worked(1);
                ++n2;
            }
            return uris;
        }
        return new ArrayList<URI>();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        NullProgressMonitor progressMonitor;
        List<URI> uris;
        Object[] selectedObjects;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        List<GenModel> genModels = null;
        boolean usingSelection = false;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selectedObjects = ((IStructuredSelection)selection).toArray()).length >= 1 && !(uris = GenerateHandler.getGenModelURIs((IProgressMonitor)(progressMonitor = new NullProgressMonitor()), selectedObjects)).isEmpty()) {
            genModels = GeneratorUIUtil.loadGenModels((IProgressMonitor)progressMonitor, uris, shell);
            if (genModels.isEmpty()) {
                return null;
            }
            usingSelection = true;
        }
        if (!usingSelection) {
            GenModelSelectionDialog selectionDialog = new GenModelSelectionDialog(shell, true, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            selectionDialog.initialize(this.dialogSize, this.dialogLocation);
            selectionDialog.setTitle(GenModelEditPlugin.INSTANCE.getString("_UI_GenModelSelectionDialog_title"));
            selectionDialog.setInitialPattern("*.genmodel");
            if (selectionDialog.open() == 0) {
                this.dialogSize = selectionDialog.getSize();
                this.dialogLocation = selectionDialog.getLocation();
                genModels = selectionDialog.getGenModels();
            }
        }
        if (genModels != null && !genModels.isEmpty()) {
            GenModelGenerationDialog generationDialog = new GenModelGenerationDialog(shell, genModels);
            generationDialog.setShowBackButton(!usingSelection);
            generationDialog.initialize(this.dialogSize, this.dialogLocation);
            int ret = generationDialog.open();
            if (ret == 0) {
                try {
                    new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)new GeneratorUIUtil.GeneratorOperation(shell, generationDialog.getGeneratorAndArgumentsList()));
                }
                catch (Exception exception) {
                    GenModelEditPlugin.INSTANCE.log(exception);
                }
            } else if (ret == 14) {
                this.dialogSize = generationDialog.getSize();
                this.dialogLocation = generationDialog.getLocation();
                this.execute(event);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GenModelGenerationDialog
    extends TrayDialog {
        protected List<GenModel> genModels;
        protected List<Object[]> generatorAndArgumentsList;
        protected boolean startWithProjectSelected = true;
        protected Point size;
        protected Point location;
        protected Table genModelTable;
        protected CLabel genModelLabel;
        protected boolean showBackButton = false;

        public GenModelGenerationDialog(Shell shell, List<GenModel> genModels) {
            super(shell);
            this.genModels = genModels;
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        }

        public boolean isShowBackButton() {
            return this.showBackButton;
        }

        public void setShowBackButton(boolean showBackButton) {
            this.showBackButton = showBackButton;
        }

        public List<Object[]> getGeneratorAndArgumentsList() {
            if (this.generatorAndArgumentsList == null) {
                this.generatorAndArgumentsList = new ArrayList<Object[]>();
            }
            return this.generatorAndArgumentsList;
        }

        public void initialize(Point size, Point location) {
            this.size = size;
            this.location = location;
        }

        public Point getSize() {
            return this.size;
        }

        public Point getLocation() {
            return this.location;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(GenModelEditPlugin.INSTANCE.getString("_UI_GenModelGenerationDialog_title"));
        }

        public void create() {
            super.create();
            if (this.size != null) {
                Point shellSize = this.getShell().computeSize(-1, -1);
                this.getShell().setSize(Math.max(shellSize.x, this.size.x), this.size.y);
            }
            if (this.location != null) {
                this.getShell().setLocation(this.location);
            }
            if (this.genModelTable.getSelectionCount() == 0) {
                this.genModelTable.select(0);
                this.selectionChanged((GenModel)this.genModelTable.getItem(0).getData());
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createControls(composite);
            this.refresh();
            return composite;
        }

        protected void createControls(Composite parent) {
            this.createTable(parent);
            this.createGenModelDetailControl(parent);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            if (this.isShowBackButton()) {
                Button backButton = this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
                Listener backButtonListener = new Listener(){

                    public void handleEvent(Event event) {
                        GenModelGenerationDialog.this.setReturnCode(14);
                        GenModelGenerationDialog.this.close();
                    }
                };
                backButton.addListener(13, backButtonListener);
                Button button = this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
                button.setEnabled(false);
            }
            super.createButtonsForButtonBar(parent);
            if (this.isShowBackButton()) {
                this.getButton(0).setText(IDialogConstants.FINISH_LABEL);
            }
            this.updateButtons(false);
        }

        protected void createTable(Composite parent) {
            CLabel label = new CLabel(parent, 0);
            label.setText(GenModelEditPlugin.INSTANCE.getString("_UI_GenModelGenerationDialog_message"));
            this.genModelTable = new Table(parent, 2048);
            this.genModelTable.setLinesVisible(true);
            this.genModelTable.setHeaderVisible(true);
            GridData gridData = new GridData(4, 4, true, true);
            this.genModelTable.setLayoutData((Object)gridData);
            Listener tableListener = new Listener(){

                public void handleEvent(Event event) {
                    if (GenModelGenerationDialog.this.genModelTable.getSelectionCount() == 1) {
                        if (event.type == 8) {
                            Boolean select = null;
                            TableColumn[] tableColumns = GenModelGenerationDialog.this.genModelTable.getColumns();
                            int i = 1;
                            while (i < tableColumns.length) {
                                select = GenModelGenerationDialog.this.checkBoxColumnHeaderSelected(tableColumns[i], GenModelGenerationDialog.this.genModelTable.getSelectionIndex(), select);
                                ++i;
                            }
                            GenModelGenerationDialog.this.updateButtons(select);
                        }
                        TableItem tableItem = GenModelGenerationDialog.this.genModelTable.getSelection()[0];
                        GenModelGenerationDialog.this.selectionChanged((GenModel)tableItem.getData());
                    }
                }
            };
            this.genModelTable.addListener(13, tableListener);
            this.genModelTable.addListener(8, tableListener);
            TableColumn genModelColumn = new TableColumn(this.genModelTable, 0);
            genModelColumn.setText(GenModelEditPlugin.INSTANCE.getString("_UI_GenModelFile_title"));
            Listener genModelColumnListener = new Listener(){

                public void handleEvent(Event event) {
                    Boolean select = null;
                    TableColumn[] tableColumns = GenModelGenerationDialog.this.genModelTable.getColumns();
                    int i = 1;
                    while (i < tableColumns.length) {
                        select = GenModelGenerationDialog.this.checkBoxColumnHeaderSelected(tableColumns[i], -1, select);
                        ++i;
                    }
                    GenModelGenerationDialog.this.updateButtons(select);
                }
            };
            genModelColumn.addListener(13, genModelColumnListener);
            Listener checkBoxColumnListener = new Listener(){

                public void handleEvent(Event event) {
                    TableColumn tableColumn = (TableColumn)event.widget;
                    Boolean select = GenModelGenerationDialog.this.checkBoxColumnHeaderSelected(tableColumn, -1, null);
                    GenModelGenerationDialog.this.updateButtons(select);
                }
            };
            int maxWidth = 0;
            ProjectType[] projectTypeArray = ProjectType.values();
            int n = projectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectType projectType = projectTypeArray[n2];
                maxWidth = Math.max(maxWidth, this.createCheckBoxColumn(projectType, checkBoxColumnListener));
                ++n2;
            }
            TableColumn[] tableColumns = this.genModelTable.getColumns();
            int i = 1;
            while (i < tableColumns.length) {
                tableColumns[i].setWidth(maxWidth);
                ++i;
            }
        }

        protected int createCheckBoxColumn(ProjectType projectType, Listener listener) {
            TableColumn tableColumn = new TableColumn(this.genModelTable, 0);
            tableColumn.setText("  " + projectType.getLabel() + "  ");
            tableColumn.setData("type", (Object)projectType);
            tableColumn.setResizable(false);
            tableColumn.pack();
            tableColumn.addListener(13, listener);
            return tableColumn.getWidth();
        }

        protected Boolean checkBoxColumnHeaderSelected(TableColumn tableColumn, int itemIndex, Boolean select) {
            List buttons = (List)tableColumn.getData("buttons");
            if (buttons != null && !buttons.isEmpty()) {
                if (itemIndex > -1) {
                    buttons = buttons.subList(itemIndex, itemIndex + 1);
                }
                for (Button button : buttons) {
                    if (!button.isEnabled()) continue;
                    if (select == null) {
                        select = !button.getSelection();
                    }
                    button.setSelection(select.booleanValue());
                }
            }
            return select;
        }

        protected void selectionChanged(GenModel genModel) {
            StringBuilder text = new StringBuilder();
            for (GenPackage genPackage : genModel.getGenPackages()) {
                text.append(", ").append(genPackage.getEcorePackage().getNsURI());
            }
            Image image = ExtendedImageRegistry.INSTANCE.getImage((Object)URI.createPlatformPluginURI((String)"/org.eclipse.emf.ecore.edit/icons/full/obj16/EPackage.gif", (boolean)false));
            this.genModelLabel.setImage(image);
            this.genModelLabel.setText(text.substring(", ".length()));
        }

        protected void refresh() {
            this.genModelLabel.setText("");
            this.genModelTable.clearAll();
            TableColumn[] tableColumns = this.genModelTable.getColumns();
            int i = 1;
            while (i < tableColumns.length) {
                List buttons = (List)tableColumns[i].getData("buttons");
                if (buttons != null) {
                    for (Button button : buttons) {
                        button.dispose();
                    }
                    buttons.clear();
                } else {
                    tableColumns[i].setData("buttons", new ArrayList());
                }
                ++i;
            }
            for (GenModel genModel : this.genModels) {
                TableItem tableItem = new TableItem(this.genModelTable, 0);
                tableItem.setText(0, String.valueOf(genModel.eResource().getURI().toPlatformString(true)) + "   ");
                tableItem.setImage(ExtendedImageRegistry.INSTANCE.getImage((Object)URI.createPlatformPluginURI((String)"/org.eclipse.emf.codegen.ecore.ui/icons/full/obj16/GenModel.gif", (boolean)false)));
                tableItem.setData((Object)genModel);
                int i2 = 1;
                while (i2 < tableColumns.length) {
                    TableColumn tableColumn = tableColumns[i2];
                    ProjectType projectType = (ProjectType)((Object)tableColumn.getData("type"));
                    Button button = new Button((Composite)this.genModelTable, 32);
                    if (projectType.canGenerate(genModel)) {
                        button.setSelection(this.startWithProjectSelected);
                    } else {
                        button.setEnabled(false);
                    }
                    button.pack();
                    Listener buttonListener = new Listener(){

                        public void handleEvent(Event event) {
                            GenModelGenerationDialog.this.updateButtons(((Button)event.widget).getSelection());
                        }
                    };
                    button.addListener(13, buttonListener);
                    List buttons = (List)tableColumn.getData("buttons");
                    buttons.add(button);
                    TableEditor editor = new TableEditor(this.genModelTable);
                    editor.minimumWidth = button.getSize().x;
                    editor.horizontalAlignment = 0x1000000;
                    editor.setEditor((Control)button, tableItem, i2);
                    ++i2;
                }
            }
            tableColumns[0].pack();
            this.updateButtons(false);
        }

        protected void createGenModelDetailControl(Composite parent) {
            ViewForm viewForm = new ViewForm(parent, 0x800800);
            viewForm.setLayoutData((Object)new GridData(4, 4, true, false));
            this.genModelLabel = new CLabel((Composite)viewForm, 0x800000);
            this.genModelLabel.setFont(parent.getFont());
            this.genModelLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            this.genModelLabel.setToolTipText(GenModelEditPlugin.INSTANCE.getString("_UI_GenModelGenerationDetail_message"));
            this.genModelLabel.pack();
            viewForm.setContent((Control)this.genModelLabel);
        }

        protected void okPressed() {
            this.getGeneratorAndArgumentsList().addAll(this.prepareGenerators());
            super.okPressed();
        }

        protected void updateButtons(Boolean hasSelection) {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                if (hasSelection == null) {
                    hasSelection = false;
                } else if (!hasSelection.booleanValue()) {
                    TableColumn[] tableColumns = this.genModelTable.getColumns();
                    int column = 1;
                    block0: while (column < tableColumns.length) {
                        List buttons = (List)tableColumns[column].getData("buttons");
                        for (Button button : buttons) {
                            if ((hasSelection = Boolean.valueOf(hasSelection | (button.isEnabled() && button.getSelection()))).booleanValue()) break block0;
                        }
                        ++column;
                    }
                }
                okButton.setEnabled(hasSelection.booleanValue());
            }
        }

        public boolean close() {
            this.location = this.getShell().getLocation();
            this.size = this.getShell().getSize();
            return super.close();
        }

        protected List<Object[]> prepareGenerators() {
            TableColumn[] tableColumns = this.genModelTable.getColumns();
            TableItem[] tableItems = this.genModelTable.getItems();
            ArrayList<Object[]> generatorAndArgumentsList = new ArrayList<Object[]>(tableItems.length * (tableColumns.length - 1));
            int line = 0;
            while (line < tableItems.length) {
                GenModel genModel = (GenModel)tableItems[line].getData();
                int column = 1;
                while (column < tableColumns.length) {
                    Button button = (Button)((List)tableColumns[column].getData("buttons")).get(line);
                    if (button.isEnabled() && button.getSelection()) {
                        ProjectType projectType = (ProjectType)((Object)tableColumns[column].getData("type"));
                        Generator generator = GenModelUtil.createGenerator((GenModel)genModel);
                        Object[] generatorAndArguments = new Object[]{generator, genModel, projectType.getID(), projectType.getLabel()};
                        generatorAndArgumentsList.add(generatorAndArguments);
                    }
                    ++column;
                }
                ++line;
            }
            return generatorAndArgumentsList;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum ProjectType {
            MODEL{

                public String getID() {
                    return "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject";
                }

                public String getLabel() {
                    return GenModelEditPlugin.INSTANCE.getString("_UI_Model_title");
                }

                public boolean canGenerate(GenModel genModel) {
                    return genModel.canGenerate();
                }
            }
            ,
            EDIT{

                public String getID() {
                    return "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject";
                }

                public String getLabel() {
                    return GenModelEditPlugin.INSTANCE.getString("_UI_Edit_title");
                }

                public boolean canGenerate(GenModel genModel) {
                    return genModel.canGenerateEdit();
                }
            }
            ,
            EDITOR{

                public String getID() {
                    return "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject";
                }

                public String getLabel() {
                    return GenModelEditPlugin.INSTANCE.getString("_UI_Editor_title");
                }

                public boolean canGenerate(GenModel genModel) {
                    return genModel.canGenerateEditor();
                }
            }
            ,
            TESTS{

                public String getID() {
                    return "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject";
                }

                public String getLabel() {
                    return GenModelEditPlugin.INSTANCE.getString("_UI_Tests_title");
                }

                public boolean canGenerate(GenModel genModel) {
                    return genModel.canGenerateTests();
                }
            };


            public abstract boolean canGenerate(GenModel var1);

            public abstract String getID();

            public abstract String getLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GenModelSelectionDialog
    extends FilteredResourcesSelectionDialog {
        protected IContainer container;
        protected IStatus status;
        protected StatusLineManager statusLineManager;
        protected List<GenModel> genModels;
        protected Point size;
        protected Point location;

        public GenModelSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
            super(shell, multi, container, typesMask);
            this.container = container;
        }

        public void initialize(Point size, Point location) {
            this.size = size;
            this.location = location;
        }

        public List<GenModel> getGenModels() {
            if (this.genModels == null) {
                this.genModels = new ArrayList<GenModel>();
            }
            return this.genModels;
        }

        public Point getSize() {
            return this.size;
        }

        public Point getLocation() {
            return this.location;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (this.size != null) {
                newShell.setSize(this.size);
            }
            if (this.location != null) {
                newShell.setLocation(this.location);
            }
        }

        public void create() {
            super.create();
            if (this.size != null) {
                Point shellSize = this.getShell().computeSize(-1, -1);
                this.getShell().setSize(Math.max(shellSize.x, this.size.x), this.size.y);
            }
            if (this.location != null) {
                this.getShell().setLocation(this.location);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.statusLineManager = new StatusLineManager();
            this.statusLineManager.createControl(composite);
            this.statusLineManager.setCancelEnabled(true);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = this.convertVerticalDLUsToPixels(9);
            this.statusLineManager.getControl().setLayoutData((Object)gridData);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button okButton = this.getOkButton();
            okButton.setText(IDialogConstants.NEXT_LABEL);
            Button button = this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
            button.moveAbove((Control)okButton);
            button.setEnabled(false);
            button = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, false);
            button.moveBelow((Control)okButton);
            button.setEnabled(false);
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new GenModelResourceFilter(this.container);
        }

        protected void updateStatus(IStatus status) {
            this.status = status;
            super.updateStatus(status);
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        public boolean close() {
            this.location = this.getShell().getLocation();
            this.size = this.getShell().getSize();
            return super.close();
        }

        protected void okPressed() {
            if (this.status != null && (this.status.isOK() || this.status.getCode() == 1)) {
                this.computeResult();
                IProgressMonitor progressMonitor = this.statusLineManager.getProgressMonitor();
                progressMonitor.beginTask("", 10);
                List<URI> uris = GenerateHandler.getGenModelURIs((IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)3), this.getResult());
                List<GenModel> genModels = GeneratorUIUtil.loadGenModels((IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)7), uris, this.getShell());
                progressMonitor.done();
                if (!genModels.isEmpty()) {
                    this.getGenModels().addAll(genModels);
                    this.close();
                }
            }
        }

        protected class GenModelResourceFilter
        extends FilteredResourcesSelectionDialog.ResourceFilter {
            public GenModelResourceFilter(IContainer container) {
                super((FilteredResourcesSelectionDialog)GenModelSelectionDialog.this, container, false, 1);
            }

            public boolean matchItem(Object item) {
                return item instanceof IFile && "genmodel".equals(((IFile)item).getFileExtension()) && super.matchItem(item);
            }
        }
    }
}

