/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.measles.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.diseasemodels.measles.MeaslesFactory;
import org.eclipse.stem.diseasemodels.measles.MeaslesLabelValue;
import org.eclipse.stem.diseasemodels.measles.MeaslesPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;

public class MeaslesLabelValueImpl
extends SEIRLabelValueImpl
implements MeaslesLabelValue {
    protected static final double VACCINATED_EDEFAULT = 0.0;
    protected double vaccinated = 0.0;
    protected static final double IMMUNISATIONS_EDEFAULT = 0.0;
    protected double immunisations = 0.0;
    protected static final double M_EDEFAULT = 0.0;
    protected double m = 0.0;
    protected static final double INCIDENCE_V_EDEFAULT = 0.0;
    protected double incidenceV = 0.0;

    protected EClass eStaticClass() {
        return MeaslesPackage.Literals.MEASLES_LABEL_VALUE;
    }

    @Override
    public double getVaccinated() {
        return this.vaccinated;
    }

    @Override
    public void setVaccinated(double newVaccinated) {
        this.vaccinated = newVaccinated;
    }

    @Override
    public double getImmunisations() {
        return this.immunisations;
    }

    @Override
    public void setImmunisations(double newImmunisations) {
        this.immunisations = newImmunisations;
    }

    @Override
    public double getM() {
        return this.m;
    }

    @Override
    public void setM(double newM) {
        this.m = newM;
    }

    @Override
    public double getIncidenceV() {
        return this.incidenceV;
    }

    @Override
    public void setIncidenceV(double newIncidenceV) {
        this.incidenceV = newIncidenceV;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getVaccinated();
            }
            case 10: {
                return this.getImmunisations();
            }
            case 11: {
                return this.getM();
            }
            case 12: {
                return this.getIncidenceV();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setVaccinated((Double)newValue);
                return;
            }
            case 10: {
                this.setImmunisations((Double)newValue);
                return;
            }
            case 11: {
                this.setM((Double)newValue);
                return;
            }
            case 12: {
                this.setIncidenceV((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setVaccinated(0.0);
                return;
            }
            case 10: {
                this.setImmunisations(0.0);
                return;
            }
            case 11: {
                this.setM(0.0);
                return;
            }
            case 12: {
                this.setIncidenceV(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.vaccinated != 0.0;
            }
            case 10: {
                return this.immunisations != 0.0;
            }
            case 11: {
                return this.m != 0.0;
            }
            case 12: {
                return this.incidenceV != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (vaccinated: ");
        result.append(this.vaccinated);
        result.append(", immunisations: ");
        result.append(this.immunisations);
        result.append(", m: ");
        result.append(this.m);
        result.append(", incidenceV: ");
        result.append(this.incidenceV);
        result.append(')');
        return result.toString();
    }

    public IntegrationLabelValue set(IntegrationLabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        super.set((IntegrationLabelValue)v);
        this.setVaccinated(v.getVaccinated());
        this.setImmunisations(v.getImmunisations());
        this.setM(v.getM());
        this.setIncidenceV(v.getIncidenceV());
        return this;
    }

    public IntegrationLabelValue add(IntegrationLabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        super.add((IntegrationLabelValue)v);
        this.setVaccinated(this.getVaccinated() + v.getVaccinated());
        this.setImmunisations(this.getImmunisations() + v.getImmunisations());
        this.setM(this.getM() + v.getM());
        this.setIncidenceV(this.getIncidenceV() + v.getIncidenceV());
        return this;
    }

    public IntegrationLabelValue add(double value) {
        super.add(value);
        this.setVaccinated(this.getVaccinated() + value);
        this.setImmunisations(this.getImmunisations() + value);
        this.setM(this.getM() + value);
        this.setIncidenceV(this.getIncidenceV() + value);
        return this;
    }

    public IntegrationLabelValue sub(IntegrationLabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        super.sub((IntegrationLabelValue)v);
        this.setVaccinated(this.getVaccinated() - v.getVaccinated());
        this.setImmunisations(this.getImmunisations() - v.getImmunisations());
        this.setM(this.getM() - v.getM());
        this.setIncidenceV(this.getIncidenceV() - v.getIncidenceV());
        return this;
    }

    public IntegrationLabelValue divide(IntegrationLabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        super.divide((IntegrationLabelValue)v);
        this.setVaccinated(this.getVaccinated() / v.getVaccinated());
        this.setImmunisations(this.getImmunisations() / v.getImmunisations());
        this.setM(this.getM() / v.getM());
        this.setIncidenceV(this.getIncidenceV() / v.getIncidenceV());
        return this;
    }

    public IntegrationLabelValue scale(double scaleFactor) {
        super.scale(scaleFactor);
        this.setVaccinated(this.getVaccinated() * scaleFactor);
        this.setImmunisations(this.getImmunisations() * scaleFactor);
        this.setM(this.getM() * scaleFactor);
        this.setIncidenceV(this.getIncidenceV() * scaleFactor);
        return this;
    }

    public IntegrationLabelValue abs() {
        super.abs();
        this.setVaccinated(Math.abs(this.getVaccinated()));
        this.setImmunisations(Math.abs(this.getImmunisations()));
        this.setM(Math.abs(this.getM()));
        this.setIncidenceV(Math.abs(this.getIncidenceV()));
        return this;
    }

    public double max() {
        double maxValue = super.max();
        maxValue = Math.max(maxValue, this.getVaccinated());
        maxValue = Math.max(maxValue, this.getM());
        return maxValue;
    }

    public double computeDeltaAdjustment(IntegrationLabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        double factor = super.computeDeltaAdjustment((IntegrationLabelValue)v);
        if (this.getVaccinated() + v.getVaccinated() < 0.0) {
            factor = Math.min(factor, -v.getVaccinated() / this.getVaccinated());
        }
        if (this.getImmunisations() + v.getImmunisations() < 0.0) {
            factor = Math.min(factor, -v.getImmunisations() / this.getImmunisations());
        }
        if (this.getM() + v.getM() < 0.0) {
            factor = Math.min(factor, -v.getM() / this.getM());
        }
        if (this.getIncidenceV() + v.getIncidenceV() < 0.0) {
            factor = Math.min(factor, -v.getIncidenceV() / this.getIncidenceV());
        }
        return factor;
    }

    public void reset() {
        super.reset();
        this.setVaccinated(0.0);
        this.setImmunisations(0.0);
        this.setM(0.0);
        this.setIncidenceV(0.0);
    }

    public double getPopulationCount() {
        double count = super.getPopulationCount();
        count += this.getVaccinated();
        return count += this.getM();
    }

    public boolean avoidNegative(IntegrationLabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        boolean adjusted = super.avoidNegative((IntegrationLabelValue)v);
        if (this.getVaccinated() + v.getVaccinated() < 0.0) {
            adjusted = true;
            this.setVaccinated(-v.getVaccinated());
        }
        if (this.getImmunisations() + v.getImmunisations() < 0.0) {
            adjusted = true;
            this.setImmunisations(-v.getImmunisations());
        }
        if (this.getM() + v.getM() < 0.0) {
            adjusted = true;
            this.setM(-v.getM());
        }
        if (this.getIncidenceV() + v.getIncidenceV() < 0.0) {
            adjusted = true;
            this.setIncidenceV(-v.getIncidenceV());
        }
        return adjusted;
    }

    public boolean sameValue(LabelValue value) {
        MeaslesLabelValue v = (MeaslesLabelValue)value;
        if (!super.sameValue((LabelValue)v)) {
            return false;
        }
        if (this.getVaccinated() != v.getVaccinated()) {
            return false;
        }
        if (this.getImmunisations() != v.getImmunisations()) {
            return false;
        }
        if (this.getM() != v.getM()) {
            return false;
        }
        return this.getIncidenceV() == v.getIncidenceV();
    }

    public IntegrationLabelValue copy() {
        MeaslesLabelValue copy = MeaslesFactory.eINSTANCE.createMeaslesLabelValue();
        copy.set((IntegrationLabelValue)this);
        return copy;
    }

    public void prepareCycle() {
        super.prepareCycle();
        this.setImmunisations(0.0);
        this.setIncidenceV(0.0);
    }

    public double eGetDouble(int featureID) {
        switch (featureID) {
            case 9: {
                return this.getVaccinated();
            }
            case 10: {
                return this.getImmunisations();
            }
            case 11: {
                return this.getM();
            }
            case 12: {
                return this.getIncidenceV();
            }
        }
        return super.eGetDouble(featureID);
    }

    public void eSetDouble(int featureID, double newValue) {
        switch (featureID) {
            case 9: {
                this.setVaccinated(newValue);
                return;
            }
            case 10: {
                this.setImmunisations(newValue);
                return;
            }
            case 11: {
                this.setM(newValue);
                return;
            }
            case 12: {
                this.setIncidenceV(newValue);
                return;
            }
        }
        super.eSetDouble(featureID, newValue);
    }
}

