/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography.names;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.stem.geography.names.GeographicMapper;

public class GeographicNames
extends GeographicMapper {
    private static final String NAMES_BUNDLE_TYPE = "names";
    public static final String LEVEL_0_ISO_NAMES_ROOT_NAME = "level0ISONames";
    private static final String LEVEL_0_RB_NAME = "org.eclipse.stem.data.geography.level0ISONames";
    private static ResourceBundle level0RB = null;
    private static Map<String, ResourceBundle> rbMap = new HashMap<String, ResourceBundle>();

    public static String getName(String isoKey) {
        return GeographicNames.getName(isoKey, GeographicNames.keyLevel(isoKey));
    }

    public static String getName(String isoKey, int level) {
        try {
            String isoKey2 = isoKey;
            if (isoKey.length() == 3) {
                isoKey2 = GeographicNames.getAlpha2(isoKey);
            }
            ResourceBundle rb = GeographicNames.getResourceBundle(isoKey2, level, "org.eclipse.stem.data.geography", NAMES_BUNDLE_TYPE, LEVEL_0_RB_NAME, level0RB, rbMap);
            return rb.getString(isoKey2).trim();
        }
        catch (MissingResourceException e) {
            return isoKey;
        }
        catch (NullPointerException e) {
            return String.valueOf('!') + isoKey + '!';
        }
    }

    public static String getName(URI uri) {
        return GeographicNames.getName(uri.lastSegment().toString());
    }

    public static String getReverseHierarchyName(String isoKey) {
        StringBuilder sb = new StringBuilder(GeographicNames.getName(isoKey));
        String temp = isoKey;
        int i = temp.lastIndexOf("-");
        while (i > 0) {
            temp = isoKey.substring(0, i);
            sb.append(", ");
            sb.append(GeographicNames.getName(temp));
            i = temp.lastIndexOf("-");
        }
        return sb.toString();
    }

    public static Object[] getSubISOKeys(String isoKey, int level) {
        Object[] retValue = new Object[]{};
        if (isoKey.equals("ZZZ")) {
            Properties alpha2ToAlpha3Map = GeographicNames.getAlpha2ToAlpha3Map();
            if (alpha2ToAlpha3Map != null) {
                retValue = alpha2ToAlpha3Map.values().toArray();
            }
        } else {
            try {
                ResourceBundle rb = GeographicNames.getResourceBundle(isoKey, level, "org.eclipse.stem.data.geography", NAMES_BUNDLE_TYPE, LEVEL_0_RB_NAME, level0RB, rbMap);
                ArrayList<String> temp = new ArrayList<String>();
                Enumeration<String> keys = rb.getKeys();
                while (keys.hasMoreElements()) {
                    String tempKey = keys.nextElement();
                    if (!tempKey.startsWith(isoKey) || GeographicNames.keyLevel(tempKey) != level) continue;
                    temp.add(tempKey);
                }
                retValue = temp.toArray(new String[0]);
            }
            catch (MissingResourceException mre) {
                Activator.logError((String)mre.getMessage(), (Throwable)mre);
            }
        }
        return retValue;
    }

    protected static ResourceBundle getResourceBundle(String isoKey, int level, String bundlePrefix, String bundleType, String level0RBName, ResourceBundle level0RB, Map<String, ResourceBundle> rbMap) {
        ResourceBundle retValue = null;
        if (level == -1 || level == 0) {
            if (level0RB == null) {
                level0RB = ResourceBundle.getBundle(level0RBName);
            }
            retValue = level0RB;
        } else {
            String alpha2ISOKey = isoKey.substring(0, 2);
            retValue = rbMap.get(alpha2ISOKey);
            if (retValue == null) {
                retValue = GeographicNames.readResourceBundle(alpha2ISOKey, bundlePrefix, bundleType);
                if (retValue == null) {
                    Activator.logError((String)("Could not read Resource Bundle of type " + bundleType + " for \"" + alpha2ISOKey + "\""), null);
                } else {
                    rbMap.put(alpha2ISOKey, retValue);
                }
            }
        }
        return retValue;
    }
}

