/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.presentation;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class CodeGenUIPlugin
extends AbstractUIPlugin {
    private static CodeGenUIPlugin plugin;

    public static CodeGenUIPlugin getPlugin() {
        return plugin;
    }

    public static ResourceBundle getResourceBundle() {
        return Platform.getResourceBundle((Bundle)plugin.getBundle());
    }

    public CodeGenUIPlugin() {
        plugin = this;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public String getString(String key) {
        return Platform.getResourceBundle((Bundle)plugin.getBundle()).getString(key);
    }

    public ImageDescriptor getImage(String key) {
        try {
            String suffix = key.endsWith(".png") ? "" : ".gif";
            return ImageDescriptor.createFromURL((URL)new URL(this.getBundle().getEntry("/") + "icons/" + key + suffix));
        }
        catch (MalformedURLException exception) {
            CodeGenUIPlugin.write(exception);
            return null;
        }
    }

    public Image getActualImage(String key) {
        Image image;
        block6: {
            String suffix = key.endsWith(".png") ? "" : ".gif";
            URL url = new URL(this.getBundle().getEntry("/") + "icons/" + key + suffix);
            InputStream in = null;
            try {
                in = url.openStream();
                image = new Image((Device)Display.getDefault(), in);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            in.close();
        }
        return image;
    }

    public void log(Object logEntry) {
        if (logEntry instanceof IStatus) {
            IStatus status = (IStatus)logEntry;
            this.getLog().log(status);
        } else {
            if (logEntry == null) {
                logEntry = new RuntimeException(this.getString("_UI_NullLogEntry_exception")).fillInStackTrace();
            }
            if (logEntry instanceof Throwable) {
                this.getLog().log(CodeGenUIPlugin.toStatus(2, (Throwable)logEntry));
            } else {
                this.getLog().log((IStatus)new Status(2, this.getBundle().getSymbolicName(), 0, logEntry.toString(), null));
            }
        }
    }

    public static IStatus toStatus(int severity, Throwable throwable) {
        String message = throwable.getLocalizedMessage();
        if (message == null) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                message = cause.getLocalizedMessage();
            }
            if (message == null) {
                message = "";
            }
        }
        return new Status(severity, CodeGenUIPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, throwable);
    }

    public String getString(String key, Object[] objects) {
        return MessageFormat.format(this.getString(key), objects);
    }

    public static void write(Exception exception) {
        DiagnosticDialog.open((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CodeGenUIPlugin.getPlugin().getString("_UI_JETProblem_title"), (String)(exception instanceof JETException ? CodeGenUIPlugin.getPlugin().getString("_UI_JETCompileProblem_message") : null), (Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)exception));
    }
}

