/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.Activator;

public class AggregateDataWriter {
    private final String aggregateFileName;
    private static final String keyS = "S";
    private static final String keyE = "E";
    private static final String keyI = "I";
    private static final String keyR = "R";
    private static final String keyBirths = "Births";
    private static final String keyDeaths = "Deaths";
    private static final String keyDeltaBirths = "deltaBirths";
    private static final String keyDeltaDeaths = "deltaDeaths";
    private static final String keyIncidence = "Incidence";
    private static List<String> birthsList = null;
    private static List<String> deathsList = null;
    private static List<String> deltaBirthsList = new ArrayList<String>();
    private static List<String> deltaDeathsList = new ArrayList<String>();
    private static double pastBirths = 0.0;
    private static double pastDeaths = 0.0;
    private static final IPath PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private static final String sep = File.separator;
    public static final String ANALYSISFOLDER = PATH.toOSString();
    public static final String AGGREGATE_FOLDERNAME = "aggregate";
    private static final String aggregatePathSuffix = "aggregate" + sep;
    private String aggregateDirectoryName = PATH.append(String.valueOf(sep) + aggregatePathSuffix).toOSString();
    private FileWriter fw1;

    public AggregateDataWriter(String dataFolder, String aggregateDataFileName) {
        boolean success;
        Path p = new Path(dataFolder);
        p = p.removeLastSegments(1);
        p = p.append(AGGREGATE_FOLDERNAME);
        this.aggregateDirectoryName = p.toOSString();
        File dir = new File(this.aggregateDirectoryName);
        if (!(dir.exists() && dir.isDirectory() || (success = dir.mkdirs()))) {
            Activator.logError("Failed to Create Directory" + this.aggregateDirectoryName, new IOException("Failed to Create Driectory" + this.aggregateDirectoryName));
        }
        this.aggregateFileName = String.valueOf(this.aggregateDirectoryName) + sep + aggregateDataFileName;
        try {
            this.fw1 = new FileWriter(this.aggregateFileName);
        }
        catch (IOException e) {
            Activator.logError("Error opening data file" + this.aggregateDirectoryName + " " + this.aggregateFileName, e);
        }
    }

    public String logDataInstance(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data, double alpha) {
        Map instance = data.getInstance();
        Set<String> keySet = instance.keySet();
        String[] keys = this.sortKeys(keySet, data);
        List dataList = (List)instance.get(keys[0]);
        String header = keys[0];
        StringBuilder strBldr = new StringBuilder(header);
        int i = 1;
        while (i < keys.length) {
            strBldr.append(",");
            strBldr.append(keys[i].toString().trim());
            ++i;
        }
        strBldr.append("\n");
        try {
            this.fw1.append(strBldr.toString());
        }
        catch (IOException e) {
            Activator.logError("Error writing aggregate data file" + this.aggregateDirectoryName + " " + this.aggregateFileName, e);
        }
        birthsList = (List)data.getInstance().get(keyBirths);
        data.getInstance().put(keyBirths, birthsList);
        deathsList = (List)data.getInstance().get(keyDeaths);
        data.getInstance().put(keyDeaths, deathsList);
        int dataSize = dataList.size();
        int i22 = 0;
        while (i22 < dataSize) {
            String key = keys[0].toString();
            List valueList = (List)data.getInstance().get(key);
            strBldr = new StringBuilder();
            strBldr.append((String)valueList.get(i22));
            strBldr.append(" ");
            int j = 1;
            while (j < keys.length) {
                key = keys[j].toString();
                valueList = (List)data.getInstance().get(key);
                strBldr.append(", ");
                strBldr.append((String)valueList.get(i22));
                ++j;
            }
            strBldr.append("\n");
            try {
                this.fw1.append(strBldr.toString());
            }
            catch (IOException e) {
                Activator.logError("Error writing aggregate data file" + this.aggregateDirectoryName + this.aggregateFileName, e);
            }
            ++i22;
        }
        try {
            if (this.fw1 != null) {
                this.fw1.flush();
                this.fw1.close();
            }
        }
        catch (IOException i22) {
            // empty catch block
        }
        if (birthsList != null) {
            int i3 = 0;
            while (i3 < birthsList.size()) {
                deltaBirthsList.add(i3, birthsList.get(i3));
                ++i3;
            }
            if (deltaBirthsList != null) {
                pastBirths = 0.0;
                int ii = 0;
                while (ii < deltaBirthsList.size()) {
                    double births = Double.valueOf(deltaBirthsList.get(ii));
                    deltaBirthsList.set(ii, "" + (births - pastBirths));
                    pastBirths = births;
                    ++ii;
                }
            }
        }
        if (deathsList != null) {
            int i4 = 0;
            while (i4 < deathsList.size()) {
                deltaDeathsList.add(i4, deathsList.get(i4));
                ++i4;
            }
            if (deltaDeathsList != null) {
                pastDeaths = 0.0;
                int ii = 0;
                while (ii < deltaDeathsList.size()) {
                    double deaths = Double.valueOf(deltaDeathsList.get(ii));
                    deltaDeathsList.set(ii, "" + (deaths - pastDeaths));
                    pastDeaths = deaths;
                    ++ii;
                }
            }
        }
        data.getInstance().put(keyDeltaBirths, deltaBirthsList);
        data.getInstance().put(keyDeltaDeaths, deltaDeathsList);
        return this.aggregateFileName;
    }

    private String[] sortKeys(Set<String> keySet, ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        List<String> preferredKeyOrder = this.getPreferredKeyOrder(data);
        String[] keys = new String[keySet.size()];
        int icount = 0;
        HashSet<String> doneSet = new HashSet<String>();
        int i = 0;
        while (i < preferredKeyOrder.size()) {
            if (keySet.contains(preferredKeyOrder.get(i))) {
                keys[icount] = preferredKeyOrder.get(i).trim();
                ++icount;
                doneSet.add(preferredKeyOrder.get(i));
            }
            ++i;
        }
        Iterator<String> iter = keySet.iterator();
        while (iter != null && iter.hasNext()) {
            String nextKey = iter.next();
            if (doneSet.contains(nextKey)) continue;
            keys[icount] = nextKey;
            ++icount;
        }
        return keys;
    }

    public List<String> getPreferredKeyOrder(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        int i;
        ArrayList<String> preferredKeyOrder = new ArrayList<String>();
        preferredKeyOrder.add("iteration");
        preferredKeyOrder.add("time");
        String[] sKeys = data.getDataMap().getS_Keys();
        String[] eKeys = data.getDataMap().getE_Keys();
        String[] iKeys = data.getDataMap().getI_Keys();
        String[] rKeys = data.getDataMap().getR_Keys();
        if (sKeys != null) {
            i = 0;
            while (i < sKeys.length) {
                preferredKeyOrder.add(sKeys[i]);
                ++i;
            }
        }
        if (eKeys != null) {
            i = 0;
            while (i < eKeys.length) {
                preferredKeyOrder.add(eKeys[i]);
                ++i;
            }
        }
        if (iKeys != null) {
            i = 0;
            while (i < iKeys.length) {
                preferredKeyOrder.add(iKeys[i]);
                ++i;
            }
        }
        if (rKeys != null) {
            i = 0;
            while (i < rKeys.length) {
                preferredKeyOrder.add(rKeys[i]);
                ++i;
            }
        }
        preferredKeyOrder.add(keyBirths);
        preferredKeyOrder.add(keyDeaths);
        return preferredKeyOrder;
    }

    public static String getKeyS() {
        return keyS;
    }

    public static String getKeyE() {
        return keyE;
    }

    public static String getKeyI() {
        return keyI;
    }

    public static String getKeyR() {
        return keyR;
    }

    public static String getKeyIncidence() {
        return keyIncidence;
    }
}

