/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.serializer;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentReference;
import org.eclipse.stem.model.ctdl.serializer.ITypeSerializer;

public abstract class CompartmentTypeSerializers
implements ITypeSerializer {
    protected CompartmentReference compartmentReference;
    protected GenClass gc;

    public CompartmentTypeSerializers(CompartmentReference compartmentReference, GenClass gc) {
        this.gc = gc;
        this.compartmentReference = compartmentReference;
    }

    public static class EAttributeSerializer
    extends CompartmentTypeSerializers {
        public EAttributeSerializer(CompartmentReference compartment, GenClass gc) {
            super(compartment, gc);
        }

        @Override
        public CharSequence serialize() {
            String compartmentName = this.compartmentReference.getName();
            GenFeature compartmentFeature = null;
            for (GenFeature feature : this.gc.getAllGenFeatures()) {
                if (!feature.getName().equalsIgnoreCase(compartmentName)) continue;
                compartmentFeature = feature;
                break;
            }
            if (compartmentFeature != null) {
                GenPackage genPackage = compartmentFeature.getGenPackage();
                GenModel genModel = this.gc.getGenModel();
                String qualifiedPackageName = String.valueOf(genPackage.getReflectionPackageName()) + "." + genPackage.getPackageInterfaceName();
                String packageName = genModel.getImportedName(qualifiedPackageName);
                String serializedAccessor = String.valueOf(packageName) + ".eINSTANCE.get" + compartmentFeature.getFeatureAccessorName() + "()";
                return serializedAccessor;
            }
            return "";
        }
    }
}

