/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationChange;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@Accessors(value={AccessorType.PUBLIC_GETTER})
public class ResourceRelocationContext {
    private final ChangeType changeType;
    private final List<ResourceRelocationChange> changes;
    private final RefactoringIssueAcceptor issueAcceptor;
    private final IChangeSerializer changeSerializer;
    private final ResourceSet resourceSet;

    public void addModification(ResourceRelocationChange change, IChangeSerializer.IModification<Resource> modification) {
        this.changeSerializer.addModification(this.loadAndWatchResource(change), modification);
    }

    protected Resource loadAndWatchResource(ResourceRelocationChange change) {
        try {
            Resource _switchResult = null;
            ChangeType changeType = this.changeType;
            if (changeType != null) {
                switch (changeType) {
                    case MOVE: 
                    case RENAME: {
                        Resource _xblockexpression = null;
                        Resource original = this.resourceSet.getResource(change.getFromURI(), true);
                        IChangeSerializer.IModification<Resource> _function = it -> original.setURI(change.getToURI());
                        this.changeSerializer.addModification(original, _function);
                        _switchResult = _xblockexpression = original;
                        break;
                    }
                    case COPY: {
                        Resource _xblockexpression_1 = null;
                        Resource copy = this.resourceSet.createResource(change.getFromURI());
                        copy.load(this.resourceSet.getURIConverter().createInputStream(change.getFromURI()), null);
                        copy.setURI(change.getToURI());
                        _switchResult = _xblockexpression_1 = copy;
                        break;
                    }
                }
            }
            Resource resource = _switchResult;
            return resource;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ResourceRelocationContext(ChangeType changeType, List<ResourceRelocationChange> changes, RefactoringIssueAcceptor issueAcceptor, IChangeSerializer changeSerializer, ResourceSet resourceSet) {
        this.changeType = changeType;
        this.changes = changes;
        this.issueAcceptor = issueAcceptor;
        this.changeSerializer = changeSerializer;
        this.resourceSet = resourceSet;
    }

    @Pure
    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Pure
    public List<ResourceRelocationChange> getChanges() {
        return this.changes;
    }

    @Pure
    public RefactoringIssueAcceptor getIssueAcceptor() {
        return this.issueAcceptor;
    }

    @Pure
    public IChangeSerializer getChangeSerializer() {
        return this.changeSerializer;
    }

    @Pure
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public static enum ChangeType {
        COPY,
        MOVE,
        RENAME;

    }
}

