/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;

public class HelpEditorUtil {
    public static final String[] pageExtensions = new String[]{"htm", "shtml", "html", "xhtml"};
    public static final String tocExtension = "xml";
    private static HashSet<String> pageExtensionSet = new HashSet(pageExtensions.length);

    private static void populateHashSet() {
        String[] stringArray = pageExtensions;
        int n = pageExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String pageExtension = stringArray[n2];
            pageExtensionSet.add(pageExtension);
            ++n2;
        }
    }

    public static boolean hasValidPageExtension(IPath path) {
        String fileExtension = path.getFileExtension();
        if (fileExtension != null) {
            fileExtension = fileExtension.toLowerCase(Locale.ENGLISH);
            if (pageExtensionSet.isEmpty()) {
                HelpEditorUtil.populateHashSet();
            }
            return pageExtensionSet.contains(fileExtension);
        }
        return false;
    }

    private static boolean hasValidTocExtension(IPath path) {
        String fileExtension = path.getFileExtension();
        return fileExtension != null && fileExtension.equals(tocExtension);
    }

    public static boolean isTOCFile(IPath path) {
        if (!HelpEditorUtil.hasValidTocExtension(path)) {
            return false;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(path);
        if (resource != null && resource instanceof IFile) {
            try {
                IFile file = (IFile)resource;
                IContentDescription description = file.getContentDescription();
                IContentType type = description.getContentType();
                return type.getId().equalsIgnoreCase("org.eclipse.pde.tocFile");
            }
            catch (CoreException e) {
                PDEUserAssistanceUIPlugin.logException(e);
            }
        } else {
            File file = path.toFile();
            IContentTypeManager manager = Platform.getContentTypeManager();
            try {
                FileInputStream stream = new FileInputStream(file);
                IContentType type = manager.findContentTypeFor((InputStream)stream, file.getName());
                return type.getId().equalsIgnoreCase("org.eclipse.pde.tocFile");
            }
            catch (IOException e) {
                PDEUserAssistanceUIPlugin.logException(e);
            }
        }
        return false;
    }

    public static boolean isCurrentResource(IPath path, IBaseModel model) {
        if (model instanceof IModel) {
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath fullPath = workspacePath.isPrefixOf(path) ? ((IModel)model).getUnderlyingResource().getLocation() : ((IModel)model).getUnderlyingResource().getFullPath();
            return fullPath.equals((Object)path);
        }
        return false;
    }

    public static String getPageExtensionList() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < pageExtensions.length) {
            buf.append('.');
            buf.append(pageExtensions[i]);
            if (i != pageExtensions.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }
}

