/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.util.NLS;

public class EECompilationParticipant
extends CompilationParticipant {
    private Set<IJavaProject> fCleaned = new HashSet<IJavaProject>();

    public boolean isActive(IJavaProject project) {
        return true;
    }

    public void cleanStarting(IJavaProject project) {
        super.cleanStarting(project);
        this.fCleaned.add(project);
    }

    public void buildFinished(IJavaProject project) {
        super.buildFinished(project);
        if (this.fCleaned.remove(project)) {
            IVMInstall vm;
            String eeId = null;
            IPath container = null;
            try {
                IClasspathEntry[] rawClasspath = project.getRawClasspath();
                int j = 0;
                while (j < rawClasspath.length) {
                    IPath path;
                    IClasspathEntry entry = rawClasspath[j];
                    if (entry.getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals((path = entry.getPath()).segment(0))) {
                        container = path;
                        eeId = JREContainerInitializer.getExecutionEnvironmentId(path);
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
            if (container != null && eeId != null) {
                vm = JREContainerInitializer.resolveVM(container);
                this.validateEnvironment(eeId, project, vm);
                if (vm instanceof IVMInstall2 && (eeId = EECompilationParticipant.getCompilerCompliance((IVMInstall2)((Object)vm))) != null) {
                    this.validateCompliance(eeId, project, vm);
                }
            } else if (container != null && (vm = JREContainerInitializer.resolveVM(container)) instanceof IVMInstall2 && (eeId = EECompilationParticipant.getCompilerCompliance((IVMInstall2)((Object)vm))) != null) {
                this.validateCompliance(eeId, project, vm);
            }
        }
    }

    private void validateCompliance(String eeId, IJavaProject project, IVMInstall vm) {
        String id = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (!eeId.equals(id)) {
            String releaseVal;
            boolean validateCompliance = true;
            if (JavaCore.compareJavaVersions((String)"9", (String)eeId) <= 0 && JavaCore.compareJavaVersions((String)"1.6", (String)id) <= 0 && "enabled".equals(releaseVal = project.getOption("org.eclipse.jdt.core.compiler.release", true))) {
                validateCompliance = false;
            }
            if (validateCompliance) {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
                IExecutionEnvironment finalEnvironment = null;
                IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
                int n = environments.length;
                int n2 = 0;
                while (n2 < n) {
                    IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
                    if (environment.getId().indexOf(id) != -1) {
                        finalEnvironment = environment;
                        break;
                    }
                    ++n2;
                }
                if (finalEnvironment != null && !finalEnvironment.isStrictlyCompatible(vm)) {
                    String message = NLS.bind((String)LaunchingMessages.LaunchingPlugin_39, (Object[])new String[]{id, eeId});
                    int sev = this.getSeverityLevel(JavaRuntime.PREF_COMPILER_COMPLIANCE_DOES_NOT_MATCH_JRE, project.getProject());
                    if (sev != -1) {
                        this.createProblemMarker(project, message, sev, "org.eclipse.jdt.core.problem", LaunchingMessages.LaunchingPlugin_40);
                    }
                }
            }
        }
    }

    private void validateEnvironment(String id, IJavaProject project, IVMInstall vm) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment environment = manager.getEnvironment(id);
        if (environment != null) {
            if (vm == null) {
                String message = NLS.bind((String)LaunchingMessages.LaunchingPlugin_38, (Object[])new String[]{environment.getId()});
                this.createJREContainerProblem(project, message, 2);
            } else if (!environment.isStrictlyCompatible(vm)) {
                IVMInstall[] compatibleVMs = environment.getCompatibleVMs();
                int exact = 0;
                int i = 0;
                while (i < compatibleVMs.length) {
                    if (environment.isStrictlyCompatible(compatibleVMs[i])) {
                        ++exact;
                    }
                    ++i;
                }
                String message = null;
                message = exact == 0 ? NLS.bind((String)LaunchingMessages.LaunchingPlugin_35, (Object[])new String[]{environment.getId()}) : NLS.bind((String)LaunchingMessages.LaunchingPlugin_36, (Object[])new String[]{environment.getId()});
                int sev = this.getSeverityLevel(JavaRuntime.PREF_STRICTLY_COMPATIBLE_JRE_NOT_AVAILABLE, project.getProject());
                if (sev != -1) {
                    this.createJREContainerProblem(project, message, sev);
                }
            }
        }
    }

    public static String getCompilerCompliance(IVMInstall2 vMInstall) {
        String version = vMInstall.getJavaVersion();
        if (version == null) {
            return null;
        }
        if (version.startsWith("10")) {
            return "10";
        }
        if (version.startsWith("9")) {
            return "9";
        }
        if (version.startsWith("1.8")) {
            return "1.8";
        }
        if (version.startsWith("1.7")) {
            return "1.7";
        }
        if (version.startsWith("1.6")) {
            return "1.6";
        }
        if (version.startsWith("1.5")) {
            return "1.5";
        }
        if (version.startsWith("1.4")) {
            return "1.4";
        }
        if (version.startsWith("1.3")) {
            return "1.3";
        }
        if (version.startsWith("1.2")) {
            return "1.3";
        }
        if (version.startsWith("1.1")) {
            return "1.3";
        }
        return null;
    }

    private int getSeverityLevel(String prefkey, IProject project) {
        String value;
        IPreferencesService service = Platform.getPreferencesService();
        ArrayList<Object> scopes = new ArrayList<Object>();
        scopes.add(InstanceScope.INSTANCE);
        if (project != null) {
            scopes.add(new ProjectScope(project));
        }
        if ((value = service.getString("org.eclipse.jdt.launching", prefkey, null, scopes.toArray(new IScopeContext[scopes.size()]))) == null) {
            value = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching").get(prefkey, null);
        }
        if ("error".equals(value)) {
            return 2;
        }
        if ("warning".equals(value)) {
            return 1;
        }
        if ("info".equals(value)) {
            return 0;
        }
        return -1;
    }

    private void createJREContainerProblem(IJavaProject javaProject, String message, int severity) {
        try {
            IMarker marker = javaProject.getProject().createMarker(JavaRuntime.JRE_CONTAINER_MARKER);
            marker.setAttributes(new String[]{"message", "severity", "location"}, new Object[]{message, new Integer(severity), LaunchingMessages.LaunchingPlugin_37});
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private void createProblemMarker(IJavaProject javaProject, String message, int severity, String problemId, String location) {
        try {
            IMarker marker = javaProject.getProject().createMarker(problemId);
            marker.setAttributes(new String[]{"message", "severity", "location"}, new Object[]{message, new Integer(severity), location});
        }
        catch (CoreException coreException) {
            return;
        }
    }
}

