/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;

@API(status=API.Status.EXPERIMENTAL, since="5.7")
public abstract class TypedArgumentConverter<S, T>
implements ArgumentConverter {
    private final Class<S> sourceType;
    private final Class<T> targetType;

    protected TypedArgumentConverter(Class<S> sourceType, Class<T> targetType) {
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    @Override
    public final Object convert(Object source, ParameterContext context) throws ArgumentConversionException {
        if (!this.sourceType.isAssignableFrom(source.getClass())) {
            throw new ArgumentConversionException("Can only convert objects of type " + this.sourceType);
        }
        if (!this.targetType.isAssignableFrom(context.getParameter().getType())) {
            throw new ArgumentConversionException("Can only convert to type " + this.targetType);
        }
        return this.convert(this.sourceType.cast(source));
    }

    protected abstract T convert(S var1) throws ArgumentConversionException;
}

