/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBinaryStreamListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.StreamDecoder;

public class OutputStreamMonitor
implements IBinaryStreamMonitor {
    private static final int BUFFER_SIZE = 8192;
    private InputStream fStream;
    private ListenerList<IStreamListener> fListeners = new ListenerList();
    private ListenerList<IBinaryStreamListener> fBinaryListeners = new ListenerList();
    private ByteArrayOutputStream fContents;
    private StreamDecoder fBufferedDecoder;
    private String fCachedDecodedContents;
    private Thread fThread;
    private boolean fKilled = false;
    private long lastSleep;
    private Charset fCharset;
    private StreamDecoder fDecoder;
    private final AtomicBoolean fDone;

    public OutputStreamMonitor(InputStream stream, Charset charset) {
        this.fStream = new BufferedInputStream(stream, 8192);
        this.fCharset = charset;
        this.fDecoder = new StreamDecoder(charset == null ? Charset.defaultCharset() : charset);
        this.fDone = new AtomicBoolean(false);
        this.setBuffered(true);
    }

    @Deprecated
    public OutputStreamMonitor(InputStream stream, String encoding) {
        this(stream, Charset.forName(encoding));
    }

    @Override
    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public synchronized void addBinaryListener(IBinaryStreamListener listener) {
        this.fBinaryListeners.add((Object)listener);
    }

    protected void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fListeners = new ListenerList();
            this.fBinaryListeners = new ListenerList();
        }
    }

    private void fireStreamAppended(byte[] data, int offset, int length) {
        if (!this.fListeners.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.fDecoder.decode(sb, data, offset, length);
            final String text = sb.toString();
            for (final IStreamListener listener : this.fListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.streamAppended(text, OutputStreamMonitor.this);
                    }

                    public void handleException(Throwable exception) {
                        DebugPlugin.log(exception);
                    }
                });
            }
        }
        if (!this.fBinaryListeners.isEmpty()) {
            byte[] validData;
            if (offset > 0 || length < data.length) {
                validData = new byte[length];
                System.arraycopy(data, offset, validData, 0, length);
            } else {
                validData = data;
            }
            for (final IBinaryStreamListener listener : this.fBinaryListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.streamAppended(validData, OutputStreamMonitor.this);
                    }

                    public void handleException(Throwable exception) {
                        DebugPlugin.log(exception);
                    }
                });
            }
        }
    }

    @Override
    public synchronized String getContents() {
        if (!this.isBuffered()) {
            return "";
        }
        if (this.fCachedDecodedContents != null) {
            return this.fCachedDecodedContents;
        }
        StringBuilder sb = new StringBuilder();
        byte[] data = this.getData();
        this.fBufferedDecoder.decode(sb, data, 0, data.length);
        this.fCachedDecodedContents = sb.toString();
        return this.fCachedDecodedContents;
    }

    @Override
    public synchronized byte[] getData() {
        return this.isBuffered() ? this.fContents.toByteArray() : new byte[]{};
    }

    private void read() {
        try {
            this.internalRead();
        }
        finally {
            this.fDone.set(true);
        }
    }

    /*
     * Exception decompiling
     */
    private void internalRead() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void kill() {
        this.fKilled = true;
    }

    @Override
    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public synchronized void removeBinaryListener(IBinaryStreamListener listener) {
        this.fBinaryListeners.remove((Object)listener);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fDone.set(false);
            this.fThread = new Thread(this::read, DebugCoreMessages.OutputStreamMonitor_label);
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    @Override
    public synchronized void setBuffered(boolean buffer) {
        if (this.isBuffered() != buffer) {
            this.fCachedDecodedContents = null;
            if (buffer) {
                this.fContents = new ByteArrayOutputStream();
                this.fBufferedDecoder = new StreamDecoder(this.fCharset == null ? Charset.defaultCharset() : this.fCharset);
            } else {
                this.fContents = null;
                this.fBufferedDecoder = null;
            }
        }
    }

    @Override
    public synchronized void flushContents() {
        if (this.isBuffered()) {
            this.fCachedDecodedContents = null;
            this.fContents.reset();
        }
    }

    @Override
    public synchronized boolean isBuffered() {
        return this.fContents != null;
    }

    public boolean isReadingDone() {
        return this.fDone.get();
    }
}

