/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.analysis.automaticexperiment.Activator;
import org.eclipse.stem.analysis.automaticexperiment.views.AnalysisControl;
import org.eclipse.stem.analysis.automaticexperiment.views.Messages;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class RunHistoryCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private AnalysisControl control = null;
    private int chartIndex = 0;
    protected static final ColorDefinition[] colorDefault = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.BLACK(), ColorDefinitionImpl.GREY(), ColorDefinitionImpl.CYAN(), ColorDefinitionImpl.ORANGE()};
    private boolean overlayMode = false;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    protected final Map<String, DataSeries> dataSeriesMap = new HashMap<String, DataSeries>();
    protected Map<String, Boolean> visibleMap = new HashMap<String, Boolean>();
    private final List<Double> cycleNumbers = new ArrayList<Double>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxY = -1.0;
    private double minYscale = 1.0;
    public String Ordinate_LEGEND = "Y";
    public String Ordinate_AXIS = "Y";
    public String X_AXIS = "X";
    private ColorDefinition foreGround = ColorDefinitionImpl.WHITE();
    private ColorDefinition backgroundGround = ColorDefinitionImpl.BLACK();
    private ColorDefinition frameColor = ColorDefinitionImpl.create((int)180, (int)180, (int)200);
    Image imgChart = null;

    public RunHistoryCanvas(AnalysisControl analysisControl, Composite parent, String ordinateString, String yAxisLabel, String xAxisLabel, String firstProperty, ColorDefinition foreground, ColorDefinition background, ColorDefinition framecolor, int chartIndex, boolean overlayMode) {
        super(parent, 0x20000800);
        this.Ordinate_LEGEND = ordinateString;
        this.Ordinate_AXIS = yAxisLabel;
        this.X_AXIS = xAxisLabel;
        this.foreGround = foreground;
        this.backgroundGround = background;
        this.frameColor = framecolor;
        this.chartIndex = chartIndex;
        this.overlayMode = overlayMode;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        this.control = analysisControl;
        this.cm = this.createSimpleLineChart(firstProperty, this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (RunHistoryCanvas.this.imgChart != null) {
                    RunHistoryCanvas.this.imgChart.dispose();
                }
                RunHistoryCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                RunHistoryCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)RunHistoryCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)RunHistoryCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    RunHistoryCanvas.this.gr.render(RunHistoryCanvas.this.idr, RunHistoryCanvas.this.gr.build(RunHistoryCanvas.this.idr.getDisplayServer(), RunHistoryCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(RunHistoryCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public RunHistoryCanvas(Composite parent, String ordinateString, String yAxisLabel, String xAxisLabel, String firstProperty, ColorDefinition foreground, ColorDefinition background, ColorDefinition framecolor, int chartIndex) {
        super(parent, 0x20000800);
        this.Ordinate_LEGEND = ordinateString;
        this.Ordinate_AXIS = yAxisLabel;
        this.X_AXIS = xAxisLabel;
        this.foreGround = foreground;
        this.backgroundGround = background;
        this.frameColor = framecolor;
        this.chartIndex = chartIndex;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        this.control = (AnalysisControl)parent;
        this.cm = this.createSimpleLineChart(firstProperty, this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (RunHistoryCanvas.this.imgChart != null) {
                    RunHistoryCanvas.this.imgChart.dispose();
                }
                RunHistoryCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                RunHistoryCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)RunHistoryCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)RunHistoryCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    RunHistoryCanvas.this.gr.render(RunHistoryCanvas.this.idr, RunHistoryCanvas.this.gr.build(RunHistoryCanvas.this.idr.getDisplayServer(), RunHistoryCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(RunHistoryCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        this.resetData();
        this.yAxisPrimary.getSeriesDefinitions().clear();
        int maxLines = this.control.getNumProperties(this.chartIndex);
        int i = 0;
        while (i < maxLines) {
            DataSeries series;
            String property = this.control.getProperty(this.chartIndex, i);
            if (!this.dataSeriesMap.containsKey(property)) {
                series = new DataSeries(property, i, this.overlayMode);
                if (this.visibleMap.containsKey(property)) {
                    series.setVisible(this.visibleMap.get(property));
                } else {
                    series.setVisible(true);
                    this.visibleMap.put(property, true);
                }
                this.dataSeriesMap.put(property, series);
            }
            series = this.dataSeriesMap.get(property);
            series.show();
            ++i;
        }
        this.maxY = -1.0;
        boolean setCycles = false;
        int maxPoints = 0;
        int i2 = 0;
        while (i2 < maxLines) {
            String property = this.control.getProperty(this.chartIndex, i2);
            double[] doubleValues = this.control.getValues(this.chartIndex, i2);
            if (doubleValues == null) {
                doubleValues = new double[]{};
            }
            DataSeries series = this.dataSeriesMap.get(property);
            if (this.dataSeriesMap.get(property).isVisible()) {
                int j = 0;
                while (j < doubleValues.length) {
                    if (doubleValues[j] <= this.minYscale && doubleValues[j] > 0.0) {
                        this.minYscale = doubleValues[j];
                    }
                    if (doubleValues[j] >= this.maxY) {
                        this.maxY = doubleValues[j];
                        double log = Math.floor(Math.log10(this.maxY));
                        double adjustedMax = Math.ceil(this.maxY / Math.pow(10.0, log)) * Math.pow(10.0, log);
                        if (adjustedMax <= 1.0) {
                            adjustedMax = 1.0;
                        }
                        if (this.useLinearTimeScale) {
                            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)adjustedMax));
                            double step = adjustedMax / 10.0;
                            this.yAxisPrimary.getScale().setStep(step);
                        } else {
                            double ymax = Math.log(adjustedMax);
                            if (adjustedMax > 1.0) {
                                long imax = Math.round(ymax += 0.499);
                                ymax = imax;
                            }
                            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)ymax));
                            double step = ymax / 10.0;
                            this.yAxisPrimary.getScale().setStep(step);
                        }
                    }
                    ++j;
                }
            }
            if (doubleValues.length > 0) {
                if (maxPoints < doubleValues.length) {
                    maxPoints = doubleValues.length;
                }
                int cycleNumber = 0;
                while (cycleNumber < doubleValues.length) {
                    double displayValue = doubleValues[cycleNumber];
                    if (displayValue <= this.minYscale) {
                        displayValue = this.minYscale;
                    }
                    Double value = this.useLinearTimeScale ? Double.valueOf(displayValue) : Double.valueOf(Math.log(displayValue));
                    series.addValue(value);
                    if (!setCycles) {
                        this.cycleNumbers.add(Double.valueOf(cycleNumber));
                    }
                    ++cycleNumber;
                }
                if (((SeriesDefinition)this.xAxisPrimary.getSeriesDefinitions().get(0)).getSeries().size() != this.cycleNumbers.size()) {
                    this.xAxisPrimary.getSeriesDefinitions().clear();
                    Series xAxisSeries = SeriesImpl.create();
                    NumberDataSet xValues = NumberDataSetImpl.create(this.cycleNumbers);
                    xAxisSeries.setDataSet((DataSet)xValues);
                    SeriesDefinition sdX = SeriesDefinitionImpl.create();
                    this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
                    sdX.getSeries().add((Object)xAxisSeries);
                }
                setCycles = true;
            }
            ++i2;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public final Chart createSimpleLineChart(String firstProperty, Map<String, DataSeries> dataSeriesMap, List<Double> cycleNumbers, String seriesIdentifier) {
        ChartWithAxes retValue = ChartWithAxesImpl.create();
        retValue.getBlock().setBackground((Fill)this.frameColor);
        Plot p = retValue.getPlot();
        p.getClientArea().setBackground((Fill)this.backgroundGround);
        retValue.getTitle().setVisible(false);
        this.legend = retValue.getLegend();
        LineAttributes lia = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.foreGround);
        this.legend.getOutline().setColor(this.foreGround);
        this.xAxisPrimary = retValue.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        Series xAxisSeries = SeriesImpl.create();
        xAxisSeries.getLabel().getCaption().setColor(this.foreGround);
        xAxisSeries.getLabel().getOutline().setColor(this.foreGround);
        NumberDataSet xValues = NumberDataSetImpl.create(cycleNumbers);
        xAxisSeries.setDataSet((DataSet)xValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)xAxisSeries);
        this.yAxisPrimary = retValue.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.xAxisPrimary.getTitle().getCaption().setValue(this.X_AXIS);
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary.getTitle().getCaption().setValue(this.Ordinate_AXIS);
        this.yAxisPrimary.getTitle().setVisible(true);
        if (!dataSeriesMap.containsKey(firstProperty)) {
            DataSeries series = new DataSeries(Messages.getString("AUTO.TITLE1"), 0, this.overlayMode);
            dataSeriesMap.put(firstProperty, series);
        }
        return retValue;
    }

    protected void createContextMenu(Composite parent) {
        MenuManager contextMenuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        contextMenuManager.add((IAction)this.linearTimeAction);
        contextMenuManager.add((IAction)this.logTimeAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        contextMenuManager.add((IAction)this.viewLegend);
        contextMenuManager.add((IAction)this.hideLegend);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(this.popUpMenu);
    }

    public static void setColorDefs(List<String> propertiesToPlot, List<LineSeries> lsList) {
        Map colorMap = VisualizationPreferencePage.getColorMapping();
        int i = 0;
        while (i < lsList.size()) {
            ColorDefinition color = ColorDefinitionImpl.BLUE();
            if (propertiesToPlot != null && propertiesToPlot.size() > i) {
                String key = propertiesToPlot.get(i);
                if (colorMap.containsKey(key)) {
                    STEMColor c = (STEMColor)colorMap.get(key);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                }
                lsList.get(i).setSeriesIdentifier((Object)key);
                lsList.get(i).getLineAttributes().setColor(color);
            } else if (lsList.get(i) != null) {
                lsList.get(i).setSeriesIdentifier((Object)" ");
                lsList.get(i).getLineAttributes().setColor(color);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        this.cycleNumbers.add(0.0);
    }

    protected void clearData() {
        this.dataSeriesMap.clear();
        this.cycleNumbers.clear();
    }

    void toggleAxisScale() {
        if (this.useLinearTimeScale) {
            this.logTimeAction.setChecked(true);
            this.linearTimeAction.setChecked(false);
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
        } else {
            this.logTimeAction.setChecked(false);
            this.linearTimeAction.setChecked(true);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
        }
        this.useLinearTimeScale = !this.useLinearTimeScale;
        this.draw();
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    protected class DataSeries {
        public String propertyName = "";
        public List<Double> relativeValues = new ArrayList<Double>();
        public LineSeries lineSeries = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private int seriesIndex = 0;
        private boolean overlayMode = false;

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean state) {
            this.visible = state;
        }

        public void toggleVisible() {
            this.visible = !this.visible;
        }

        public DataSeries(String propertyName, int index, boolean overlay) {
            this.propertyName = propertyName;
            this.seriesIndex = index;
            this.overlayMode = overlay;
            this.relativeValues = new ArrayList<Double>();
            this.relativeValues.add(0.0);
            this.addLineSeries(propertyName);
        }

        public void addValue(Double val) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            this.relativeValues.add(val);
        }

        public void addLineSeries(String propertyName) {
            NumberDataSet orthoValues = NumberDataSetImpl.create(this.relativeValues);
            if (this.lineSeries == null) {
                this.lineSeries = (ScatterSeries)ScatterSeriesImpl.create();
            }
            this.lineSeries.setDataSet((DataSet)orthoValues);
            this.lineSeries.getLineAttributes().setVisible(true);
            this.lineSeries.getLineAttributes().setThickness(3);
            this.lineSeries.getMarkers().clear();
            this.setColorDefs(this.seriesIndex);
            this.sdY = SeriesDefinitionImpl.create();
            this.sdY.getSeriesPalette().update(-2);
            this.sdY.getSeries().add((Object)this.lineSeries);
            RunHistoryCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
        }

        public void hide() {
            this.lineSeries.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.lineSeries.setVisible(true);
            this.visible = true;
        }

        public void setColorDefs(int index) {
            this.lineSeries.setPaletteLineColor(false);
            if (index >= colorDefault.length) {
                index = 0;
            }
            ColorDefinition color = colorDefault[index];
            this.lineSeries.setSeriesIdentifier((Object)this.propertyName);
            if (this.overlayMode) {
                this.lineSeries.getLineAttributes().setColor(color);
                this.lineSeries.getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
            } else {
                this.lineSeries.getLineAttributes().setColor(color);
            }
        }

        public void setColorDefs(String propertyName) {
            this.lineSeries.setPaletteLineColor(false);
            int colorIndex = this.seriesIndex % colorDefault.length;
            ColorDefinition defaultColor = colorDefault[colorIndex];
            Map colorMap = VisualizationPreferencePage.getColorMapping();
            boolean colorSet = false;
            if (colorMap != null && colorMap.size() >= 1 && propertyName != null && propertyName.length() >= 1) {
                if (colorMap.containsKey(propertyName)) {
                    STEMColor c = (STEMColor)colorMap.get(propertyName);
                    ColorDefinition color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                    this.lineSeries.getLineAttributes().setColor(color);
                    colorSet = true;
                } else {
                    for (String key : colorMap.keySet()) {
                        if (key.length() < 1 || !propertyName.substring(0, 1).equalsIgnoreCase(key.substring(0, 1))) continue;
                        STEMColor c = (STEMColor)colorMap.get(key);
                        ColorDefinition color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                        this.lineSeries.getLineAttributes().setColor(color);
                        colorSet = true;
                        break;
                    }
                }
            }
            if (!colorSet) {
                this.lineSeries.getLineAttributes().setColor(defaultColor);
            }
            this.lineSeries.setSeriesIdentifier((Object)propertyName);
            if (this.overlayMode) {
                this.lineSeries.getLineAttributes().setColor(ColorDefinitionImpl.GREY());
                this.lineSeries.getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
            }
        }

        public int getDataSize() {
            return this.relativeValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public List<Double> getRelativeValues() {
            return this.relativeValues;
        }

        public void setRelativeValues(List<Double> relativeValues) {
            this.relativeValues = relativeValues;
        }

        public void setLineSeries(LineSeries lineSeries) {
            this.lineSeries = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        String property;

        public DisplayableProperty(String property, boolean visibility) {
            super(property, 2);
            this.property = null;
            this.property = property;
            this.setChecked(visibility);
        }

        public String getText() {
            return this.property;
        }

        public void run() {
            DataSeries series = RunHistoryCanvas.this.dataSeriesMap.get(this.property);
            series.toggleVisible();
            RunHistoryCanvas.this.dataSeriesMap.put(this.property, series);
            this.setChecked(series.isVisible());
            RunHistoryCanvas.this.visibleMap.put(this.property, series.isVisible());
            RunHistoryCanvas.this.draw();
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!RunHistoryCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!RunHistoryCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                RunHistoryCanvas.this.toggleLegend();
            }
            RunHistoryCanvas.this.draw();
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(RunHistoryCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (RunHistoryCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                RunHistoryCanvas.this.toggleLegend();
            }
            RunHistoryCanvas.this.draw();
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(RunHistoryCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (RunHistoryCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                RunHistoryCanvas.this.toggleAxisScale();
            }
            RunHistoryCanvas.this.draw();
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!RunHistoryCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!RunHistoryCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                RunHistoryCanvas.this.toggleAxisScale();
            }
            RunHistoryCanvas.this.draw();
        }
    }
}

