/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;

public abstract class CompareInputChangeNotifier
implements IResourceChangeListener {
    private Map<ICompareInput, CompareInputConnecton> inputs = new HashMap<ICompareInput, CompareInputConnecton>();
    private InputChangeEventHandler eventHandler;
    private static final int COMPARE_INPUT_CHANGE = 1;

    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.eventHandler = new InputChangeEventHandler();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.eventHandler != null) {
            this.eventHandler.shutdown();
        }
    }

    public void connect(ICompareInput input) {
        CompareInputConnecton con = this.inputs.get(input);
        if (con == null) {
            con = new CompareInputConnecton();
            this.inputs.put(input, con);
        }
        con.increment();
    }

    public void disconnect(ICompareInput input) {
        CompareInputConnecton con = this.inputs.get(input);
        if (con != null) {
            con.decrement();
            if (con.isDisconnected()) {
                this.inputs.remove(input);
            }
        }
    }

    protected ICompareInput[] getConnectedInputs() {
        return this.inputs.keySet().toArray(new ICompareInput[this.inputs.size()]);
    }

    protected void inputsChanged(ICompareInput[] inputs) {
        InputChangeEvent event = new InputChangeEvent(inputs);
        this.eventHandler.queueEvent(event);
    }

    protected void dispatchChanges(ICompareInput[] inputs, IProgressMonitor monitor) {
        this.prepareInputs(inputs, monitor);
        Display.getDefault().syncExec(() -> this.fireChanges(inputs));
    }

    protected void prepareInputs(ICompareInput[] inputs, IProgressMonitor monitor) {
        monitor.beginTask(null, inputs.length * 100);
        ICompareInput[] iCompareInputArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            ICompareInput input = iCompareInputArray[n2];
            this.prepareInput(input, Policy.subMonitorFor(monitor, 100));
            ++n2;
        }
        monitor.done();
    }

    protected void prepareInput(ICompareInput input, IProgressMonitor monitor) {
    }

    protected void fireChanges(ICompareInput[] inputs) {
        ICompareInput[] iCompareInputArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            ICompareInput input = iCompareInputArray[n2];
            this.fireChange(input);
            ++n2;
        }
    }

    protected void runInBackground(IWorkspaceRunnable runnable) {
        this.eventHandler.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.RunnableEvent(runnable, false));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ICompareInput[] inputs;
        ArrayList<ICompareInput> changedInputs = new ArrayList<ICompareInput>();
        ICompareInput[] iCompareInputArray = inputs = this.getConnectedInputs();
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            IResource[] resources;
            ICompareInput input = iCompareInputArray[n2];
            IResource[] iResourceArray = resources = this.getResources(input);
            int n3 = resources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResourceDelta delta;
                IResource resource = iResourceArray[n4];
                if (resource != null && (delta = event.getDelta().findMember(resource.getFullPath())) != null && ((delta.getKind() & 3) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x40100) > 0)) {
                    changedInputs.add(input);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (!changedInputs.isEmpty()) {
            this.handleInputChanges(changedInputs.toArray(new ICompareInput[changedInputs.size()]), true);
        }
    }

    protected abstract IResource[] getResources(ICompareInput var1);

    protected void handleInputChanges(ICompareInput[] inputs, boolean force) {
        ICompareInput[] realChanges;
        if (force) {
            realChanges = inputs;
        } else {
            ArrayList<ICompareInput> result = new ArrayList<ICompareInput>();
            ICompareInput[] iCompareInputArray = inputs;
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                ICompareInput input = iCompareInputArray[n2];
                if (this.isChanged(input)) {
                    result.add(input);
                }
                ++n2;
            }
            realChanges = result.toArray(new ICompareInput[result.size()]);
        }
        if (realChanges.length > 0) {
            this.inputsChanged(realChanges);
        }
    }

    protected boolean isChanged(ICompareInput input) {
        if (input instanceof AbstractCompareInput) {
            AbstractCompareInput ci = (AbstractCompareInput)input;
            return ci.needsUpdate();
        }
        return false;
    }

    protected void fireChange(ICompareInput input) {
        if (input instanceof AbstractCompareInput) {
            AbstractCompareInput ci = (AbstractCompareInput)input;
            ci.update();
        }
    }

    protected boolean belongsTo(Object family) {
        return false;
    }

    private class CompareInputConnecton {
        private int connections;

        private CompareInputConnecton() {
        }

        public void increment() {
            ++this.connections;
        }

        public void decrement() {
            if (this.connections > 0) {
                --this.connections;
            }
        }

        public boolean isDisconnected() {
            return this.connections == 0;
        }
    }

    private static class InputChangeEvent
    extends BackgroundEventHandler.Event {
        private final ICompareInput[] inputs;

        public InputChangeEvent(ICompareInput[] inputs) {
            super(1);
            this.inputs = inputs;
        }

        public ICompareInput[] getChangedInputs() {
            return this.inputs;
        }
    }

    private class InputChangeEventHandler
    extends BackgroundEventHandler {
        private final Set<ICompareInput> changedInputs;
        private final List<BackgroundEventHandler.Event> pendingRunnables;

        protected InputChangeEventHandler() {
            super(TeamUIMessages.CompareInputChangeNotifier_0, TeamUIMessages.CompareInputChangeNotifier_1);
            this.changedInputs = new HashSet<ICompareInput>();
            this.pendingRunnables = new ArrayList<BackgroundEventHandler.Event>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
            BackgroundEventHandler.RunnableEvent[] events;
            ICompareInput[] toDispatch;
            List<BackgroundEventHandler.Event> list = this.pendingRunnables;
            synchronized (list) {
                Set<ICompareInput> set = this.changedInputs;
                synchronized (set) {
                    if (this.changedInputs.isEmpty() && this.pendingRunnables.isEmpty()) {
                        return false;
                    }
                    toDispatch = this.changedInputs.toArray(new ICompareInput[this.changedInputs.size()]);
                    events = this.pendingRunnables.toArray(new BackgroundEventHandler.RunnableEvent[this.pendingRunnables.size()]);
                    this.changedInputs.clear();
                    this.pendingRunnables.clear();
                }
            }
            CompareInputChangeNotifier.this.dispatchChanges(toDispatch, monitor);
            BackgroundEventHandler.RunnableEvent[] runnableEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                BackgroundEventHandler.RunnableEvent event = runnableEventArray[n2];
                this.executeRunnableNow((BackgroundEventHandler.Event)event, monitor);
                ++n2;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
            int type = event.getType();
            switch (type) {
                case 1000: {
                    BackgroundEventHandler.RunnableEvent runnableEvent = (BackgroundEventHandler.RunnableEvent)event;
                    if (runnableEvent.isPreemtive()) {
                        this.executeRunnableNow(event, monitor);
                        break;
                    }
                    this.executeRunnableDuringDispatch(event);
                    break;
                }
                case 1: {
                    if (!(event instanceof InputChangeEvent)) break;
                    InputChangeEvent changeEvent = (InputChangeEvent)event;
                    ICompareInput[] inputs = changeEvent.getChangedInputs();
                    Set<ICompareInput> set = this.changedInputs;
                    synchronized (set) {
                        Collections.addAll(this.changedInputs, inputs);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeRunnableDuringDispatch(BackgroundEventHandler.Event event) {
            List<BackgroundEventHandler.Event> list = this.pendingRunnables;
            synchronized (list) {
                this.pendingRunnables.add(event);
            }
        }

        private void executeRunnableNow(BackgroundEventHandler.Event event, IProgressMonitor monitor) {
            try {
                this.dispatchEvents(Policy.subMonitorFor(monitor, 1));
            }
            catch (TeamException e) {
                this.handleException((CoreException)((Object)e));
            }
            try {
                ((BackgroundEventHandler.RunnableEvent)event).run(Policy.subMonitorFor(monitor, 1));
            }
            catch (CoreException e) {
                this.handleException(e);
            }
        }

        protected synchronized void queueEvent(BackgroundEventHandler.Event event) {
            super.queueEvent(event, false);
        }

        protected long getShortDispatchDelay() {
            return 250L;
        }

        protected boolean belongsTo(Object family) {
            return CompareInputChangeNotifier.this.belongsTo(family);
        }
    }
}

