/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.IStatsInfo;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.category.CategoryLabelProvider;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Version;

public class DownloadStatsSection
extends TableSection {
    private FormEntry fURLEntry;
    private TableViewer fArtifactTable;
    private ISiteModel fModel;

    public DownloadStatsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, DownloadStatsSection.getButtonLabels());
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.StatsSection_addFeature, PDEUIMessages.StatsSection_addBundle, PDEUIMessages.StatsSection_remove, PDEUIMessages.StatsSection_removeAll};
        return labels;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        client.setLayoutData((Object)new GridData(1808));
        Composite urlContainer = toolkit.createComposite(client);
        urlContainer.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        urlContainer.setLayoutData((Object)new GridData(768));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fURLEntry = new FormEntry(urlContainer, toolkit, PDEUIMessages.StatsSection_url, 0);
        this.fURLEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    DownloadStatsSection.this.ensureStatsInfo().setURL(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
        boolean editable = this.isEditable();
        this.fURLEntry.setEditable(editable);
        Composite container = this.createClientContainer(client, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        EditableTablePart tablePart = this.getTablePart();
        this.fArtifactTable = tablePart.getTableViewer();
        this.fArtifactTable.setContentProvider((IContentProvider)new ArtifactsContentProvider());
        this.fArtifactTable.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider());
        this.fArtifactTable.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof SiteFeatureAdapter) {
                    return 0;
                }
                return 1;
            }
        });
        data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        this.resetArtifactTable();
        tablePart.setButtonEnabled(0, editable);
        tablePart.setButtonEnabled(1, editable);
        tablePart.setButtonEnabled(2, editable);
        tablePart.setButtonEnabled(3, editable);
        toolkit.paintBordersFor(container);
        section.setClient((Control)client);
        section.setText(PDEUIMessages.StatsSection_title);
        section.setDescription(PDEUIMessages.StatsSection_description);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNewFeature();
                break;
            }
            case 1: {
                this.handleNewBundle();
                break;
            }
            case 2: {
                this.handleRemove();
                break;
            }
            case 3: {
                this.handleRemoveAll();
            }
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fArtifactTable.getStructuredSelection();
        for (Object object : ssel) {
            if (object == null) continue;
            if (object instanceof SiteFeatureAdapter) {
                this.handleRemoveSiteFeatureAdapter((SiteFeatureAdapter)object);
                continue;
            }
            if (!(object instanceof SiteBundleAdapter)) continue;
            this.handleRemoveSiteBundleAdapter((SiteBundleAdapter)object);
        }
    }

    private boolean handleRemoveSiteFeatureAdapter(SiteFeatureAdapter adapter) {
        try {
            ISiteFeature feature = adapter.feature;
            this.ensureStatsInfo().removeFeatureArtifacts(new ISiteFeature[]{feature});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteBundleAdapter(SiteBundleAdapter adapter) {
        try {
            ISiteBundle bundle = adapter.bundle;
            this.ensureStatsInfo().removeBundleArtifacts(new ISiteBundle[]{bundle});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void handleRemoveAll() {
        try {
            IStatsInfo statsInfo = this.ensureStatsInfo();
            statsInfo.removeBundleArtifacts(statsInfo.getBundleArtifacts());
            statsInfo.removeFeatureArtifacts(statsInfo.getFeatureArtifacts());
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        this.fArtifactTable.refresh(false);
        this.updateButtons();
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection ssel) {
        super.handleDoubleClick(ssel);
        Object selected = ssel.getFirstElement();
        if (selected instanceof SiteFeatureAdapter) {
            IFeature feature = this.findFeature(((SiteFeatureAdapter)selected).feature);
            FeatureEditor.openFeatureEditor(feature);
        } else if (selected instanceof SiteBundleAdapter) {
            ManifestEditor.openPluginEditor(((SiteBundleAdapter)selected).bundle.getId());
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        return super.doGlobalAction(actionId);
    }

    private IFeature findFeature(ISiteFeature siteFeature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
        if (model != null) {
            return model.getFeature();
        }
        return null;
    }

    private void handleNewFeature() {
        Control control = this.fArtifactTable.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
            IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
            ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
            IFeatureModel[] iFeatureModelArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel allModel = iFeatureModelArray[n2];
                if (this.canAdd(allModel)) {
                    newModels.add(allModel);
                }
                ++n2;
            }
            IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
            FeatureSelectionDialog dialog = new FeatureSelectionDialog(this.fArtifactTable.getTable().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAddFeatures(models);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
    }

    private void handleNewBundle() {
        Control control = this.fArtifactTable.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
            IPluginModelBase[] allModels = PluginRegistry.getAllModels();
            ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
            IPluginModelBase[] iPluginModelBaseArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase allModel = iPluginModelBaseArray[n2];
                if (this.canAdd(allModel)) {
                    newModels.add(allModel);
                }
                ++n2;
            }
            IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
            PluginSelectionDialog dialog = new PluginSelectionDialog(this.fArtifactTable.getTable().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAddBundles(models);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
    }

    private boolean canAdd(IFeatureModel candidate) {
        ISiteFeature[] features = this.fModel.getSite().getStatsInfo().getFeatureArtifacts();
        IFeature cfeature = candidate.getFeature();
        ISiteFeature[] iSiteFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature bfeature = iSiteFeatureArray[n2];
            if (bfeature.getId().equals(cfeature.getId()) && bfeature.getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canAdd(IPluginModelBase candidate) {
        ISiteBundle[] currentBundles = this.fModel.getSite().getStatsInfo().getBundleArtifacts();
        IPluginBase candidateBundle = candidate.getPluginBase();
        ISiteBundle[] iSiteBundleArray = currentBundles;
        int n = currentBundles.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteBundle currentBundle = iSiteBundleArray[n2];
            if (currentBundle.getId().equals(candidateBundle.getId()) && currentBundle.getVersion().equals(candidateBundle.getVersion())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private ISiteFeature createSiteFeature(ISiteModel model, IFeatureModel featureModel) throws CoreException {
        IFeature feature = featureModel.getFeature();
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(feature.getId());
        sfeature.setVersion(feature.getVersion());
        sfeature.setURL("features/" + feature.getId() + "_" + this.formatVersion(feature.getVersion()) + ".jar");
        sfeature.setOS(feature.getOS());
        sfeature.setWS(feature.getWS());
        sfeature.setArch(feature.getArch());
        sfeature.setNL(feature.getNL());
        sfeature.setIsPatch(this.isFeaturePatch(feature));
        return sfeature;
    }

    private ISiteBundle createSiteBundle(ISiteModel model, IPluginModelBase candidate) throws CoreException {
        ISiteBundle newBundle = model.getFactory().createBundle();
        newBundle.setId(candidate.getPluginBase().getId());
        newBundle.setVersion(candidate.getPluginBase().getVersion());
        return newBundle;
    }

    private String formatVersion(String version) {
        try {
            Version v = new Version(version);
            return v.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return version;
        }
    }

    private boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports;
        IFeatureImport[] iFeatureImportArray = imports = feature.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport import1 = iFeatureImportArray[n2];
            if (import1.isPatch()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void doAddFeatures(Object[] candidates) throws CoreException {
        ISiteFeature[] added = new ISiteFeature[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            ISiteFeature child;
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            added[i] = child = this.createSiteFeature(this.fModel, candidate);
            ++i;
        }
        this.ensureStatsInfo().addFeatureArtifacts(added);
        if (added.length > 0) {
            this.fArtifactTable.setSelection((ISelection)new StructuredSelection((Object)new SiteFeatureAdapter(null, added[added.length - 1])), true);
        }
    }

    public void doAddBundles(Object[] candidates) throws CoreException {
        ISiteBundle[] added = new ISiteBundle[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            ISiteBundle child;
            IPluginModelBase candidate = (IPluginModelBase)candidates[i];
            added[i] = child = this.createSiteBundle(this.fModel, candidate);
            ++i;
        }
        this.ensureStatsInfo().addBundleArtifacts(added);
        if (added.length > 0) {
            this.fArtifactTable.setSelection((ISelection)new StructuredSelection((Object)new SiteBundleAdapter(null, added[added.length - 1])), true);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    public void refresh() {
        IStatsInfo info = this.getSite().getStatsInfo();
        if (info != null) {
            this.fURLEntry.setValue(info.getURL(), true);
        } else {
            this.fURLEntry.setValue(null, true);
        }
        this.fArtifactTable.refresh();
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fURLEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fURLEntry.cancelEdit();
        super.cancelEdit();
    }

    private IStatsInfo ensureStatsInfo() {
        IStatsInfo info = this.getSite().getStatsInfo();
        if (info == null) {
            info = this.getModel().getFactory().createStatsInfo();
            try {
                this.getSite().setStatsInfo(info);
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
        return info;
    }

    public ISiteModel getModel() {
        return this.fModel;
    }

    public ISite getSite() {
        return this.fModel.getSite();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.resetArtifactTable();
        this.refresh();
        this.updateButtons();
    }

    private void resetArtifactTable() {
        IStatsInfo statsInfo = this.getSite().getStatsInfo();
        if (statsInfo != null) {
            this.fArtifactTable.setInput((Object)statsInfo);
        }
    }

    public void dispose() {
        ISiteModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void updateButtons() {
        EditableTablePart tablePart = this.getTablePart();
        IStructuredSelection selection = this.getViewerSelection();
        boolean editable = this.isEditable();
        tablePart.setButtonEnabled(2, editable && !selection.isEmpty() && selection instanceof IStructuredSelection);
        boolean hasInfo = this.getSite().getStatsInfo() != null;
        tablePart.setButtonEnabled(3, editable && hasInfo && (this.ensureStatsInfo().getFeatureArtifacts().length > 0 || this.ensureStatsInfo().getBundleArtifacts().length > 0));
    }

    class ArtifactsContentProvider
    implements IStructuredContentProvider {
        ArtifactsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISiteBundle[] bundles;
            ISiteFeature[] features;
            ArrayList<Serializable> result = new ArrayList<Serializable>();
            IStatsInfo info = (IStatsInfo)inputElement;
            ISiteFeature[] iSiteFeatureArray = features = info.getFeatureArtifacts();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteFeature feature = iSiteFeatureArray[n2];
                result.add(new SiteFeatureAdapter(null, feature));
                ++n2;
            }
            ISiteBundle[] iSiteBundleArray = bundles = info.getBundleArtifacts();
            int n3 = bundles.length;
            n = 0;
            while (n < n3) {
                ISiteBundle bundle = iSiteBundleArray[n];
                result.add(new SiteBundleAdapter(null, bundle));
                ++n;
            }
            return result.toArray();
        }
    }
}

