/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.internal.core.refactoring.Lock;
import org.eclipse.ltk.internal.core.refactoring.TextChanges;
import org.eclipse.ltk.internal.core.refactoring.UndoDocumentChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class DocumentChange
extends TextChange {
    private IDocument fDocument;
    private int fLength;

    public DocumentChange(String name, IDocument document) {
        super(name);
        Assert.isNotNull((Object)document);
        this.fDocument = document;
    }

    @Override
    public Object getModifiedElement() {
        return this.fDocument;
    }

    @Override
    public void initializeValidationData(IProgressMonitor pm) {
        this.fLength = this.fDocument.getLength();
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        RefactoringStatus result = TextChanges.isValid(this.fDocument, this.fLength);
        pm.worked(1);
        return result;
    }

    @Override
    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        return this.fDocument;
    }

    @Override
    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    @Override
    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UndoEdit performEdits(IDocument document) throws BadLocationException, MalformedTreeException {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fileBuffer = fileBufferManager.getTextFileBuffer(document);
        if (fileBuffer == null || !fileBuffer.isSynchronizationContextRequested()) {
            return super.performEdits(document);
        }
        Lock completionLock = new Lock();
        UndoEdit[] result = new UndoEdit[1];
        BadLocationException[] exception = new BadLocationException[1];
        Runnable runnable = () -> {
            Lock lock2 = completionLock;
            synchronized (lock2) {
                block8: {
                    try {
                        try {
                            undoEditArray[0] = DocumentChange.super.performEdits(document);
                        }
                        catch (BadLocationException e) {
                            badLocationExceptionArray[0] = e;
                            lock.fDone = true;
                            completionLock.notifyAll();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        lock.fDone = true;
                        completionLock.notifyAll();
                        throw throwable;
                    }
                    lock.fDone = true;
                    completionLock.notifyAll();
                }
            }
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    @Override
    protected Change createUndoChange(UndoEdit edit) {
        return new UndoDocumentChange(this.getName(), this.fDocument, edit);
    }
}

