/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProductIntroWizardPage
extends WizardPage
implements IHyperlinkListener {
    private Text fPluginText;
    private Text fIntroIdText;
    private TreeSet<String> fIntroIds;
    private IProduct fProduct;
    private ModifyListener fListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ProductIntroWizardPage.this.validatePage();
        }
    };

    public ProductIntroWizardPage(String pageName, IProduct product) {
        super(pageName);
        this.setTitle(PDEUIMessages.ProductIntroWizardPage_title);
        this.setDescription(PDEUIMessages.ProductIntroWizardPage_description);
        this.fIntroIds = this.getCurrentIntroIds();
        this.fProduct = product;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        comp.setLayout((Layout)layout);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.createProductGroup(toolkit, comp);
        toolkit.dispose();
        this.setControl((Control)comp);
        this.setPageComplete(this.getPluginId() != null);
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.product_definitions_wizard_page");
    }

    private void createProductGroup(FormToolkit toolkit, Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(PDEUIMessages.ProductIntroWizardPage_groupText);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        FormText text = toolkit.createFormText((Composite)group, false);
        text.setText(PDEUIMessages.ProductIntroWizardPage_formText, true, false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 400;
        text.setLayoutData((Object)gd);
        text.setBackground(null);
        text.addHyperlinkListener((IHyperlinkListener)this);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductIntroWizardPage_targetLabel);
        this.fPluginText = new Text((Composite)group, 2052);
        this.fPluginText.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)group, 8);
        button.setText(PDEUIMessages.ProductIntroWizardPage_browse);
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductIntroWizardPage.this.handleBrowse();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.ProductIntroWizardPage_introLabel);
        this.fIntroIdText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fIntroIdText.setLayoutData((Object)gd);
        String pluginId = this.getPluginId();
        if (pluginId != null) {
            this.fPluginText.setText(pluginId);
            this.fIntroIdText.setText(this.getAvailableIntroId(pluginId));
        }
        this.fPluginText.addModifyListener(this.fListener);
        this.fIntroIdText.addModifyListener(this.fListener);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fPluginText.setVisible(visible);
            this.fPluginText.setFocus();
        }
    }

    private void validatePage() {
        String error = null;
        String pluginId = this.getDefiningPlugin();
        IPluginModelBase model = PluginRegistry.findModel((String)pluginId);
        if (model == null) {
            error = PDEUIMessages.ProductDefinitonWizardPage_noPlugin;
        } else if (model.getUnderlyingResource() == null) {
            error = PDEUIMessages.ProductDefinitonWizardPage_notInWorkspace;
        } else if (pluginId.length() == 0) {
            error = PDEUIMessages.ProductIntroWizardPage_targetNotSet;
        }
        this.validateId(error);
    }

    private void validateId(String error) {
        if (error == null) {
            String id = this.fIntroIdText.getText().trim();
            if (id.length() == 0) {
                error = PDEUIMessages.ProductIntroWizardPage_introNotSet;
            }
            if (error == null) {
                int i = 0;
                while (i < id.length()) {
                    if (!id.substring(i, i + 1).matches("[a-zA-Z0-9.]")) {
                        error = PDEUIMessages.ProductIntroWizardPage_invalidIntroId;
                    }
                    ++i;
                }
            }
            if (error == null && this.fIntroIds.contains(id)) {
                error = PDEUIMessages.ProductIntroWizardPage_introIdExists;
            }
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private void handleBrowse() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getShell(), PluginRegistry.getWorkspaceModels(), false);
        if (dialog.open() == 0) {
            IPluginModelBase model = (IPluginModelBase)dialog.getFirstResult();
            String id = model.getPluginBase().getId();
            this.fPluginText.setText(id);
            this.fIntroIdText.setText(this.getAvailableIntroId(id));
        }
    }

    private String getAvailableIntroId(String id) {
        String introId = "intro";
        String numString = "";
        int idNum = 1;
        while (this.fIntroIds.contains(String.valueOf(id) + "." + introId + numString)) {
            numString = Integer.toString(idNum++);
        }
        return String.valueOf(id) + "." + introId + numString;
    }

    private TreeSet<String> getCurrentIntroIds() {
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.ui.intro", true);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] children = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < children.length) {
                String introId;
                if ("intro".equals(children[j].getName()) && (introId = children[j].getAttribute("id")) != null) {
                    result.add(introId);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public String getDefiningPlugin() {
        return this.fPluginText.getText().trim();
    }

    public String getIntroId() {
        return this.fIntroIdText.getText().trim();
    }

    private String getPluginId() {
        IProject project = this.fProduct.getModel().getUnderlyingResource().getProject();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        return model == null ? null : model.getPluginBase().getId();
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void linkActivated(HyperlinkEvent e) {
        String extPoint = "org.eclipse.ui." + e.getHref().toString();
        IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(extPoint);
        if (point != null) {
            new ShowDescriptionAction(point, true).run();
        }
    }
}

