/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.xtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.codegen.STEMGenFeature;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Transition;

public class ExpressionMethodDefinition {
    private final Transition transition;
    private final String methodBody;
    private STEMGenFeature sourceFeature;
    private STEMGenFeature targetFeature;
    private List<STEMGenFeature> incidenceFeatures;

    public ExpressionMethodDefinition(Transition transition, String methodBody) {
        this.transition = transition;
        this.methodBody = methodBody;
    }

    public String getTransitionName() {
        return GeneratorUtils.getTransitionPrettyName(this.transition);
    }

    public Transition getTransition() {
        return this.transition;
    }

    public String getMethodBody() {
        return this.methodBody;
    }

    public String getMethodName() {
        return String.valueOf(this.transition.getSource().getName()) + "_" + this.transition.getTarget().getName();
    }

    public void setSourceFeature(STEMGenFeature feature) {
        this.sourceFeature = feature;
    }

    public void setTargetFeature(STEMGenFeature feature) {
        this.targetFeature = feature;
    }

    public void setForIncidenceFeatures(List<STEMGenFeature> features) {
        this.incidenceFeatures = features;
    }

    public STEMGenFeature getSourceFeature() {
        return this.sourceFeature;
    }

    public STEMGenFeature getTargetFeature() {
        return this.targetFeature;
    }

    public List<STEMGenFeature> getForIncidenceFeatures() {
        return this.incidenceFeatures;
    }

    public String getSourceAccessorName() {
        return GeneratorUtils.formatToUpperCaseWordsNoSpaces(this.transition.getSource().getName());
    }

    public String getTargetAccessorName() {
        return GeneratorUtils.formatToUpperCaseWordsNoSpaces(this.transition.getTarget().getName());
    }

    public List<String> getIncidenceCompartments() {
        ArrayList<String> incidences = new ArrayList<String>();
        if (this.transition.getForIncidence() != null) {
            for (Compartment incidence : this.transition.getForIncidence()) {
                incidences.add(GeneratorUtils.formatToUpperCaseWordsNoSpaces(incidence.getName()));
            }
        }
        return incidences;
    }
}

