/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.experiment.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.experiment.ExperimentPackage;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;

public class ExperimentImpl
extends IdentifiableImpl
implements Experiment {
    protected EList<Modifier> modifiers;
    protected static final boolean COMPLETE_EDEFAULT = false;
    protected Scenario scenario;

    protected ExperimentImpl() {
        this.setURI(STEMURI.createURI("experiment/" + STEMURI.generateUniquePart()));
        this.setTypeURI(STEMURI.EXPERIMENT_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ExperimentPackage.Literals.EXPERIMENT;
    }

    @Override
    public EList<Modifier> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new EObjectResolvingEList(Modifier.class, (InternalEObject)this, 3);
        }
        return this.modifiers;
    }

    @Override
    public List<String> getModificationSummary() {
        ArrayList<String> retValue = new ArrayList<String>();
        for (Modifier modifier : this.getModifiers()) {
            retValue.addAll(modifier.getModificationSummary());
        }
        return retValue;
    }

    @Override
    public boolean isComplete() {
        boolean retValue = true;
        for (Modifier modifier : this.getModifiers()) {
            if (modifier.isComplete()) continue;
            retValue = false;
            break;
        }
        return retValue;
    }

    @Override
    public Scenario getScenario() {
        if (this.scenario != null && this.scenario.eIsProxy()) {
            InternalEObject oldScenario = (InternalEObject)this.scenario;
            this.scenario = (Scenario)this.eResolveProxy(oldScenario);
            if (this.scenario != oldScenario && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldScenario, (Object)this.scenario));
            }
        }
        return this.scenario;
    }

    public Scenario basicGetScenario() {
        return this.scenario;
    }

    @Override
    public void setScenario(Scenario newScenario) {
        Scenario oldScenario = this.scenario;
        this.scenario = newScenario;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldScenario, (Object)this.scenario));
        }
    }

    @Override
    public List<String> getParameterSummary() {
        return this.getModificationSummary();
    }

    @Override
    public Scenario updateScenario() {
        Modifier modifier = (Modifier)this.getModifiers().get(0);
        if (!modifier.isComplete()) {
            modifier.updateScenario(this.getScenario());
        } else {
            for (Modifier m : this.getModifiers()) {
                if (m.isComplete()) {
                    try {
                        m.resetLabels();
                    }
                    catch (ScenarioInitializationException e) {
                        CorePlugin.logError(e.getMessage(), e);
                    }
                    m.updateScenario(this.getScenario());
                    continue;
                }
                m.updateScenario(this.getScenario());
                break;
            }
        }
        Scenario s = this.getScenario();
        try {
            s.initialize();
        }
        catch (ScenarioInitializationException se) {
            Utility.handleException(se.getErrorMessage(), true, se);
        }
        s.setProgress(0.0);
        return s;
    }

    @Override
    public Scenario initScenario() {
        int i = 1;
        while (i < this.getModifiers().size()) {
            ((Modifier)this.getModifiers().get(i)).updateScenario(this.getScenario());
            ++i;
        }
        return this.getScenario();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        assert (retValue);
        boolean bl = retValue = this.getScenario() == null || this.getScenario().sane();
        assert (retValue);
        for (Modifier modifier : this.getModifiers()) {
            retValue = modifier.sane();
            assert (retValue);
        }
        return retValue;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getModifiers();
            }
            case 4: {
                return this.isComplete();
            }
            case 5: {
                if (resolve) {
                    return this.getScenario();
                }
                return this.basicGetScenario();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getModifiers().clear();
                this.getModifiers().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setScenario((Scenario)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getModifiers().clear();
                return;
            }
            case 5: {
                this.setScenario(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.modifiers != null && !this.modifiers.isEmpty();
            }
            case 4: {
                return this.isComplete();
            }
            case 5: {
                return this.scenario != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

