/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.imports;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.scoping.XtendImportedNamespaceScopeProvider;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.DefaultImportsConfiguration;
import org.eclipse.xtext.xbase.imports.IMutableImportsConfiguration;
import org.eclipse.xtext.xtype.XImportSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendImportsConfiguration
extends DefaultImportsConfiguration
implements IMutableImportsConfiguration {
    @Inject
    private IXtendJvmAssociations associations;

    public XImportSection getImportSection(XtextResource resource) {
        XtendFile xtendFile = this.getXtendFile(resource);
        if (xtendFile != null) {
            return xtendFile.getImportSection();
        }
        return null;
    }

    public void setImportSection(XtextResource resource, XImportSection importSection) {
        XtendFile xtendFile = this.getXtendFile(resource);
        if (xtendFile != null) {
            xtendFile.setImportSection(importSection);
        }
    }

    protected String getCommonPackageName(XtextResource resource) {
        XtendFile xtendFile = this.getXtendFile(resource);
        return xtendFile == null ? null : xtendFile.getPackage();
    }

    public Iterable<JvmDeclaredType> getLocallyDefinedTypes(XtextResource resource) {
        XtendFile xtendFile = this.getXtendFile(resource);
        if (xtendFile == null) {
            return Collections.emptyList();
        }
        final ArrayList locallyDefinedTypes = Lists.newArrayList();
        for (XtendTypeDeclaration xtendType : xtendFile.getXtendTypes()) {
            for (EObject inferredElement : this.associations.getJvmElements(xtendType)) {
                if (!(inferredElement instanceof JvmDeclaredType)) continue;
                JvmDeclaredType declaredType = (JvmDeclaredType)inferredElement;
                locallyDefinedTypes.add(declaredType);
                this.addInnerTypes(declaredType, (IAcceptor)new IAcceptor<JvmDeclaredType>(){

                    public void accept(JvmDeclaredType t) {
                        locallyDefinedTypes.add(t);
                    }
                });
            }
        }
        return locallyDefinedTypes;
    }

    protected XtendFile getXtendFile(XtextResource resource) {
        if (resource == null || resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof XtendFile)) {
            return null;
        }
        return (XtendFile)resource.getContents().get(0);
    }

    public Set<String> getImplicitlyImportedPackages(XtextResource resource) {
        String commonPackageName;
        Set implicitlyImportedPackages = super.getImplicitlyImportedPackages(resource);
        implicitlyImportedPackages.add(XtendImportedNamespaceScopeProvider.XBASE_LIB.toString("."));
        XtendFile xtendFile = this.getXtendFile(resource);
        String string = commonPackageName = xtendFile == null ? null : xtendFile.getPackage();
        if (!Strings.isEmpty((String)commonPackageName)) {
            implicitlyImportedPackages.add(commonPackageName);
        }
        return implicitlyImportedPackages;
    }

    public int getImportSectionOffset(XtextResource resource) {
        List nodes;
        XtendFile xtendFile = this.getXtendFile(resource);
        if (xtendFile != null && !Strings.isEmpty((String)xtendFile.getPackage()) && !(nodes = NodeModelUtils.findNodesForFeature((EObject)xtendFile, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE)).isEmpty()) {
            INode lastNode = (INode)nodes.get(nodes.size() - 1);
            INode nextSibling = lastNode.getNextSibling();
            while (nextSibling instanceof ILeafNode && ((ILeafNode)nextSibling).isHidden()) {
                nextSibling = nextSibling.getNextSibling();
            }
            if (nextSibling != null && ";".equals(nextSibling.getText())) {
                return nextSibling.getOffset() + 1;
            }
            return lastNode.getTotalEndOffset();
        }
        return 0;
    }

    public JvmDeclaredType getContextJvmDeclaredType(EObject model) {
        XtendTypeDeclaration xtendType = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)model, XtendTypeDeclaration.class);
        if (xtendType != null && xtendType.eContainingFeature() == XtendPackage.Literals.XTEND_MEMBER__ANNOTATION_INFO) {
            xtendType = (XtendTypeDeclaration)xtendType.eContainer();
        }
        return this.associations.getInferredType(xtendType);
    }

    public String getPackageName(XtextResource xtextResource) {
        XtendFile xtendFile = this.getXtendFile(xtextResource);
        if (xtendFile == null) {
            return null;
        }
        return xtendFile.getPackage();
    }
}

