/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class JavaDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private List<?> fElements;
    private JavaMoveProcessor fMoveProcessor;
    private int fCanMoveElements;
    private JavaCopyProcessor fCopyProcessor;
    private int fCanCopyElements;

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        int currentOperation = dropAdapter.getCurrentOperation();
        if (LocalSelectionTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            try {
                target = this.getActualTarget(target);
                switch (currentOperation) {
                    case 2: {
                        this.handleDropMove(target);
                        dropTargetEvent.detail = 0;
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target);
                    }
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
            }
            catch (InterruptedException interruptedException) {}
            this.clear();
            return Status.OK_STATUS;
        }
        if (FileTransfer.getInstance().isSupportedType(dropAdapter.getCurrentTransfer())) {
            try {
                IContainer targetContainer = this.getTargetContainer(target);
                if (targetContainer == null) {
                    return Status.CANCEL_STATUS;
                }
                this.getShell().forceActive();
                Object data = FileTransfer.getInstance().nativeToJava(dropAdapter.getCurrentTransfer());
                new CopyFilesAndFoldersOperation(this.getShell()).copyOrLinkFiles((String[])data, targetContainer, currentOperation);
            }
            catch (JavaModelException e) {
                String title = PackagesMessages.DropAdapter_errorTitle;
                String message = PackagesMessages.DropAdapter_errorMessage;
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IStatus result = Status.OK_STATUS;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            target = this.getActualTarget(target);
            this.initializeSelection();
            try {
                switch (operation) {
                    case 16: {
                        if (this.handleValidateDefault(target) != 0) {
                            result = Status.OK_STATUS;
                            break;
                        }
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    case 1: {
                        if (this.handleValidateCopy(target) != 0) {
                            result = Status.OK_STATUS;
                            break;
                        }
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    case 2: {
                        if (this.handleValidateMove(target) != 0) {
                            result = Status.OK_STATUS;
                            break;
                        }
                        if (this.handleValidateCopy(target) != 0) {
                            this.getCommonDropAdapter().overrideOperation(1);
                            result = Status.OK_STATUS;
                            break;
                        }
                        result = Status.CANCEL_STATUS;
                    }
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.SelectionTransferDropAdapter_error_title, PackagesMessages.SelectionTransferDropAdapter_error_message);
                result = Status.CANCEL_STATUS;
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            try {
                Object data = FileTransfer.getInstance().nativeToJava(transferType);
                if (!(data instanceof String[])) {
                    return Status.CANCEL_STATUS;
                }
                IContainer targetContainer = this.getTargetContainer(target);
                if (targetContainer == null || !targetContainer.isAccessible()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (JavaModelException e) {
                String title = PackagesMessages.DropAdapter_errorTitle;
                String message = PackagesMessages.DropAdapter_errorMessage;
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
                result = Status.CANCEL_STATUS;
            }
        }
        return result;
    }

    public boolean isSupportedType(TransferData transferType) {
        return super.isSupportedType(transferType) || FileTransfer.getInstance().isSupportedType(transferType);
    }

    private Object getActualTarget(Object target) {
        IJavaProject jp;
        if (target instanceof IProject && (jp = JavaCore.create((IProject)((IProject)target))).exists()) {
            return jp;
        }
        return target;
    }

    private IContainer getTargetContainer(Object dropTarget) throws JavaModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IJavaElement) {
            return this.getTargetContainer(((IJavaElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            this.fElements = Collections.EMPTY_LIST;
            return;
        }
        this.fElements = ((IStructuredSelection)s).toList();
    }

    private void handleDropMove(Object target) throws JavaModelException, InvocationTargetException, InterruptedException {
        IResource[] resources;
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        ReorgMoveStarter starter = ReorgMoveStarter.create(javaElements, resources = ReorgUtils.getResources(this.fElements), ReorgDestinationFactory.createDestination(target));
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private void handleDropCopy(Object target) throws JavaModelException, InvocationTargetException, InterruptedException {
        IResource[] resources;
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(this.fElements);
        ReorgCopyStarter starter = ReorgCopyStarter.create(javaElements, resources = ReorgUtils.getResources(this.fElements), ReorgDestinationFactory.createDestination(target));
        if (starter != null) {
            starter.run(this.getShell());
        }
    }

    private int handleValidateCopy(Object target) throws JavaModelException {
        IReorgPolicy.ICopyPolicy policy = ReorgPolicyFactory.createCopyPolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
        JavaCopyProcessor javaCopyProcessor = this.fCopyProcessor = policy.canEnable() ? new JavaCopyProcessor(policy) : null;
        if (!this.canCopyElements()) {
            return 0;
        }
        if (this.fCopyProcessor == null) {
            return 0;
        }
        if (!this.fCopyProcessor.setDestination(ReorgDestinationFactory.createDestination(target)).isOK()) {
            return 0;
        }
        return 1;
    }

    private int handleValidateDefault(Object target) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        return this.handleValidateMove(target);
    }

    private int handleValidateMove(Object target) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(ReorgUtils.getResources(this.fElements), ReorgUtils.getJavaElements(this.fElements));
        JavaMoveProcessor javaMoveProcessor = this.fMoveProcessor = policy.canEnable() ? new JavaMoveProcessor(policy) : null;
        if (!this.canMoveElements()) {
            return 0;
        }
        if (this.fMoveProcessor == null) {
            return 0;
        }
        if (!this.fMoveProcessor.setDestination(ReorgDestinationFactory.createDestination(target)).isOK()) {
            return 0;
        }
        return 2;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (this.fMoveProcessor == null) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (this.fCopyProcessor == null) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void clear() {
        this.fElements = null;
        this.fMoveProcessor = null;
        this.fCanMoveElements = 0;
        this.fCopyProcessor = null;
        this.fCanCopyElements = 0;
    }
}

