/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.heapwalking;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceListValue;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.heapwalking.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AllReferencesActionDelegate
extends ObjectActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow fWindow;

    public void run(IAction action) {
        IStructuredSelection currentSelection = this.getCurrentSelection();
        if (currentSelection != null && currentSelection.getFirstElement() instanceof IJavaVariable) {
            IJavaVariable var = (IJavaVariable)currentSelection.getFirstElement();
            try {
                JDIReferenceListValue referenceList = new JDIReferenceListValue((IJavaObject)var.getValue());
                InspectPopupDialog ipd = new InspectPopupDialog(this.getShell(), AllReferencesActionDelegate.getAnchor((IDebugView)this.getPart().getAdapter(IDebugView.class)), "org.eclipse.jdt.debug.ui.commands.Inspect", (IExpression)new JavaInspectExpression(NLS.bind((String)Messages.AllReferencesActionDelegate_1, (Object[])new String[]{var.getName()}), (IJavaValue)referenceList));
                ipd.open();
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.statusDialog(e.getStatus());
            }
        } else {
            JDIDebugUIPlugin.statusDialog((IStatus)new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), Messages.AllReferencesActionDelegate_0));
        }
    }

    protected static Point getAnchor(IDebugView view) {
        Tree tree;
        TreeItem[] selection;
        Control control = view.getViewer().getControl();
        if (control instanceof Tree && (selection = (tree = (Tree)control).getSelection()).length > 0) {
            Rectangle bounds = selection[0].getBounds();
            return tree.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
        }
        return control.toDisplay(0, 0);
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    private Shell getShell() {
        if (this.fWindow != null) {
            return this.fWindow.getShell();
        }
        if (this.getWorkbenchWindow() != null) {
            return this.getWorkbenchWindow().getShell();
        }
        return null;
    }

    protected IWorkbenchPart getPart() {
        IWorkbenchPart part = super.getPart();
        if (part != null) {
            return part;
        }
        if (this.fWindow != null) {
            return this.fWindow.getActivePage().getActivePart();
        }
        return null;
    }
}

