/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient4;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.params.HttpParams;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.filetransfer.events.socketfactory.INonconnectedSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.CloseMonitoringSocket;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketClosedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketConnectedEvent;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketCreatedEvent;

public class ECFHttpClientProtocolSocketFactory
implements SchemeSocketFactory {
    protected ISocketEventSource source;
    private INonconnectedSocketFactory unconnectedFactory;
    private ISocketListener socketConnectListener;
    private static final ISocketListener NULL_SOCKET_EVENT_LISTENER = new ISocketListener(){

        public void handleSocketEvent(ISocketEvent event) {
        }
    };

    public ECFHttpClientProtocolSocketFactory(INonconnectedSocketFactory unconnectedFactory, ISocketEventSource source, ISocketListener socketConnectListener) {
        Assert.isNotNull((Object)unconnectedFactory);
        Assert.isNotNull((Object)source);
        this.unconnectedFactory = unconnectedFactory;
        this.source = source;
        this.socketConnectListener = socketConnectListener != null ? socketConnectListener : NULL_SOCKET_EVENT_LISTENER;
    }

    public ECFHttpClientProtocolSocketFactory(final SocketFactory socketFactory, ISocketEventSource source, ISocketListener socketConnectListener) {
        this(new INonconnectedSocketFactory(){

            public Socket createSocket() throws IOException {
                return socketFactory.createSocket();
            }
        }, source, socketConnectListener);
    }

    public Socket createSocket(HttpParams params) throws IOException {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ECFHttpClientProtocolSocketFactory.class, (String)"createSocket");
        Socket factorySocket = this.unconnectedFactory.createSocket();
        ECFHttpClientProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)new SocketCreatedEvent(this.source, factorySocket));
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/exiting", ECFHttpClientProtocolSocketFactory.class, (String)("socketCreated " + factorySocket));
        return factorySocket;
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Object toReturn;
        int timeout = params.getIntParameter("http.socket.timeout", 0);
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ECFHttpClientProtocolSocketFactory.class, (String)("connectSocket " + remoteAddress.toString() + " timeout=" + timeout));
        try {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("bind(" + String.valueOf(localAddress) + ")"));
            sock.bind(localAddress);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("connect(" + remoteAddress.toString() + ", " + timeout + ")"));
            sock.connect(remoteAddress, timeout);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"connected");
        }
        catch (IOException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ECFHttpClientProtocolSocketFactory.class, (String)"createSocket", (Throwable)e);
            ECFHttpClientProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)new SocketClosedEvent(this.source, sock, sock));
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", ECFHttpClientProtocolSocketFactory.class, (String)"createSocket", (Throwable)e);
            throw e;
        }
        CloseMonitoringSocket wrapped = new CloseMonitoringSocket(sock, this.socketConnectListener, this.source);
        SocketConnectedEvent connectedEvent = new SocketConnectedEvent(this.source, sock, (Socket)((Object)wrapped));
        ECFHttpClientProtocolSocketFactory.fireEvent(this.socketConnectListener, (ISocketEvent)connectedEvent);
        if (connectedEvent.getSocket() != wrapped) {
            toReturn = connectedEvent.getSocket();
            wrapped.setWrappedSocket((Socket)toReturn);
        } else {
            toReturn = wrapped;
        }
        return toReturn;
    }

    private static void fireEvent(ISocketListener spyListener, ISocketEvent event) {
        if (spyListener != null) {
            spyListener.handleSocketEvent(event);
        }
        event.getSource().fireEvent(event);
    }

    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock instanceof SSLSocket) {
            throw new IllegalArgumentException("Socket not created by this factory.");
        }
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof ECFHttpClientProtocolSocketFactory;
    }

    public int hashCode() {
        return ECFHttpClientProtocolSocketFactory.class.hashCode();
    }
}

