/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Random;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.StandardStochasticDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.impl.StochasticDiseaseModelImpl;

public abstract class StandardStochasticDiseaseModelImpl
extends StochasticDiseaseModelImpl
implements StandardStochasticDiseaseModel {
    public static final double GAIN_EDEFAULT = 0.01;
    protected double gain = 0.01;

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_STOCHASTIC_DISEASE_MODEL;
    }

    @Override
    public double getGain() {
        return this.gain;
    }

    @Override
    public void setGain(double newGain) {
        this.gain = newGain;
    }

    @Override
    public double computeNoise() {
        return StandardStochasticDiseaseModelImpl.computeNoise(this.getGain(), this.getRandomGenerator());
    }

    public static double computeNoise(double gain, Random rand) {
        assert (gain <= StochasticDiseaseModelImpl.getMAX_GAIN()) : "STOCHASTIC NOISE must be 'small', therefore gain parameter must be < MAX_GAIN=" + MAX_GAIN;
        double x = 2.0 * rand.nextDouble() - 1.0;
        x *= gain;
        assert ((x += 1.0) > 0.0 && x < 2.0) : "random noise should be a small perturbation Gain factor, g,  must 0.0 < g << 1.0 ";
        return x;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getGain();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setGain((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setGain(0.01);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.gain != 0.01;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (gain: ");
        result.append(this.gain);
        result.append(')');
        return result.toString();
    }
}

