/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ClasspathContainerDefaultPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private StringDialogField fEntryField;
    private ArrayList<IPath> fUsedPaths;

    public ClasspathContainerDefaultPage() {
        super("ClasspathContainerDefaultPage");
        this.setTitle(NewWizardMessages.ClasspathContainerDefaultPage_title);
        this.setDescription(NewWizardMessages.ClasspathContainerDefaultPage_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(NewWizardMessages.ClasspathContainerDefaultPage_path_label);
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ClasspathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo status = new StatusInfo();
        String str = this.fEntryField.getText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_enterpath);
        } else if (!Path.ROOT.isValidPath(str)) {
            status.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_invalidpath);
        } else {
            Path path = new Path(str);
            if (path.segmentCount() == 0) {
                status.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_needssegment);
            } else if (this.fUsedPaths.contains(path)) {
                status.setError(NewWizardMessages.ClasspathContainerDefaultPage_path_error_alreadyexists);
            }
        }
        this.updateStatus(status);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fEntryField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.classpath_container_default_page_context");
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        return JavaCore.newContainerEntry((IPath)new Path(this.fEntryField.getText()));
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            IClasspathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    public void setSelection(IClasspathEntry containerEntry) {
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
            this.fEntryField.setText(containerEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

