/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.stem.adapters.file.IdentifiableFileAdapterFactory;
import org.eclipse.stem.core.graph.provider.GraphTimeProviderAdapterFactory;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.stem.core";
    private static CorePlugin plugin;

    public CorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new GraphTimeProviderAdapterFactory();
        new IdentifiableFileAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public static void logInformation(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public static void logInformation(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, null));
        } else {
            System.out.println(message);
        }
    }
}

