/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExchangeType implements Enumerator
{
    BIRTHS_AND_DEATHS(1, "BIRTHS_AND_DEATHS", "BIRTHS_AND_DEATHS"),
    MIGRATION(2, "MIGRATION", "MIGRATION"),
    AGING(3, "AGING", "AGING");

    public static final int BIRTHS_AND_DEATHS_VALUE = 1;
    public static final int MIGRATION_VALUE = 2;
    public static final int AGING_VALUE = 3;
    private static final ExchangeType[] VALUES_ARRAY;
    public static final List<ExchangeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExchangeType[]{BIRTHS_AND_DEATHS, MIGRATION, AGING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExchangeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExchangeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExchangeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExchangeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExchangeType get(int value) {
        switch (value) {
            case 1: {
                return BIRTHS_AND_DEATHS;
            }
            case 2: {
                return MIGRATION;
            }
            case 3: {
                return AGING;
            }
        }
        return null;
    }

    private ExchangeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

