/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.modifier.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.DecoratorImpl;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.modifier.ModifierPackage;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.trigger.Trigger;

public class ModifierImpl
extends DecoratorImpl
implements Modifier {
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected EList<FeatureModifier> featureModifiers;
    private boolean complete = false;
    protected static final boolean COMPLETE_EDEFAULT = false;

    protected ModifierImpl() {
        this.setURI(STEMURI.createURI("modifier/" + STEMURI.generateUniquePart()));
        this.setTypeURI(STEMURI.MODIFIER_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ModifierPackage.Literals.MODIFIER;
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI newTargetURI) {
        URI oldTargetURI = this.targetURI;
        this.targetURI = newTargetURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldTargetURI, (Object)this.targetURI));
        }
    }

    @Override
    public EList<FeatureModifier> getFeatureModifiers() {
        if (this.featureModifiers == null) {
            this.featureModifiers = new EObjectContainmentEList(FeatureModifier.class, (InternalEObject)this, 9);
        }
        return this.featureModifiers;
    }

    @Override
    public boolean isComplete() {
        if (this.complete) {
            return true;
        }
        boolean retValue = true;
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            retValue = featureModifier.isComplete();
            if (!retValue) break;
        }
        return retValue;
    }

    @Override
    public void resetTarget(EObject target) {
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            Label l;
            if (target instanceof Label && (l = (Label)target).getIdentifiable() instanceof Node) {
                this.resetNodeLabelTarget(featureModifier, (Node)l.getIdentifiable(), l.getClass());
                continue;
            }
            EObject t = target;
            if (t instanceof Label) {
                t = ((Label)t).getCurrentValue();
            }
            featureModifier.setTarget(t);
            featureModifier.reset();
        }
    }

    private void resetNodeLabelTarget(FeatureModifier featureModifier, Node n, Class<?> labelClass) {
        Set<Node> children = ModifierImpl.getChildSet(n);
        if (children.size() == 0) {
            for (Label lab : n.getLabels()) {
                if (lab.getClass() != labelClass) continue;
                featureModifier.setTarget(lab.getCurrentValue());
                featureModifier.reset();
                break;
            }
        } else {
            for (Node child : children) {
                this.resetNodeLabelTarget(featureModifier, child, labelClass);
            }
        }
    }

    @Override
    public void resetLabels() {
        Graph g = this.getGraph();
        if (g != null) {
            EObject target = this.getTarget(g);
            if (target != null) {
                this.resetTarget(target);
            }
        } else {
            for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
                featureModifier.reset();
            }
        }
    }

    @Override
    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
    }

    @Override
    public void updateLabels(STEMTime time, long timerPeriod, int cycle) {
        EObject target = this.getTarget(this.getGraph());
        if (target != null) {
            this.modifyTarget(target);
        }
    }

    @Override
    public void updateScenario(Scenario scenario) {
        EObject t = this.getTarget(scenario);
        if (t == null) {
            CorePlugin.logError("Modifier " + this.getURI() + " cannot find target " + this.getTargetURI() + " in scenario " + scenario.getURI(), new Exception());
        } else {
            this.modifyTarget(t);
        }
    }

    private EObject getTarget(Scenario scenario) {
        Sequencer retValue = null;
        retValue = scenario.getSequencer().getURI().equals((Object)this.getTargetURI()) ? scenario.getSequencer() : this.getTarget(scenario.getModel());
        if (retValue == null) {
            for (Decorator d : scenario.getScenarioDecorators()) {
                if (d.getURI().equals((Object)this.getTargetURI())) {
                    return d;
                }
                if (!(d instanceof Trigger)) continue;
                Trigger tg = (Trigger)d;
                for (Decorator d2 : tg.getActions()) {
                    Modifier m;
                    if (!(d2 instanceof Modifier) || !(m = (Modifier)d2).getURI().equals((Object)this.getTargetURI().trimQuery())) continue;
                    int index = Integer.parseInt(this.getTargetURI().query());
                    return (EObject)m.getFeatureModifiers().get(index);
                }
            }
        }
        return retValue;
    }

    private EObject getTarget(Model model) {
        Decorator retValue = null;
        for (Decorator decorator : model.getNodeDecorators()) {
            if (!decorator.getURI().equals((Object)this.getTargetURI())) continue;
            retValue = decorator;
            break;
        }
        if (retValue == null) {
            for (Model m : model.getModels()) {
                retValue = this.getTarget(m);
                if (retValue != null) break;
            }
        }
        if (retValue == null) {
            for (Graph g : model.getGraphs()) {
                retValue = this.findNodeLabel(g);
                if (retValue != null) break;
            }
        }
        if (retValue == null) {
            for (Graph g : model.getGraphs()) {
                retValue = this.findEdgeLabel(g);
                if (retValue != null) break;
            }
        }
        return retValue;
    }

    private EObject getTarget(Graph graph) {
        EObject retValue = null;
        for (Decorator decorator : graph.getDecorators()) {
            if (decorator.getURI().equals((Object)this.getTargetURI())) {
                retValue = decorator;
                break;
            }
            if (!(decorator instanceof Trigger)) continue;
            Trigger tg = (Trigger)decorator;
            for (Decorator a : tg.getActions()) {
                if (!a.getURI().equals((Object)this.getTargetURI())) continue;
                this.getTargetURI();
            }
        }
        if (retValue == null) {
            retValue = this.findNodeLabel(graph);
        }
        if (retValue == null) {
            retValue = this.findEdgeLabel(graph);
        }
        if (retValue == null) {
            CorePlugin.logError("Unable to find target to modify having URI " + this.getTargetURI(), new Exception());
        }
        return retValue;
    }

    private EObject findNodeLabel(Graph g) {
        for (NodeLabel nodeLabel : g.getNodeLabels().values()) {
            if (!nodeLabel.getURI().equals((Object)this.getTargetURI())) continue;
            return nodeLabel;
        }
        return null;
    }

    private EObject findEdgeLabel(Graph g) {
        for (Edge edge : g.getEdges().values()) {
            if (!edge.getLabel().getURI().equals((Object)this.getTargetURI())) continue;
            return edge.getLabel();
        }
        return null;
    }

    private void modifyTarget(EObject target) {
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            if (target instanceof Label) {
                Label l = (Label)target;
                if (l.getIdentifiable() instanceof Node) {
                    this.modifyNodeLabelTarget(featureModifier, (Node)l.getIdentifiable(), l.getClass());
                    continue;
                }
                target = l.getCurrentValue();
            }
            featureModifier.setTarget(target);
            featureModifier.updateFeature();
        }
    }

    private void modifyNodeLabelTarget(FeatureModifier featureModifier, Node n, Class<?> labelClass) {
        Set<Node> children = ModifierImpl.getChildSet(n);
        if (children.size() == 0) {
            for (Label lab : n.getLabels()) {
                if (lab.getClass() != labelClass) continue;
                LabelValue target = lab.getCurrentValue();
                featureModifier.setTarget(target);
                featureModifier.updateFeature();
                break;
            }
        } else {
            for (Node child : children) {
                this.modifyNodeLabelTarget(featureModifier, child, labelClass);
            }
        }
    }

    public static Set<Node> getChildSet(Node parent) {
        HashSet<Node> children = new HashSet<Node>();
        if (parent == null) {
            return children;
        }
        String parentID = parent.getURI().lastSegment();
        EList<Edge> allEdges = parent.getEdges();
        int i = 0;
        while (i < allEdges.size()) {
            Edge e = (Edge)allEdges.get(i);
            Node neighborNode = e.getOtherNode(parent);
            String neighborID = neighborNode.getURI().lastSegment();
            if (neighborID.length() > parentID.length() || parentID.equals("ZZZ")) {
                children.add(neighborNode);
            }
            ++i;
        }
        children.remove(parent);
        return children;
    }

    public EObject deepFindChildren(EObject eobj, EObject target) {
        if (eobj.equals(target)) {
            return eobj;
        }
        for (EObject eo : eobj.eContents()) {
            this.deepFindChildren(eo, target);
        }
        return null;
    }

    @Override
    public List<String> getModificationSummary() {
        ArrayList<String> retValue = new ArrayList<String>();
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            retValue.add(featureModifier.getModificationSummary());
        }
        return retValue;
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        assert (retValue);
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            boolean bl = retValue = retValue && featureModifier.sane();
            assert (retValue);
        }
        return retValue;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getFeatureModifiers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getTargetURI();
            }
            case 9: {
                return this.getFeatureModifiers();
            }
            case 10: {
                return this.isComplete();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setTargetURI((URI)newValue);
                return;
            }
            case 9: {
                this.getFeatureModifiers().clear();
                this.getFeatureModifiers().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 9: {
                this.getFeatureModifiers().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals((Object)this.targetURI);
            }
            case 9: {
                return this.featureModifiers != null && !this.featureModifiers.isEmpty();
            }
            case 10: {
                return this.isComplete();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (targetURI: ");
        result.append(this.targetURI);
        result.append(')');
        return result.toString();
    }
}

