/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.predicate.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.predicate.ElapsedTimeTest;
import org.eclipse.stem.core.predicate.PredicatePackage;
import org.eclipse.stem.core.predicate.impl.TimeTestImpl;

public class ElapsedTimeTestImpl
extends TimeTestImpl
implements ElapsedTimeTest {
    protected static final boolean REFERENCE_TIME_VALID_EDEFAULT = false;
    protected boolean referenceTimeValid = false;
    protected static final long ELAPSED_MILLISECONDS_EDEFAULT = 0L;
    protected long elapsedMilliseconds = 0L;
    protected static final int NUMBEROF_DAYS_EDEFAULT = 0;
    protected int numberofDays = 0;
    protected STEMTime referenceTime;

    protected ElapsedTimeTestImpl() {
        this.setReferenceTime(ModelFactory.eINSTANCE.createSTEMTime());
    }

    @Override
    protected EClass eStaticClass() {
        return PredicatePackage.Literals.ELAPSED_TIME_TEST;
    }

    @Override
    public boolean isReferenceTimeValid() {
        return this.referenceTimeValid;
    }

    @Override
    public void setReferenceTimeValid(boolean newReferenceTimeValid) {
        boolean oldReferenceTimeValid = this.referenceTimeValid;
        this.referenceTimeValid = newReferenceTimeValid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldReferenceTimeValid, this.referenceTimeValid));
        }
    }

    @Override
    public long getElapsedMilliseconds() {
        return this.elapsedMilliseconds;
    }

    @Override
    public int getNumberofDays() {
        return this.numberofDays;
    }

    @Override
    public void setNumberofDays(int newNumberofDays) {
        int oldNumberofDays = this.getNumberofDays();
        this.numberofDays = newNumberofDays;
        this.elapsedMilliseconds = (long)this.getNumberofDays() * STEMTime.Units.DAY.getMilliseconds();
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldNumberofDays, this.numberofDays));
        }
    }

    @Override
    public STEMTime getReferenceTime() {
        return this.referenceTime;
    }

    public NotificationChain basicSetReferenceTime(STEMTime newReferenceTime, NotificationChain msgs) {
        STEMTime oldReferenceTime = this.referenceTime;
        this.referenceTime = newReferenceTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldReferenceTime, (Object)newReferenceTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setReferenceTime(STEMTime newReferenceTime) {
        if (newReferenceTime != this.referenceTime) {
            NotificationChain msgs = null;
            if (this.referenceTime != null) {
                msgs = ((InternalEObject)this.referenceTime).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newReferenceTime != null) {
                msgs = ((InternalEObject)newReferenceTime).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetReferenceTime(newReferenceTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newReferenceTime, (Object)newReferenceTime));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetReferenceTime(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isReferenceTimeValid();
            }
            case 1: {
                return this.getElapsedMilliseconds();
            }
            case 2: {
                return this.getNumberofDays();
            }
            case 3: {
                return this.getReferenceTime();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setReferenceTimeValid((Boolean)newValue);
                return;
            }
            case 2: {
                this.setNumberofDays((Integer)newValue);
                return;
            }
            case 3: {
                this.setReferenceTime((STEMTime)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setReferenceTimeValid(false);
                return;
            }
            case 2: {
                this.setNumberofDays(0);
                return;
            }
            case 3: {
                this.setReferenceTime(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.referenceTimeValid;
            }
            case 1: {
                return this.elapsedMilliseconds != 0L;
            }
            case 2: {
                return this.numberofDays != 0;
            }
            case 3: {
                return this.referenceTime != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (referenceTimeValid: ");
        result.append(this.referenceTimeValid);
        result.append(", elapsedMilliseconds: ");
        result.append(this.elapsedMilliseconds);
        result.append(", numberofDays: ");
        result.append(this.numberofDays);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean evaluate(STEMTime time, long timerPeriod, Graph graph) {
        boolean retValue = false;
        if (!this.isReferenceTimeValid()) {
            STEMTime newTime = (STEMTime)EcoreUtil.copy((EObject)time);
            newTime = newTime.addIncrement(-timerPeriod);
            this.setReferenceTime(newTime);
            this.setReferenceTimeValid(true);
            return this.evaluate(time, timerPeriod, graph);
        }
        long elapsedTimeMS = time.getTime().getTime() - this.getReferenceTime().getTime().getTime();
        retValue = elapsedTimeMS >= this.getElapsedMilliseconds();
        return retValue;
    }
}

