/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen.descriptor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.model.codegen.descriptor.EClassDescriptor;
import org.eclipse.stem.model.codegen.descriptor.JavaClassDescriptor;
import org.eclipse.stem.model.codegen.descriptor.UnknownElementDescriptor;

public class ModelGeneratorDescriptor {
    protected Map<String, Object> descriptorData = new HashMap<String, Object>();
    protected String modelType;
    protected IConfigurationElement element;

    public ModelGeneratorDescriptor(IConfigurationElement element) {
        this.element = element;
        this.init();
    }

    private void init() {
        this.modelType = this.element.getAttribute("name");
        this.descriptorData.put("extensionPointId", this.element.getAttribute("extensionPointId"));
        this.descriptorData.put("iconPath", this.element.getAttribute("iconPath"));
        IConfigurationElement[] iConfigurationElementArray = this.element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.processElement(child);
            ++n2;
        }
    }

    private void processElement(IConfigurationElement element) {
        if (element.getAttribute("class") != null) {
            this.descriptorData.put(element.getName(), new JavaClassDescriptor(element.getAttribute("class")));
        } else if (element.getAttribute("packageUri") != null && element.getAttribute("className") != null) {
            this.descriptorData.put(element.getName(), new EClassDescriptor(element.getAttribute("packageUri"), element.getAttribute("className")));
        } else {
            this.descriptorData.put(element.getName(), new UnknownElementDescriptor(element));
        }
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getExtensionPointId() {
        return (String)this.descriptorData.get("extensionPointId");
    }

    public String getIconPath() {
        return (String)this.descriptorData.get("iconPath");
    }

    public URI getIconURI() {
        String pathName = "/" + this.element.getContributor().getName() + "/" + this.getIconPath();
        return URI.createPlatformPluginURI((String)pathName, (boolean)true);
    }

    public EClassDescriptor getEClassDescriptor(String key) {
        Object obj = this.descriptorData.get(key);
        if (obj instanceof EClassDescriptor) {
            return (EClassDescriptor)obj;
        }
        return null;
    }

    public JavaClassDescriptor getJavaClassDescriptor(String key) {
        Object obj = this.descriptorData.get(key);
        if (obj instanceof JavaClassDescriptor) {
            return (JavaClassDescriptor)obj;
        }
        return null;
    }

    public EClassDescriptor getBaseModel() {
        return this.getEClassDescriptor("baseModel");
    }

    public EClassDescriptor getBaseLabel() {
        return this.getEClassDescriptor("baseLabel");
    }

    public EClassDescriptor getBaseLabelValue() {
        return this.getEClassDescriptor("baseLabelValue");
    }

    public JavaClassDescriptor getPropertyEditor() {
        return this.getJavaClassDescriptor("propertyEditor");
    }

    public JavaClassDescriptor getPropertyEditorComposite() {
        return this.getJavaClassDescriptor("propertyEditorComposite");
    }

    public JavaClassDescriptor getPropertyEditorAdapter() {
        return this.getJavaClassDescriptor("propertyEditorAdapter");
    }

    public JavaClassDescriptor getPropertyStringAdapter() {
        return this.getJavaClassDescriptor("propertyStringAdapter");
    }

    public JavaClassDescriptor getPropertyEditorAdapterFactory() {
        return this.getJavaClassDescriptor("propertyEditorAdapterFactory");
    }

    public JavaClassDescriptor getPropertyStringAdapterFactory() {
        return this.getJavaClassDescriptor("propertyStringAdapterFactory");
    }

    public JavaClassDescriptor getLabelRelativeValueProvider() {
        return this.getJavaClassDescriptor("labelRelativeValueProvider");
    }

    public JavaClassDescriptor getLabelValueRelativeValueProvider() {
        return this.getJavaClassDescriptor("labelValueRelativeValueProvider");
    }

    public boolean isDescriptorFor(GenClass genClass) {
        for (String key : this.descriptorData.keySet()) {
            if (!this.isDescriptorFor(key, genClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescriptorFor(EClass eClass) {
        for (String key : this.descriptorData.keySet()) {
            if (!this.isDescriptorFor(key, eClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescriptorFor(String dataKey, GenClass genClass) {
        Object obj = this.descriptorData.get(dataKey);
        return obj instanceof EClassDescriptor && ((EClassDescriptor)obj).isSuperTypeOf(genClass);
    }

    public boolean isDescriptorFor(String dataKey, EClass eClass) {
        Object obj = this.descriptorData.get(dataKey);
        return obj instanceof EClassDescriptor && ((EClassDescriptor)obj).isSuperTypeOf(eClass);
    }

    public String toString() {
        return "ModelGeneratorDescriptor [modelType=" + this.modelType + "]";
    }
}

