/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.ui.wizards.NewModelWizard;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class PackagePropertiesPage
extends WizardPage {
    private Package modelPackage;
    private Text pkgNameText;
    private Text pkgPrefixText;
    private TableViewer pkgModelsViewer;
    private Button addModelButton;
    private Button editModelButton;
    private Button removeModelButton;
    private boolean initialized = false;

    protected PackagePropertiesPage(Package pkg) {
        super("Model Package Options");
        this.setTitle("Model Package Options");
        this.setDescription("Configure the model package");
        this.modelPackage = pkg;
    }

    public void setPackage(Package pkg) {
        this.modelPackage = pkg;
        this.populate();
        this.validatePage();
    }

    private void populate() {
        if (this.initialized && this.modelPackage != null) {
            this.pkgNameText.setText(WizardHelper.safeGet(this.modelPackage.getName()));
            this.pkgPrefixText.setText(WizardHelper.safeGet(this.modelPackage.getPackagePrefix()));
            this.pkgModelsViewer.setInput((Object)this.modelPackage.getModels());
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label pkgNameLabel = new Label(container, 0);
        pkgNameLabel.setText("Package Name");
        this.pkgNameText = new Text(container, 2052);
        this.pkgNameText.setLayoutData((Object)new GridData(768));
        this.pkgNameText.setText(WizardHelper.safeGet(this.modelPackage.getName()));
        this.pkgNameText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PackagePropertiesPage.this.validatePage();
            }
        });
        this.pkgNameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                PackagePropertiesPage.this.formatTextFields();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Label pkgPrefixLabel = new Label(container, 0);
        pkgPrefixLabel.setText("Package Prefix");
        this.pkgPrefixText = new Text(container, 2052);
        this.pkgPrefixText.setLayoutData((Object)new GridData(768));
        this.pkgPrefixText.setText(WizardHelper.safeGet(this.modelPackage.getPackagePrefix()));
        this.pkgPrefixText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PackagePropertiesPage.this.validatePage();
            }
        });
        this.pkgPrefixText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                PackagePropertiesPage.this.formatTextFields();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.createPackageModelsViewer(container);
        this.setControl((Control)container);
        this.initialized = true;
    }

    private void createPackageModelsViewer(Composite container) {
        Label pkgModelsLabel = new Label(container, 0);
        pkgModelsLabel.setText("Contained models");
        GridData pkgModelsLabelData = new GridData();
        pkgModelsLabelData.horizontalSpan = 2;
        pkgModelsLabel.setLayoutData((Object)pkgModelsLabelData);
        this.pkgModelsViewer = new TableViewer(container, 68352);
        this.pkgModelsViewer.setUseHashlookup(true);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.pkgModelsViewer.getControl().setLayoutData((Object)gridData);
        this.pkgModelsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.pkgModelsViewer.getTable().setHeaderVisible(true);
        this.pkgModelsViewer.getTable().setLinesVisible(true);
        this.pkgModelsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean selected = PackagePropertiesPage.this.getSelectedModel() != null;
                PackagePropertiesPage.this.editModelButton.setEnabled(selected);
                PackagePropertiesPage.this.removeModelButton.setEnabled(selected);
            }
        });
        this.pkgModelsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackagePropertiesPage.this.editModel();
            }
        });
        TableViewerColumn viewerColumn = null;
        TableColumn column = null;
        viewerColumn = new TableViewerColumn(this.pkgModelsViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Name");
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null) {
                    return ((Model)element).getName();
                }
                return "";
            }
        });
        viewerColumn = new TableViewerColumn(this.pkgModelsViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Model Type");
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Model model = (Model)element;
                if (model != null) {
                    return model.getModelType().getLiteral();
                }
                return "";
            }
        });
        viewerColumn = new TableViewerColumn(this.pkgModelsViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Parent Model");
        column.setWidth(200);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Model model = (Model)element;
                if (model != null && model.getParentModel() != null) {
                    return model.getParentModel().getName();
                }
                return "";
            }
        });
        Composite buttonBarComposite = new Composite(container, 0);
        GridData buttonBarGridData = new GridData(768);
        buttonBarGridData.horizontalSpan = 2;
        buttonBarComposite.setLayoutData((Object)buttonBarGridData);
        buttonBarComposite.setLayout((Layout)new GridLayout(3, false));
        this.addModelButton = new Button(buttonBarComposite, 8);
        this.addModelButton.setEnabled(true);
        this.addModelButton.setText("Add Model");
        this.addModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagePropertiesPage.this.addModel();
            }
        });
        this.editModelButton = new Button(buttonBarComposite, 8);
        this.editModelButton.setEnabled(false);
        this.editModelButton.setText("Edit Model");
        this.editModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagePropertiesPage.this.editModel();
            }
        });
        this.removeModelButton = new Button(buttonBarComposite, 8);
        this.removeModelButton.setEnabled(false);
        this.removeModelButton.setText("Remove Model");
        this.removeModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackagePropertiesPage.this.removeModel();
            }
        });
        this.pkgModelsViewer.setInput((Object)this.modelPackage.getModels());
    }

    private Model openModelEditorDialog(Model existingModel) {
        Model modelToUse = null;
        modelToUse = existingModel == null ? MetamodelFactory.eINSTANCE.createModel() : (Model)EcoreUtil.copy((EObject)existingModel);
        NewModelWizard wizard = new NewModelWizard(modelToUse);
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            return modelToUse;
        }
        return null;
    }

    private void addModel() {
        Model newModel = this.openModelEditorDialog(null);
        if (newModel != null) {
            this.modelPackage.getModels().add((Object)newModel);
            this.modelPackage.getCompartmentGroups().add((Object)newModel.getCompartments());
            this.pkgModelsViewer.refresh();
        }
        this.validatePage();
    }

    private void editModel() {
        Model newModel;
        Model selectedModel = this.getSelectedModel();
        if (selectedModel != null && (newModel = this.openModelEditorDialog(selectedModel)) != null) {
            Collections.replaceAll(this.modelPackage.getModels(), selectedModel, newModel);
            Collections.replaceAll(this.modelPackage.getCompartmentGroups(), selectedModel.getCompartments(), newModel.getCompartments());
            this.pkgModelsViewer.refresh();
        }
        this.validatePage();
    }

    private void removeModel() {
        Model selected = this.getSelectedModel();
        if (selected != null) {
            this.modelPackage.getModels().remove((Object)selected);
            this.modelPackage.getCompartmentGroups().remove((Object)selected.getCompartments());
            this.pkgModelsViewer.refresh();
        }
        this.validatePage();
    }

    private Model getSelectedModel() {
        return (Model)((StructuredSelection)this.pkgModelsViewer.getSelection()).getFirstElement();
    }

    public void applyChanges() {
        this.modelPackage.setName(WizardHelper.safeGet(this.pkgNameText));
        this.modelPackage.setPackagePrefix(WizardHelper.safeGet(this.pkgPrefixText));
    }

    protected void validatePage() {
        boolean valid = this.initialized && this.modelPackage != null;
        String errorMessage = null;
        if (valid && WizardHelper.isNullOrEmpty(this.pkgNameText.getText())) {
            errorMessage = "Enter a name for the package";
            valid = false;
        }
        if (valid && !WizardHelper.isValidJavaName(WizardHelper.formatToUpperCaseWordsNoSpaces(this.pkgNameText.getText()))) {
            errorMessage = "The package name \"" + this.pkgNameText.getText() + "\" is invalid.  Please ensure it contains only alphanumeric characters and does not begin with a number.";
            valid = false;
        }
        if (valid && WizardHelper.isNullOrEmpty(this.pkgPrefixText.getText())) {
            errorMessage = "Enter a package prefix";
            valid = false;
        }
        if (valid && !WizardHelper.isValidJavaPackageName(WizardHelper.formatToJavaPackageName(this.pkgPrefixText.getText()))) {
            errorMessage = "The package prefix \"" + this.pkgPrefixText.getText() + "\" is invalid.  A valid example is \"org.eclipse.stem.models\".";
            valid = false;
        }
        if (valid && this.modelPackage.getModels().size() == 0) {
            errorMessage = "Please add one or more models to this package.";
            valid = false;
        }
        String matchingName = WizardHelper.getFirstMatchingModelName(this.modelPackage);
        if (valid && matchingName != null) {
            errorMessage = "More than one model named \"" + matchingName + "\" in this package";
            valid = false;
        }
        this.setPageComplete(valid);
        this.setErrorMessage(errorMessage);
    }

    private void formatTextFields() {
        this.pkgNameText.setText(WizardHelper.formatToUpperCaseWordsNoSpaces(this.pkgNameText.getText()));
        this.pkgPrefixText.setText(WizardHelper.formatToJavaPackageName(this.pkgPrefixText.getText()));
    }

    public void setVisible(boolean visible) {
        this.validatePage();
        super.setVisible(visible);
    }
}

