/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.site.SiteLabelProvider;

public class SiteOutlinePage
extends FormOutlinePage {
    private LabelProvider fLabelProvider;

    public SiteOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    protected Object[] getChildren(Object parent) {
        ISiteCategoryDefinition catDef;
        ISite site;
        PDEFormPage page;
        ISiteModel model;
        if (parent instanceof PDEFormPage && (model = (ISiteModel)(page = (PDEFormPage)((Object)parent)).getModel()).isValid()) {
            site = model.getSite();
            if (page.getId().equals("features")) {
                ArrayList<Object> result = new ArrayList<Object>();
                ISiteCategoryDefinition[] catDefs = site.getCategoryDefinitions();
                int i = 0;
                while (i < catDefs.length) {
                    result.add(catDefs[i]);
                    ++i;
                }
                ISiteFeature[] features = site.getFeatures();
                int i2 = 0;
                while (i2 < features.length) {
                    if (features[i2].getCategories().length == 0) {
                        result.add(new SiteFeatureAdapter(null, features[i2]));
                    }
                    ++i2;
                }
                return result.toArray();
            }
            if (page.getId().equals("archives")) {
                return site.getArchives();
            }
        }
        if (parent instanceof ISiteCategoryDefinition && (model = (catDef = (ISiteCategoryDefinition)parent).getModel()).isValid()) {
            site = model.getSite();
            ISiteFeature[] features = site.getFeatures();
            HashSet<SiteFeatureAdapter> result = new HashSet<SiteFeatureAdapter>();
            int i = 0;
            while (i < features.length) {
                ISiteCategory[] cats = features[i].getCategories();
                int j = 0;
                while (j < cats.length) {
                    if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                        result.add(new SiteFeatureAdapter(cats[j].getName(), features[i]));
                    }
                    ++j;
                }
                ++i;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    @Override
    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof ISiteCategoryDefinition || item instanceof SiteFeatureAdapter) {
            pageId = "features";
        } else if (item instanceof ISiteArchive) {
            pageId = "archives";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    @Override
    public ILabelProvider createLabelProvider() {
        this.fLabelProvider = new SiteLabelProvider();
        return this.fLabelProvider;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }
}

