/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.Messages;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.IdentifiableFilter;
import org.eclipse.stem.core.common.impl.IdentifiableFilterImpl;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.UnresolvedIdentifiable;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.EdgeDecorator;
import org.eclipse.stem.core.model.GraphDecorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;

public class ModelImpl
extends IdentifiableImpl
implements Model {
    protected EList<Model> models;
    protected EList<Graph> graphs;
    protected EList<GraphDecorator> graphDecorators;
    protected EList<NodeDecorator> nodeDecorators;
    protected EList<EdgeDecorator> edgeDecorators;

    protected ModelImpl() {
        this.setURI(STEMURI.createURI("model/" + STEMURI.generateUniquePart()));
        this.setTypeURI(STEMURI.MODEL_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.MODEL;
    }

    @Override
    public EList<Model> getModels() {
        if (this.models == null) {
            this.models = new EObjectResolvingEList(Model.class, (InternalEObject)this, 3);
        }
        return this.models;
    }

    @Override
    public EList<Graph> getGraphs() {
        if (this.graphs == null) {
            this.graphs = new EObjectResolvingEList(Graph.class, (InternalEObject)this, 4);
        }
        return this.graphs;
    }

    @Override
    public EList<GraphDecorator> getGraphDecorators() {
        if (this.graphDecorators == null) {
            this.graphDecorators = new EObjectResolvingEList(GraphDecorator.class, (InternalEObject)this, 5);
        }
        return this.graphDecorators;
    }

    @Override
    public EList<NodeDecorator> getNodeDecorators() {
        if (this.nodeDecorators == null) {
            this.nodeDecorators = new EObjectResolvingEList(NodeDecorator.class, (InternalEObject)this, 6);
        }
        return this.nodeDecorators;
    }

    @Override
    public EList<EdgeDecorator> getEdgeDecorators() {
        if (this.edgeDecorators == null) {
            this.edgeDecorators = new EObjectResolvingEList(EdgeDecorator.class, (InternalEObject)this, 7);
        }
        return this.edgeDecorators;
    }

    @Override
    public Graph getCanonicalGraph(URI uri, IdentifiableFilter parentFilter, STEMTime time) throws ScenarioInitializationException {
        IdentifiableFilterImpl _parentfilter = (IdentifiableFilterImpl)parentFilter;
        Graph retValue = GraphFactory.eINSTANCE.createGraph();
        retValue.setURI(uri);
        IdentifiableFilterImpl myFilter = new IdentifiableFilterImpl(this.getDublinCore().getCoverage());
        if (parentFilter != null) {
            myFilter.restrict(_parentfilter);
        }
        for (Model model : this.getModels()) {
            retValue.addGraph(model.getCanonicalGraph(uri, myFilter, time), myFilter);
        }
        for (Graph graph : this.getGraphs()) {
            Graph copyGraph = (Graph)EcoreUtil.copy((EObject)graph);
            retValue.addGraph(copyGraph, myFilter);
        }
        this.resolveURIs(this, retValue);
        this.invokeNodeDecorators(retValue, time);
        this.invokeEdgeDecorators(retValue, time);
        this.invokeGraphDecorators(retValue, time);
        DublinCore dc = retValue.getDublinCore();
        dc.populate();
        dc.setFormat("http:///org/eclipse/stem/core/graph.ecore");
        return retValue;
    }

    @Override
    public Graph getCanonicalGraphNoDecorate(URI uri, IdentifiableFilter parentFilter, STEMTime time) throws ScenarioInitializationException {
        IdentifiableFilterImpl _parentfilter = (IdentifiableFilterImpl)parentFilter;
        Graph retValue = GraphFactory.eINSTANCE.createGraph();
        retValue.setURI(uri);
        IdentifiableFilterImpl myFilter = new IdentifiableFilterImpl(this.getDublinCore().getCoverage());
        if (parentFilter != null) {
            myFilter.restrict(_parentfilter);
        }
        for (Model model : this.getModels()) {
            retValue.addGraph(model.getCanonicalGraphNoDecorate(uri, myFilter, time), myFilter);
        }
        for (Graph graph : this.getGraphs()) {
            Graph copyGraph = (Graph)EcoreUtil.copy((EObject)graph);
            retValue.addGraph(copyGraph, myFilter);
        }
        this.resolveURIs(this, retValue);
        DublinCore dc = retValue.getDublinCore();
        dc.populate();
        dc.setFormat("http:///org/eclipse/stem/core/graph.ecore");
        return retValue;
    }

    @Override
    public void prepare(STEMTime time) {
        for (Model model : this.getModels()) {
            model.prepare(time);
        }
        ArrayList list = (ArrayList)EcoreUtil.copyAll(this.getNodeDecorators());
        for (NodeDecorator nodeDecorator : list) {
            nodeDecorator.prepare(this, time);
        }
        ArrayList list2 = (ArrayList)EcoreUtil.copyAll(this.getEdgeDecorators());
        for (EdgeDecorator edgeDecorator : list2) {
            edgeDecorator.prepare(this, time);
        }
        ArrayList list3 = (ArrayList)EcoreUtil.copyAll(this.getGraphDecorators());
        for (GraphDecorator graphDecorator : list3) {
            graphDecorator.prepare(this, time);
        }
    }

    private void resolveURIs(Model model, Graph graph) {
        UnresolvedIdentifiable ui;
        for (Edge edge : graph.getEdges().values()) {
            if (!edge.eIsSet((EStructuralFeature)GraphPackage.Literals.EDGE__A)) {
                Node nodeA = graph.getNode(edge.getNodeAURI());
                if (nodeA != null) {
                    edge.setA(nodeA);
                    nodeA.getEdges().add((Object)edge);
                } else {
                    ui = GraphFactory.eINSTANCE.createUnresolvedIdentifiable();
                    ui.setModel(model);
                    ui.setGraph(graph);
                    ui.setUnresolvedURI(edge.getNodeAURI());
                    ui.setIdentifiable(edge);
                    ui.setFieldName("NODE_A");
                    if (ScenarioImpl.reportDanglingAirTransportEdges || !edge.getURI().toString().contains("/pipetransport")) {
                        graph.getUnresolvedIdentifiables().add((Object)ui);
                    }
                }
            }
            if (edge.eIsSet((EStructuralFeature)GraphPackage.Literals.EDGE__B) || !edge.eIsSet((EStructuralFeature)GraphPackage.Literals.EDGE__A)) continue;
            Node nodeB = graph.getNode(edge.getNodeBURI());
            if (nodeB != null) {
                edge.setB(nodeB);
                nodeB.getEdges().add((Object)edge);
                continue;
            }
            if (edge.getA() != null) {
                Node nodeA = edge.getA();
                edge.setA(null);
                nodeA.getEdges().remove((Object)edge);
            }
            ui = GraphFactory.eINSTANCE.createUnresolvedIdentifiable();
            ui.setModel(model);
            ui.setGraph(graph);
            ui.setUnresolvedURI(edge.getNodeBURI());
            ui.setIdentifiable(edge);
            ui.setFieldName("NODE_B");
            if (!ScenarioImpl.reportDanglingAirTransportEdges && edge.getURI().toString().contains("/pipetransport")) continue;
            graph.getUnresolvedIdentifiables().add((Object)ui);
        }
        for (NodeLabel label : graph.getNodeLabels().values()) {
            Node node = graph.getNode(label.getURIOfIdentifiableToBeLabeled());
            if (node != null) {
                node.getLabels().add((Object)label);
                continue;
            }
            ui = GraphFactory.eINSTANCE.createUnresolvedIdentifiable();
            ui.setModel(model);
            ui.setGraph(graph);
            ui.setUnresolvedURI(label.getURIOfIdentifiableToBeLabeled());
            ui.setIdentifiable(label);
            ui.setFieldName("Node");
            graph.getUnresolvedIdentifiables().add((Object)ui);
        }
    }

    private void invokeNodeDecorators(Graph graph, STEMTime time) throws ScenarioInitializationException {
        int i = 0;
        while (i < this.getNodeDecorators().size()) {
            int j = i + 1;
            while (j < this.getNodeDecorators().size()) {
                if (((NodeDecorator)this.getNodeDecorators().get(i)).getURI().equals(((NodeDecorator)this.getNodeDecorators().get(j)).getURI())) {
                    throw new ScenarioInitializationException(NLS.bind((String)Messages.DUPLICATE_DECORATOR, (Object[])new Object[]{((NodeDecorator)this.getNodeDecorators().get(j)).getURI().toString()}), this, new Exception());
                }
                ++j;
            }
            ++i;
        }
        for (NodeDecorator nodeDecorator : this.getNodeDecorators()) {
            Decorator canonicalDecorator = (Decorator)EcoreUtil.copy((EObject)nodeDecorator);
            graph.getDecorators().add((Object)canonicalDecorator);
        }
        for (Decorator canonicalDecorator : graph.getDecorators()) {
            canonicalDecorator.decorateGraph(time);
            canonicalDecorator.setGraphDecorated(true);
        }
    }

    private void invokeEdgeDecorators(Graph graph, STEMTime time) throws ScenarioInitializationException {
        for (EdgeDecorator edgeDecorator : this.getEdgeDecorators()) {
            Decorator canonicalDecorator = (Decorator)EcoreUtil.copy((EObject)edgeDecorator);
            graph.getDecorators().add((Object)canonicalDecorator);
            canonicalDecorator.decorateGraph(time);
        }
    }

    private void invokeGraphDecorators(Graph graph, STEMTime time) throws ScenarioInitializationException {
        for (GraphDecorator graphDecorator : this.getGraphDecorators()) {
            Decorator canonicalDecorator = (Decorator)EcoreUtil.copy((EObject)graphDecorator);
            graph.getDecorators().add((Object)canonicalDecorator);
            canonicalDecorator.decorateGraph(time);
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getModels();
            }
            case 4: {
                return this.getGraphs();
            }
            case 5: {
                return this.getGraphDecorators();
            }
            case 6: {
                return this.getNodeDecorators();
            }
            case 7: {
                return this.getEdgeDecorators();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getModels().clear();
                this.getModels().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getGraphs().clear();
                this.getGraphs().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getGraphDecorators().clear();
                this.getGraphDecorators().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getNodeDecorators().clear();
                this.getNodeDecorators().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getEdgeDecorators().clear();
                this.getEdgeDecorators().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getModels().clear();
                return;
            }
            case 4: {
                this.getGraphs().clear();
                return;
            }
            case 5: {
                this.getGraphDecorators().clear();
                return;
            }
            case 6: {
                this.getNodeDecorators().clear();
                return;
            }
            case 7: {
                this.getEdgeDecorators().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.models != null && !this.models.isEmpty();
            }
            case 4: {
                return this.graphs != null && !this.graphs.isEmpty();
            }
            case 5: {
                return this.graphDecorators != null && !this.graphDecorators.isEmpty();
            }
            case 6: {
                return this.nodeDecorators != null && !this.nodeDecorators.isEmpty();
            }
            case 7: {
                return this.edgeDecorators != null && !this.edgeDecorators.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("\"" + this.getURI().lastSegment() + "\"\n");
        sb.append(this.getModels() != null ? String.valueOf(this.getModels().size()) + " models\n" : "");
        sb.append(this.getGraphs() != null ? String.valueOf(this.getGraphs().size()) + " graphs\n" : "");
        sb.append(this.getGraphDecorators() != null ? String.valueOf(this.getGraphDecorators().size()) + " graph decorators\n" : "");
        sb.append(this.getNodeDecorators() != null ? String.valueOf(this.getNodeDecorators().size()) + " node decorators\n" : "");
        sb.append(this.getEdgeDecorators() != null ? String.valueOf(this.getEdgeDecorators().size()) + "edge decorators\n" : "");
        return sb.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        if (retValue && this.getModels() != null) {
            Iterator modelIter = this.getModels().iterator();
            while (modelIter.hasNext() && retValue) {
                Model model = (Model)modelIter.next();
                boolean bl = retValue = retValue && model.sane();
                assert (retValue);
            }
        }
        if (retValue && this.getGraphs() != null) {
            Iterator graphIter = this.getGraphs().iterator();
            while (graphIter.hasNext() && retValue) {
                Graph graph = (Graph)graphIter.next();
                boolean bl = retValue = retValue && graph.sane();
                assert (retValue);
            }
        }
        if (retValue && this.getGraphDecorators() != null) {
            Iterator graphDecoratorIter = this.getGraphDecorators().iterator();
            while (graphDecoratorIter.hasNext() && retValue) {
                GraphDecorator graphDecorator = (GraphDecorator)graphDecoratorIter.next();
                boolean bl = retValue = retValue && graphDecorator.sane();
                assert (retValue);
            }
        }
        if (retValue && this.getNodeDecorators() != null) {
            Iterator nodeDecoratorIter = this.getNodeDecorators().iterator();
            while (nodeDecoratorIter.hasNext() && retValue) {
                NodeDecorator nodeDecorator = (NodeDecorator)nodeDecoratorIter.next();
                boolean bl = retValue = retValue && nodeDecorator.sane();
                assert (retValue);
            }
        }
        if (retValue && this.getEdgeDecorators() != null) {
            Iterator edgeDecoratorIter = this.getEdgeDecorators().iterator();
            while (edgeDecoratorIter.hasNext() && retValue) {
                EdgeDecorator edgeDecorator = (EdgeDecorator)edgeDecoratorIter.next();
                boolean bl = retValue = retValue && edgeDecorator.sane();
                assert (retValue);
            }
        }
        return retValue;
    }
}

