/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.foodproduction.FoodProducer;
import org.eclipse.stem.foodproduction.FoodproductionPackage;
import org.eclipse.stem.foodproduction.impl.FoodTransformerImpl;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;

public class FoodProducerImpl
extends FoodTransformerImpl
implements FoodProducer {
    protected static final double FOOD_YIELD_POPULATION_MULTIPLIER_EDEFAULT = 100.0;
    protected double foodYieldPopulationMultiplier = 100.0;
    protected static final double SOURCE_PROCESSING_RATE_EDEFAULT = 1.0;
    protected double sourceProcessingRate = 1.0;

    @Override
    protected EClass eStaticClass() {
        return FoodproductionPackage.Literals.FOOD_PRODUCER;
    }

    @Override
    public double getFoodYieldPopulationMultiplier() {
        return this.foodYieldPopulationMultiplier;
    }

    @Override
    public void setFoodYieldPopulationMultiplier(double newFoodYieldPopulationMultiplier) {
        double oldFoodYieldPopulationMultiplier = this.foodYieldPopulationMultiplier;
        this.foodYieldPopulationMultiplier = newFoodYieldPopulationMultiplier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldFoodYieldPopulationMultiplier, this.foodYieldPopulationMultiplier));
        }
    }

    @Override
    public double getSourceProcessingRate() {
        return this.sourceProcessingRate;
    }

    @Override
    public void setSourceProcessingRate(double newSourceProcessingRate) {
        double oldSourceProcessingRate = this.sourceProcessingRate;
        this.sourceProcessingRate = newSourceProcessingRate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldSourceProcessingRate, this.sourceProcessingRate));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                return this.getFoodYieldPopulationMultiplier();
            }
            case 14: {
                return this.getSourceProcessingRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.setFoodYieldPopulationMultiplier((Double)newValue);
                return;
            }
            case 14: {
                this.setSourceProcessingRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.setFoodYieldPopulationMultiplier(100.0);
                return;
            }
            case 14: {
                this.setSourceProcessingRate(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return this.foodYieldPopulationMultiplier != 100.0;
            }
            case 14: {
                return this.sourceProcessingRate != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (foodYieldPopulationMultiplier: ");
        result.append(this.foodYieldPopulationMultiplier);
        result.append(", sourceProcessingRate: ");
        result.append(this.sourceProcessingRate);
        result.append(')');
        return result.toString();
    }

    public void updateLabels(STEMTime time, long timeDelta, int cycle) {
        String sourcePopulation = this.getSourcePopulationName();
        String foodPopulation = this.getTargetPopulationName();
        for (DynamicLabel dl : this.getSourceLabels()) {
            double sourceConsumed;
            PopulationModelLabel pml;
            if (!(dl instanceof PopulationModelLabel) || !(pml = (PopulationModelLabel)dl).getPopulationIdentifier().equals(sourcePopulation)) continue;
            StandardPopulationModelLabelValue source = (StandardPopulationModelLabelValue)pml.getCurrentValue();
            double sourcePopulationCount = source.getCount();
            double newCount = sourcePopulationCount - (sourceConsumed = this.sourceProcessingRate * ((double)timeDelta / (double)this.getTimePeriod()));
            if (newCount < 0.0) {
                newCount = 0.0;
                sourceConsumed = sourcePopulationCount;
            }
            source.setCount(newCount);
            Node n = (Node)pml.getIdentifiable();
            StandardPopulationModelLabelValue foodPopValue = (StandardPopulationModelLabelValue)n.getLabel(StandardPackage.eINSTANCE.getStandardPopulationModelLabel(), GraphPackage.eINSTANCE.getIntegrationLabel_Identifier(), (Object)foodPopulation).getCurrentValue();
            if (foodPopValue == null) {
                Activator.logError((String)"Cannot find food population label", (Throwable)new Exception());
                continue;
            }
            double foodCreated = sourceConsumed * this.getFoodYieldPopulationMultiplier();
            foodPopValue.setCount(foodPopValue.getCount() + foodCreated);
            double fractionSourceRemaining = (sourcePopulationCount - sourceConsumed) / sourcePopulationCount;
            Node node = ((PopulationModelLabel)dl).getNode();
            EList nlList = node.getLabels();
            for (NodeLabel nl : nlList) {
                DiseaseModelLabel dml;
                String targetPop;
                if (!(nl instanceof DiseaseModelLabel) || !(targetPop = (dml = (DiseaseModelLabel)nl).getIdentifier()).equalsIgnoreCase(this.sourcePopulationName)) continue;
                IntegrationLabelValue ilv = (IntegrationLabelValue)dml.getCurrentValue();
                ilv.scale(fractionSourceRemaining);
            }
        }
    }
}

