/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer;

import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.stem.core.graph.GraphPartitioner;
import org.eclipse.stem.graphsynchronizer.BadConfigFileException;
import org.eclipse.stem.graphsynchronizer.GraphsynchronizerFactory;
import org.eclipse.stem.graphsynchronizer.Messenger;
import org.eclipse.stem.graphsynchronizer.MessengerException;
import org.eclipse.stem.graphsynchronizer.SimulationManagerDelegate;
import org.eclipse.stem.graphsynchronizer.SynchGraphPartitioner;
import org.eclipse.stem.graphsynchronizer.impl.SimulationGraphSynchronizer;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stem.graphsynchronizer";
    private static Activator plugin;
    public static String CONFIGFILE;
    public static String NODERANKKEY;
    public static String NUMNODESKEY;
    public static String MESSENGERCLASSKEY;
    public static String USEBINARYKEY;
    public static String USEZIPKEY;

    static {
        CONFIGFILE = "nodeconfig.properties";
        NODERANKKEY = "NODERANK";
        NUMNODESKEY = "NUMNODES";
        MESSENGERCLASSKEY = "MESSENGERCLASS";
        USEBINARYKEY = "BINARYSERIALIZATION";
        USEZIPKEY = "USEZIP";
    }

    public void start(BundleContext context) throws Exception {
        boolean compress;
        boolean useBinary;
        super.start(context);
        plugin = this;
        SimulationManager manager = SimulationManager.getManager();
        SimulationManagerDelegate smd = new SimulationManagerDelegate();
        manager.addSimulationManagerListenerSync((ISimulationManagerListenerSync)smd);
        SynchGraphPartitioner sgp = GraphsynchronizerFactory.eINSTANCE.createSynchGraphPartitioner();
        manager.setGraphPartitioner((GraphPartitioner)sgp);
        int noderank = -1;
        int numnodes = -1;
        String messengerClass = null;
        Properties config = null;
        try {
            config = new Properties();
            Path path = new Path(CONFIGFILE);
            InputStream is = FileLocator.openStream((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)path, (boolean)false);
            config.load(is);
            is.close();
            try {
                noderank = Integer.parseInt(config.getProperty(NODERANKKEY));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadConfigFileException("Invalid or missing " + NODERANKKEY + " in properties file");
            }
            try {
                numnodes = Integer.parseInt(config.getProperty(NUMNODESKEY));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadConfigFileException("Invalid or missing " + NUMNODESKEY + " in properties file");
            }
            if (noderank < 0 || numnodes < 1) {
                throw new BadConfigFileException("Invalid configuration, " + NODERANKKEY + " must be 0 or greater and " + NUMNODESKEY + " must be 1 or greater");
            }
            messengerClass = config.getProperty(MESSENGERCLASSKEY);
            if (messengerClass == null) {
                throw new BadConfigFileException("Missing messenger class specification");
            }
            useBinary = Boolean.parseBoolean(config.getProperty(USEBINARYKEY));
            compress = Boolean.parseBoolean(config.getProperty(USEZIPKEY));
        }
        catch (Exception e) {
            Activator.logError("Unable to read configuration file for distributed STEM", e);
            return;
        }
        sgp.setNodeRank(noderank);
        sgp.setNumNodes(numnodes);
        Messenger messenger = null;
        try {
            Class<?> messC = Class.forName(messengerClass);
            messenger = (Messenger)messC.newInstance();
        }
        catch (Exception cnfe) {
            Activator.logError("Unable to load or instantiate class " + messengerClass, cnfe);
            return;
        }
        SimulationGraphSynchronizer.messenger = messenger;
        SimulationGraphSynchronizer.BINARYSERIALIZATION = useBinary;
        SimulationGraphSynchronizer.ZIPMESSAGES = compress;
        try {
            messenger.initialize(config);
            messenger.start();
        }
        catch (MessengerException me) {
            Activator.logError("Unable to initialize or start messenger " + messengerClass, me);
            return;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        try {
            SimulationGraphSynchronizer.messenger.stop();
        }
        catch (MessengerException me) {
            me.printStackTrace();
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logError(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public static void logInformation(String message, Throwable exception) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, exception));
        } else {
            System.out.println(message);
            if (exception != null) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public static void logInformation(String message) {
        if (plugin != null) {
            plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, message, null));
        } else {
            System.out.println(message);
        }
    }
}

