/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.execution.IBaseListener;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;

public class SimulationListenerJob
extends Job {
    protected boolean isSynchronous = false;
    protected IBaseListener listener;
    protected SimulationState simulationState;
    protected SimulationEvent event;

    SimulationListenerJob(Simulation simulation, IBaseListener listener, SimulationState state, boolean synchronous) {
        super(String.valueOf(simulation.getUniqueIDString()) + listener.hashCode() + state.toString());
        this.simulationState = state;
        this.listener = listener;
        if (synchronous && listener instanceof ISimulationListenerSync) {
            this.isSynchronous = true;
        }
        this.setPriority(20);
        this.setSystem(true);
    }

    public SimulationState getAssignedSimulationState() {
        return this.simulationState;
    }

    void setSimulationEvent(SimulationEvent event) {
        this.event = event;
    }

    public SimulationEvent getSimulationEvent() {
        return this.event;
    }

    public boolean shouldSchedule() {
        return this.getState() == 0;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.event.setMonitor(monitor);
            if (this.isSynchronous()) {
                ((ISimulationListenerSync)this.listener).simulationChangedSync(this.event);
            } else {
                ((ISimulationListener)this.listener).simulationChanged(this.event);
            }
        }
        catch (Throwable t) {
            Activator.logError(t.getMessage(), t);
        }
        return Status.OK_STATUS;
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }
}

