/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.ModelGenerator;

public class MetamodelRegenerateValidator {
    private Package metamodel;
    private IFile metamodelFile;

    public MetamodelRegenerateValidator(Package metamodel, IFile metamodelFile) {
        this.metamodel = metamodel;
        this.metamodelFile = metamodelFile;
    }

    private static URI getUriForPath(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    private static void safeClose(Reader r) {
        if (r == null) {
            return;
        }
        try {
            r.close();
        }
        catch (Throwable throwable) {}
    }

    private String getGenModelFileAsString(IProgressMonitor monitor) throws CoreException, IOException {
        String string;
        IFile genModelFile;
        BufferedReader reader;
        block4: {
            monitor.beginTask("Reading models", 1);
            reader = null;
            genModelFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.metamodelFile.getLocation().removeFileExtension().addFileExtension("genmodel"));
            if (genModelFile != null) break block4;
            MetamodelRegenerateValidator.safeClose(reader);
            monitor.done();
            return "";
        }
        try {
            reader = new BufferedReader(new InputStreamReader(genModelFile.getContents()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            monitor.worked(1);
            string = builder.toString();
        }
        catch (Throwable throwable) {
            MetamodelRegenerateValidator.safeClose(reader);
            monitor.done();
            throw throwable;
        }
        MetamodelRegenerateValidator.safeClose(reader);
        monitor.done();
        return string;
    }

    private String getGenModelAsString(IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("Serializing models", 10);
        try {
            URI genModelUri = MetamodelRegenerateValidator.getUriForPath(this.getGenModelPath());
            URI ecoreUri = MetamodelRegenerateValidator.getUriForPath(this.getEcorePath());
            ModelGenerator generator = new ModelGenerator(this.metamodel);
            generator.generateEcoreAndGenmodel((IProgressMonitor)new SubProgressMonitor(monitor, 70));
            GenModel genModel = generator.getGenModel();
            EPackage ecore = generator.getEcore();
            monitor.subTask("Creating Ecore Resource");
            ResourceSet rs = generator.getResourceSet();
            Resource ecoreResource = rs.createResource(ecoreUri);
            ecoreResource.getContents().add((Object)ecore);
            monitor.worked(10);
            monitor.subTask("Creating GenModel Resource");
            Resource genModelResource = rs.createResource(genModelUri);
            genModelResource.getContents().add((Object)genModel);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            genModelResource.save((OutputStream)baos, null);
            monitor.worked(20);
            genModelResource.unload();
            ecoreResource.unload();
            String string = baos.toString();
            return string;
        }
        finally {
            monitor.done();
        }
    }

    private IPath getMetamodelPath() {
        return this.metamodelFile.getFullPath();
    }

    private IPath getGenModelPath() {
        return this.getMetamodelPath().removeFileExtension().addFileExtension("genmodel");
    }

    private IPath getEcorePath() {
        return this.getMetamodelPath().removeFileExtension().addFileExtension("ecore");
    }

    public boolean checkNeedRegeneration(IProgressMonitor monitor) throws IOException, CoreException {
        monitor.beginTask("Comparing Model Generator output", 50);
        try {
            String currentGenModel = this.getGenModelFileAsString((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            String newGenModel = this.getGenModelAsString((IProgressMonitor)new SubProgressMonitor(monitor, 40));
            currentGenModel = currentGenModel.replaceAll("\\s", "");
            newGenModel = newGenModel.replaceAll("\\s", "");
            boolean bl = currentGenModel.compareTo(newGenModel) != 0;
            return bl;
        }
        finally {
            monitor.done();
        }
    }
}

